/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appmesh.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that represents a virtual gateway's listener's Transport Layer Security (TLS) validation context trust.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VirtualGatewayListenerTlsValidationContextTrust
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<VirtualGatewayListenerTlsValidationContextTrust.Builder, VirtualGatewayListenerTlsValidationContextTrust> {
    private static final SdkField<VirtualGatewayTlsValidationContextFileTrust> FILE_FIELD = SdkField
            .<VirtualGatewayTlsValidationContextFileTrust> builder(MarshallingType.SDK_POJO).memberName("file")
            .getter(getter(VirtualGatewayListenerTlsValidationContextTrust::file)).setter(setter(Builder::file))
            .constructor(VirtualGatewayTlsValidationContextFileTrust::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("file").build()).build();

    private static final SdkField<VirtualGatewayTlsValidationContextSdsTrust> SDS_FIELD = SdkField
            .<VirtualGatewayTlsValidationContextSdsTrust> builder(MarshallingType.SDK_POJO).memberName("sds")
            .getter(getter(VirtualGatewayListenerTlsValidationContextTrust::sds)).setter(setter(Builder::sds))
            .constructor(VirtualGatewayTlsValidationContextSdsTrust::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sds").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_FIELD, SDS_FIELD));

    private static final long serialVersionUID = 1L;

    private final VirtualGatewayTlsValidationContextFileTrust file;

    private final VirtualGatewayTlsValidationContextSdsTrust sds;

    private VirtualGatewayListenerTlsValidationContextTrust(BuilderImpl builder) {
        this.file = builder.file;
        this.sds = builder.sds;
    }

    /**
     * <p>
     * An object that represents a Transport Layer Security (TLS) validation context trust for a local file.
     * </p>
     * 
     * @return An object that represents a Transport Layer Security (TLS) validation context trust for a local file.
     */
    public final VirtualGatewayTlsValidationContextFileTrust file() {
        return file;
    }

    /**
     * <p>
     * A reference to an object that represents a virtual gateway's listener's Transport Layer Security (TLS) Secret
     * Discovery Service validation context trust.
     * </p>
     * 
     * @return A reference to an object that represents a virtual gateway's listener's Transport Layer Security (TLS)
     *         Secret Discovery Service validation context trust.
     */
    public final VirtualGatewayTlsValidationContextSdsTrust sds() {
        return sds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(file());
        hashCode = 31 * hashCode + Objects.hashCode(sds());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VirtualGatewayListenerTlsValidationContextTrust)) {
            return false;
        }
        VirtualGatewayListenerTlsValidationContextTrust other = (VirtualGatewayListenerTlsValidationContextTrust) obj;
        return Objects.equals(file(), other.file()) && Objects.equals(sds(), other.sds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VirtualGatewayListenerTlsValidationContextTrust").add("File", file()).add("Sds", sds()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "file":
            return Optional.ofNullable(clazz.cast(file()));
        case "sds":
            return Optional.ofNullable(clazz.cast(sds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VirtualGatewayListenerTlsValidationContextTrust, T> g) {
        return obj -> g.apply((VirtualGatewayListenerTlsValidationContextTrust) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VirtualGatewayListenerTlsValidationContextTrust> {
        /**
         * <p>
         * An object that represents a Transport Layer Security (TLS) validation context trust for a local file.
         * </p>
         * 
         * @param file
         *        An object that represents a Transport Layer Security (TLS) validation context trust for a local file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder file(VirtualGatewayTlsValidationContextFileTrust file);

        /**
         * <p>
         * An object that represents a Transport Layer Security (TLS) validation context trust for a local file.
         * </p>
         * This is a convenience that creates an instance of the
         * {@link VirtualGatewayTlsValidationContextFileTrust.Builder} avoiding the need to create one manually via
         * {@link VirtualGatewayTlsValidationContextFileTrust#builder()}.
         *
         * When the {@link Consumer} completes, {@link VirtualGatewayTlsValidationContextFileTrust.Builder#build()} is
         * called immediately and its result is passed to {@link #file(VirtualGatewayTlsValidationContextFileTrust)}.
         * 
         * @param file
         *        a consumer that will call methods on {@link VirtualGatewayTlsValidationContextFileTrust.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #file(VirtualGatewayTlsValidationContextFileTrust)
         */
        default Builder file(Consumer<VirtualGatewayTlsValidationContextFileTrust.Builder> file) {
            return file(VirtualGatewayTlsValidationContextFileTrust.builder().applyMutation(file).build());
        }

        /**
         * <p>
         * A reference to an object that represents a virtual gateway's listener's Transport Layer Security (TLS) Secret
         * Discovery Service validation context trust.
         * </p>
         * 
         * @param sds
         *        A reference to an object that represents a virtual gateway's listener's Transport Layer Security (TLS)
         *        Secret Discovery Service validation context trust.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sds(VirtualGatewayTlsValidationContextSdsTrust sds);

        /**
         * <p>
         * A reference to an object that represents a virtual gateway's listener's Transport Layer Security (TLS) Secret
         * Discovery Service validation context trust.
         * </p>
         * This is a convenience that creates an instance of the
         * {@link VirtualGatewayTlsValidationContextSdsTrust.Builder} avoiding the need to create one manually via
         * {@link VirtualGatewayTlsValidationContextSdsTrust#builder()}.
         *
         * When the {@link Consumer} completes, {@link VirtualGatewayTlsValidationContextSdsTrust.Builder#build()} is
         * called immediately and its result is passed to {@link #sds(VirtualGatewayTlsValidationContextSdsTrust)}.
         * 
         * @param sds
         *        a consumer that will call methods on {@link VirtualGatewayTlsValidationContextSdsTrust.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sds(VirtualGatewayTlsValidationContextSdsTrust)
         */
        default Builder sds(Consumer<VirtualGatewayTlsValidationContextSdsTrust.Builder> sds) {
            return sds(VirtualGatewayTlsValidationContextSdsTrust.builder().applyMutation(sds).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private VirtualGatewayTlsValidationContextFileTrust file;

        private VirtualGatewayTlsValidationContextSdsTrust sds;

        private BuilderImpl() {
        }

        private BuilderImpl(VirtualGatewayListenerTlsValidationContextTrust model) {
            file(model.file);
            sds(model.sds);
        }

        public final VirtualGatewayTlsValidationContextFileTrust.Builder getFile() {
            return file != null ? file.toBuilder() : null;
        }

        public final void setFile(VirtualGatewayTlsValidationContextFileTrust.BuilderImpl file) {
            this.file = file != null ? file.build() : null;
        }

        @Override
        @Transient
        public final Builder file(VirtualGatewayTlsValidationContextFileTrust file) {
            this.file = file;
            return this;
        }

        public final VirtualGatewayTlsValidationContextSdsTrust.Builder getSds() {
            return sds != null ? sds.toBuilder() : null;
        }

        public final void setSds(VirtualGatewayTlsValidationContextSdsTrust.BuilderImpl sds) {
            this.sds = sds != null ? sds.build() : null;
        }

        @Override
        @Transient
        public final Builder sds(VirtualGatewayTlsValidationContextSdsTrust sds) {
            this.sds = sds;
            return this;
        }

        @Override
        public VirtualGatewayListenerTlsValidationContextTrust build() {
            return new VirtualGatewayListenerTlsValidationContextTrust(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
