/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appmesh.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that represents the specification of a virtual service.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VirtualServiceSpec implements SdkPojo, Serializable,
        ToCopyableBuilder<VirtualServiceSpec.Builder, VirtualServiceSpec> {
    private static final SdkField<VirtualServiceProvider> PROVIDER_FIELD = SdkField
            .<VirtualServiceProvider> builder(MarshallingType.SDK_POJO).memberName("provider")
            .getter(getter(VirtualServiceSpec::provider)).setter(setter(Builder::provider))
            .constructor(VirtualServiceProvider::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("provider").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROVIDER_FIELD));

    private static final long serialVersionUID = 1L;

    private final VirtualServiceProvider provider;

    private VirtualServiceSpec(BuilderImpl builder) {
        this.provider = builder.provider;
    }

    /**
     * <p>
     * The App Mesh object that is acting as the provider for a virtual service. You can specify a single virtual node
     * or virtual router.
     * </p>
     * 
     * @return The App Mesh object that is acting as the provider for a virtual service. You can specify a single
     *         virtual node or virtual router.
     */
    public final VirtualServiceProvider provider() {
        return provider;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(provider());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VirtualServiceSpec)) {
            return false;
        }
        VirtualServiceSpec other = (VirtualServiceSpec) obj;
        return Objects.equals(provider(), other.provider());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VirtualServiceSpec").add("Provider", provider()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "provider":
            return Optional.ofNullable(clazz.cast(provider()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VirtualServiceSpec, T> g) {
        return obj -> g.apply((VirtualServiceSpec) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VirtualServiceSpec> {
        /**
         * <p>
         * The App Mesh object that is acting as the provider for a virtual service. You can specify a single virtual
         * node or virtual router.
         * </p>
         * 
         * @param provider
         *        The App Mesh object that is acting as the provider for a virtual service. You can specify a single
         *        virtual node or virtual router.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provider(VirtualServiceProvider provider);

        /**
         * <p>
         * The App Mesh object that is acting as the provider for a virtual service. You can specify a single virtual
         * node or virtual router.
         * </p>
         * This is a convenience that creates an instance of the {@link VirtualServiceProvider.Builder} avoiding the
         * need to create one manually via {@link VirtualServiceProvider#builder()}.
         *
         * When the {@link Consumer} completes, {@link VirtualServiceProvider.Builder#build()} is called immediately and
         * its result is passed to {@link #provider(VirtualServiceProvider)}.
         * 
         * @param provider
         *        a consumer that will call methods on {@link VirtualServiceProvider.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #provider(VirtualServiceProvider)
         */
        default Builder provider(Consumer<VirtualServiceProvider.Builder> provider) {
            return provider(VirtualServiceProvider.builder().applyMutation(provider).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private VirtualServiceProvider provider;

        private BuilderImpl() {
        }

        private BuilderImpl(VirtualServiceSpec model) {
            provider(model.provider);
        }

        public final VirtualServiceProvider.Builder getProvider() {
            return provider != null ? provider.toBuilder() : null;
        }

        public final void setProvider(VirtualServiceProvider.BuilderImpl provider) {
            this.provider = provider != null ? provider.build() : null;
        }

        @Override
        @Transient
        public final Builder provider(VirtualServiceProvider provider) {
            this.provider = provider;
            return this;
        }

        @Override
        public VirtualServiceSpec build() {
            return new VirtualServiceSpec(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
