/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appmesh.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that represents the gateway route to rewrite.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GrpcGatewayRouteRewrite implements SdkPojo, Serializable,
        ToCopyableBuilder<GrpcGatewayRouteRewrite.Builder, GrpcGatewayRouteRewrite> {
    private static final SdkField<GatewayRouteHostnameRewrite> HOSTNAME_FIELD = SdkField
            .<GatewayRouteHostnameRewrite> builder(MarshallingType.SDK_POJO).memberName("hostname")
            .getter(getter(GrpcGatewayRouteRewrite::hostname)).setter(setter(Builder::hostname))
            .constructor(GatewayRouteHostnameRewrite::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hostname").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HOSTNAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final GatewayRouteHostnameRewrite hostname;

    private GrpcGatewayRouteRewrite(BuilderImpl builder) {
        this.hostname = builder.hostname;
    }

    /**
     * <p>
     * The host name of the gateway route to rewrite.
     * </p>
     * 
     * @return The host name of the gateway route to rewrite.
     */
    public final GatewayRouteHostnameRewrite hostname() {
        return hostname;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hostname());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GrpcGatewayRouteRewrite)) {
            return false;
        }
        GrpcGatewayRouteRewrite other = (GrpcGatewayRouteRewrite) obj;
        return Objects.equals(hostname(), other.hostname());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GrpcGatewayRouteRewrite").add("Hostname", hostname()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "hostname":
            return Optional.ofNullable(clazz.cast(hostname()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GrpcGatewayRouteRewrite, T> g) {
        return obj -> g.apply((GrpcGatewayRouteRewrite) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GrpcGatewayRouteRewrite> {
        /**
         * <p>
         * The host name of the gateway route to rewrite.
         * </p>
         * 
         * @param hostname
         *        The host name of the gateway route to rewrite.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostname(GatewayRouteHostnameRewrite hostname);

        /**
         * <p>
         * The host name of the gateway route to rewrite.
         * </p>
         * This is a convenience that creates an instance of the {@link GatewayRouteHostnameRewrite.Builder} avoiding
         * the need to create one manually via {@link GatewayRouteHostnameRewrite#builder()}.
         *
         * When the {@link Consumer} completes, {@link GatewayRouteHostnameRewrite.Builder#build()} is called
         * immediately and its result is passed to {@link #hostname(GatewayRouteHostnameRewrite)}.
         * 
         * @param hostname
         *        a consumer that will call methods on {@link GatewayRouteHostnameRewrite.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #hostname(GatewayRouteHostnameRewrite)
         */
        default Builder hostname(Consumer<GatewayRouteHostnameRewrite.Builder> hostname) {
            return hostname(GatewayRouteHostnameRewrite.builder().applyMutation(hostname).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private GatewayRouteHostnameRewrite hostname;

        private BuilderImpl() {
        }

        private BuilderImpl(GrpcGatewayRouteRewrite model) {
            hostname(model.hostname);
        }

        public final GatewayRouteHostnameRewrite.Builder getHostname() {
            return hostname != null ? hostname.toBuilder() : null;
        }

        public final void setHostname(GatewayRouteHostnameRewrite.BuilderImpl hostname) {
            this.hostname = hostname != null ? hostname.build() : null;
        }

        @Override
        @Transient
        public final Builder hostname(GatewayRouteHostnameRewrite hostname) {
            this.hostname = hostname;
            return this;
        }

        @Override
        public GrpcGatewayRouteRewrite build() {
            return new GrpcGatewayRouteRewrite(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
