/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appmesh.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that represents a gRPC gateway route.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GrpcGatewayRoute implements SdkPojo, Serializable,
        ToCopyableBuilder<GrpcGatewayRoute.Builder, GrpcGatewayRoute> {
    private static final SdkField<GrpcGatewayRouteAction> ACTION_FIELD = SdkField
            .<GrpcGatewayRouteAction> builder(MarshallingType.SDK_POJO).memberName("action")
            .getter(getter(GrpcGatewayRoute::action)).setter(setter(Builder::action))
            .constructor(GrpcGatewayRouteAction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("action").build()).build();

    private static final SdkField<GrpcGatewayRouteMatch> MATCH_FIELD = SdkField
            .<GrpcGatewayRouteMatch> builder(MarshallingType.SDK_POJO).memberName("match")
            .getter(getter(GrpcGatewayRoute::match)).setter(setter(Builder::match)).constructor(GrpcGatewayRouteMatch::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("match").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FIELD, MATCH_FIELD));

    private static final long serialVersionUID = 1L;

    private final GrpcGatewayRouteAction action;

    private final GrpcGatewayRouteMatch match;

    private GrpcGatewayRoute(BuilderImpl builder) {
        this.action = builder.action;
        this.match = builder.match;
    }

    /**
     * <p>
     * An object that represents the action to take if a match is determined.
     * </p>
     * 
     * @return An object that represents the action to take if a match is determined.
     */
    public final GrpcGatewayRouteAction action() {
        return action;
    }

    /**
     * <p>
     * An object that represents the criteria for determining a request match.
     * </p>
     * 
     * @return An object that represents the criteria for determining a request match.
     */
    public final GrpcGatewayRouteMatch match() {
        return match;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(action());
        hashCode = 31 * hashCode + Objects.hashCode(match());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GrpcGatewayRoute)) {
            return false;
        }
        GrpcGatewayRoute other = (GrpcGatewayRoute) obj;
        return Objects.equals(action(), other.action()) && Objects.equals(match(), other.match());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GrpcGatewayRoute").add("Action", action()).add("Match", match()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "action":
            return Optional.ofNullable(clazz.cast(action()));
        case "match":
            return Optional.ofNullable(clazz.cast(match()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GrpcGatewayRoute, T> g) {
        return obj -> g.apply((GrpcGatewayRoute) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GrpcGatewayRoute> {
        /**
         * <p>
         * An object that represents the action to take if a match is determined.
         * </p>
         * 
         * @param action
         *        An object that represents the action to take if a match is determined.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder action(GrpcGatewayRouteAction action);

        /**
         * <p>
         * An object that represents the action to take if a match is determined.
         * </p>
         * This is a convenience that creates an instance of the {@link GrpcGatewayRouteAction.Builder} avoiding the
         * need to create one manually via {@link GrpcGatewayRouteAction#builder()}.
         *
         * When the {@link Consumer} completes, {@link GrpcGatewayRouteAction.Builder#build()} is called immediately and
         * its result is passed to {@link #action(GrpcGatewayRouteAction)}.
         * 
         * @param action
         *        a consumer that will call methods on {@link GrpcGatewayRouteAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #action(GrpcGatewayRouteAction)
         */
        default Builder action(Consumer<GrpcGatewayRouteAction.Builder> action) {
            return action(GrpcGatewayRouteAction.builder().applyMutation(action).build());
        }

        /**
         * <p>
         * An object that represents the criteria for determining a request match.
         * </p>
         * 
         * @param match
         *        An object that represents the criteria for determining a request match.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder match(GrpcGatewayRouteMatch match);

        /**
         * <p>
         * An object that represents the criteria for determining a request match.
         * </p>
         * This is a convenience that creates an instance of the {@link GrpcGatewayRouteMatch.Builder} avoiding the need
         * to create one manually via {@link GrpcGatewayRouteMatch#builder()}.
         *
         * When the {@link Consumer} completes, {@link GrpcGatewayRouteMatch.Builder#build()} is called immediately and
         * its result is passed to {@link #match(GrpcGatewayRouteMatch)}.
         * 
         * @param match
         *        a consumer that will call methods on {@link GrpcGatewayRouteMatch.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #match(GrpcGatewayRouteMatch)
         */
        default Builder match(Consumer<GrpcGatewayRouteMatch.Builder> match) {
            return match(GrpcGatewayRouteMatch.builder().applyMutation(match).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private GrpcGatewayRouteAction action;

        private GrpcGatewayRouteMatch match;

        private BuilderImpl() {
        }

        private BuilderImpl(GrpcGatewayRoute model) {
            action(model.action);
            match(model.match);
        }

        public final GrpcGatewayRouteAction.Builder getAction() {
            return action != null ? action.toBuilder() : null;
        }

        public final void setAction(GrpcGatewayRouteAction.BuilderImpl action) {
            this.action = action != null ? action.build() : null;
        }

        @Override
        @Transient
        public final Builder action(GrpcGatewayRouteAction action) {
            this.action = action;
            return this;
        }

        public final GrpcGatewayRouteMatch.Builder getMatch() {
            return match != null ? match.toBuilder() : null;
        }

        public final void setMatch(GrpcGatewayRouteMatch.BuilderImpl match) {
            this.match = match != null ? match.build() : null;
        }

        @Override
        @Transient
        public final Builder match(GrpcGatewayRouteMatch match) {
            this.match = match;
            return this;
        }

        @Override
        public GrpcGatewayRoute build() {
            return new GrpcGatewayRoute(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
