/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appmesh.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that represents a type of connection pool.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VirtualGatewayHttpConnectionPool implements SdkPojo, Serializable,
        ToCopyableBuilder<VirtualGatewayHttpConnectionPool.Builder, VirtualGatewayHttpConnectionPool> {
    private static final SdkField<Integer> MAX_CONNECTIONS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxConnections").getter(getter(VirtualGatewayHttpConnectionPool::maxConnections))
            .setter(setter(Builder::maxConnections))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxConnections").build()).build();

    private static final SdkField<Integer> MAX_PENDING_REQUESTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxPendingRequests").getter(getter(VirtualGatewayHttpConnectionPool::maxPendingRequests))
            .setter(setter(Builder::maxPendingRequests))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxPendingRequests").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_CONNECTIONS_FIELD,
            MAX_PENDING_REQUESTS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer maxConnections;

    private final Integer maxPendingRequests;

    private VirtualGatewayHttpConnectionPool(BuilderImpl builder) {
        this.maxConnections = builder.maxConnections;
        this.maxPendingRequests = builder.maxPendingRequests;
    }

    /**
     * <p>
     * Maximum number of outbound TCP connections Envoy can establish concurrently with all hosts in upstream cluster.
     * </p>
     * 
     * @return Maximum number of outbound TCP connections Envoy can establish concurrently with all hosts in upstream
     *         cluster.
     */
    public final Integer maxConnections() {
        return maxConnections;
    }

    /**
     * <p>
     * Number of overflowing requests after <code>max_connections</code> Envoy will queue to upstream cluster.
     * </p>
     * 
     * @return Number of overflowing requests after <code>max_connections</code> Envoy will queue to upstream cluster.
     */
    public final Integer maxPendingRequests() {
        return maxPendingRequests;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(maxConnections());
        hashCode = 31 * hashCode + Objects.hashCode(maxPendingRequests());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VirtualGatewayHttpConnectionPool)) {
            return false;
        }
        VirtualGatewayHttpConnectionPool other = (VirtualGatewayHttpConnectionPool) obj;
        return Objects.equals(maxConnections(), other.maxConnections())
                && Objects.equals(maxPendingRequests(), other.maxPendingRequests());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VirtualGatewayHttpConnectionPool").add("MaxConnections", maxConnections())
                .add("MaxPendingRequests", maxPendingRequests()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "maxConnections":
            return Optional.ofNullable(clazz.cast(maxConnections()));
        case "maxPendingRequests":
            return Optional.ofNullable(clazz.cast(maxPendingRequests()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VirtualGatewayHttpConnectionPool, T> g) {
        return obj -> g.apply((VirtualGatewayHttpConnectionPool) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VirtualGatewayHttpConnectionPool> {
        /**
         * <p>
         * Maximum number of outbound TCP connections Envoy can establish concurrently with all hosts in upstream
         * cluster.
         * </p>
         * 
         * @param maxConnections
         *        Maximum number of outbound TCP connections Envoy can establish concurrently with all hosts in upstream
         *        cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxConnections(Integer maxConnections);

        /**
         * <p>
         * Number of overflowing requests after <code>max_connections</code> Envoy will queue to upstream cluster.
         * </p>
         * 
         * @param maxPendingRequests
         *        Number of overflowing requests after <code>max_connections</code> Envoy will queue to upstream
         *        cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxPendingRequests(Integer maxPendingRequests);
    }

    static final class BuilderImpl implements Builder {
        private Integer maxConnections;

        private Integer maxPendingRequests;

        private BuilderImpl() {
        }

        private BuilderImpl(VirtualGatewayHttpConnectionPool model) {
            maxConnections(model.maxConnections);
            maxPendingRequests(model.maxPendingRequests);
        }

        public final Integer getMaxConnections() {
            return maxConnections;
        }

        public final void setMaxConnections(Integer maxConnections) {
            this.maxConnections = maxConnections;
        }

        @Override
        @Transient
        public final Builder maxConnections(Integer maxConnections) {
            this.maxConnections = maxConnections;
            return this;
        }

        public final Integer getMaxPendingRequests() {
            return maxPendingRequests;
        }

        public final void setMaxPendingRequests(Integer maxPendingRequests) {
            this.maxPendingRequests = maxPendingRequests;
        }

        @Override
        @Transient
        public final Builder maxPendingRequests(Integer maxPendingRequests) {
            this.maxPendingRequests = maxPendingRequests;
            return this;
        }

        @Override
        public VirtualGatewayHttpConnectionPool build() {
            return new VirtualGatewayHttpConnectionPool(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
