/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appmesh.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that represents a type of connection pool.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VirtualNodeTcpConnectionPool implements SdkPojo, Serializable,
        ToCopyableBuilder<VirtualNodeTcpConnectionPool.Builder, VirtualNodeTcpConnectionPool> {
    private static final SdkField<Integer> MAX_CONNECTIONS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxConnections").getter(getter(VirtualNodeTcpConnectionPool::maxConnections))
            .setter(setter(Builder::maxConnections))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxConnections").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_CONNECTIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer maxConnections;

    private VirtualNodeTcpConnectionPool(BuilderImpl builder) {
        this.maxConnections = builder.maxConnections;
    }

    /**
     * <p>
     * Maximum number of outbound TCP connections Envoy can establish concurrently with all hosts in upstream cluster.
     * </p>
     * 
     * @return Maximum number of outbound TCP connections Envoy can establish concurrently with all hosts in upstream
     *         cluster.
     */
    public final Integer maxConnections() {
        return maxConnections;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(maxConnections());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VirtualNodeTcpConnectionPool)) {
            return false;
        }
        VirtualNodeTcpConnectionPool other = (VirtualNodeTcpConnectionPool) obj;
        return Objects.equals(maxConnections(), other.maxConnections());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VirtualNodeTcpConnectionPool").add("MaxConnections", maxConnections()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "maxConnections":
            return Optional.ofNullable(clazz.cast(maxConnections()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VirtualNodeTcpConnectionPool, T> g) {
        return obj -> g.apply((VirtualNodeTcpConnectionPool) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VirtualNodeTcpConnectionPool> {
        /**
         * <p>
         * Maximum number of outbound TCP connections Envoy can establish concurrently with all hosts in upstream
         * cluster.
         * </p>
         * 
         * @param maxConnections
         *        Maximum number of outbound TCP connections Envoy can establish concurrently with all hosts in upstream
         *        cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxConnections(Integer maxConnections);
    }

    static final class BuilderImpl implements Builder {
        private Integer maxConnections;

        private BuilderImpl() {
        }

        private BuilderImpl(VirtualNodeTcpConnectionPool model) {
            maxConnections(model.maxConnections);
        }

        public final Integer getMaxConnections() {
            return maxConnections;
        }

        public final void setMaxConnections(Integer maxConnections) {
            this.maxConnections = maxConnections;
        }

        @Override
        @Transient
        public final Builder maxConnections(Integer maxConnections) {
            this.maxConnections = maxConnections;
            return this;
        }

        @Override
        public VirtualNodeTcpConnectionPool build() {
            return new VirtualNodeTcpConnectionPool(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
