/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appmesh.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object representing the path to match in the request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HttpPathMatch implements SdkPojo, Serializable, ToCopyableBuilder<HttpPathMatch.Builder, HttpPathMatch> {
    private static final SdkField<String> EXACT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("exact")
            .getter(getter(HttpPathMatch::exact)).setter(setter(Builder::exact))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exact").build()).build();

    private static final SdkField<String> REGEX_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("regex")
            .getter(getter(HttpPathMatch::regex)).setter(setter(Builder::regex))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("regex").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXACT_FIELD, REGEX_FIELD));

    private static final long serialVersionUID = 1L;

    private final String exact;

    private final String regex;

    private HttpPathMatch(BuilderImpl builder) {
        this.exact = builder.exact;
        this.regex = builder.regex;
    }

    /**
     * <p>
     * The exact path to match on.
     * </p>
     * 
     * @return The exact path to match on.
     */
    public final String exact() {
        return exact;
    }

    /**
     * <p>
     * The regex used to match the path.
     * </p>
     * 
     * @return The regex used to match the path.
     */
    public final String regex() {
        return regex;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(exact());
        hashCode = 31 * hashCode + Objects.hashCode(regex());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HttpPathMatch)) {
            return false;
        }
        HttpPathMatch other = (HttpPathMatch) obj;
        return Objects.equals(exact(), other.exact()) && Objects.equals(regex(), other.regex());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("HttpPathMatch").add("Exact", exact()).add("Regex", regex()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "exact":
            return Optional.ofNullable(clazz.cast(exact()));
        case "regex":
            return Optional.ofNullable(clazz.cast(regex()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HttpPathMatch, T> g) {
        return obj -> g.apply((HttpPathMatch) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HttpPathMatch> {
        /**
         * <p>
         * The exact path to match on.
         * </p>
         * 
         * @param exact
         *        The exact path to match on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exact(String exact);

        /**
         * <p>
         * The regex used to match the path.
         * </p>
         * 
         * @param regex
         *        The regex used to match the path.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regex(String regex);
    }

    static final class BuilderImpl implements Builder {
        private String exact;

        private String regex;

        private BuilderImpl() {
        }

        private BuilderImpl(HttpPathMatch model) {
            exact(model.exact);
            regex(model.regex);
        }

        public final String getExact() {
            return exact;
        }

        public final void setExact(String exact) {
            this.exact = exact;
        }

        @Override
        @Transient
        public final Builder exact(String exact) {
            this.exact = exact;
            return this;
        }

        public final String getRegex() {
            return regex;
        }

        public final void setRegex(String regex) {
            this.regex = regex;
        }

        @Override
        @Transient
        public final Builder regex(String regex) {
            this.regex = regex;
            return this;
        }

        @Override
        public HttpPathMatch build() {
            return new HttpPathMatch(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
