/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appmesh.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateGatewayRouteRequest extends AppMeshRequest implements
        ToCopyableBuilder<UpdateGatewayRouteRequest.Builder, UpdateGatewayRouteRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(UpdateGatewayRouteRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> GATEWAY_ROUTE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("gatewayRouteName").getter(getter(UpdateGatewayRouteRequest::gatewayRouteName))
            .setter(setter(Builder::gatewayRouteName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("gatewayRouteName").build()).build();

    private static final SdkField<String> MESH_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("meshName").getter(getter(UpdateGatewayRouteRequest::meshName)).setter(setter(Builder::meshName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("meshName").build()).build();

    private static final SdkField<String> MESH_OWNER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("meshOwner").getter(getter(UpdateGatewayRouteRequest::meshOwner)).setter(setter(Builder::meshOwner))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("meshOwner").build()).build();

    private static final SdkField<GatewayRouteSpec> SPEC_FIELD = SdkField.<GatewayRouteSpec> builder(MarshallingType.SDK_POJO)
            .memberName("spec").getter(getter(UpdateGatewayRouteRequest::spec)).setter(setter(Builder::spec))
            .constructor(GatewayRouteSpec::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("spec").build()).build();

    private static final SdkField<String> VIRTUAL_GATEWAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("virtualGatewayName").getter(getter(UpdateGatewayRouteRequest::virtualGatewayName))
            .setter(setter(Builder::virtualGatewayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("virtualGatewayName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            GATEWAY_ROUTE_NAME_FIELD, MESH_NAME_FIELD, MESH_OWNER_FIELD, SPEC_FIELD, VIRTUAL_GATEWAY_NAME_FIELD));

    private final String clientToken;

    private final String gatewayRouteName;

    private final String meshName;

    private final String meshOwner;

    private final GatewayRouteSpec spec;

    private final String virtualGatewayName;

    private UpdateGatewayRouteRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.gatewayRouteName = builder.gatewayRouteName;
        this.meshName = builder.meshName;
        this.meshOwner = builder.meshOwner;
        this.spec = builder.spec;
        this.virtualGatewayName = builder.virtualGatewayName;
    }

    /**
     * <p>
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 36 letters,
     * numbers, hyphens, and underscores are allowed.
     * </p>
     * 
     * @return Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 36
     *         letters, numbers, hyphens, and underscores are allowed.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The name of the gateway route to update.
     * </p>
     * 
     * @return The name of the gateway route to update.
     */
    public final String gatewayRouteName() {
        return gatewayRouteName;
    }

    /**
     * <p>
     * The name of the service mesh that the gateway route resides in.
     * </p>
     * 
     * @return The name of the service mesh that the gateway route resides in.
     */
    public final String meshName() {
        return meshName;
    }

    /**
     * <p>
     * The Amazon Web Services IAM account ID of the service mesh owner. If the account ID is not your own, then it's
     * the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a
     * href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a>.
     * </p>
     * 
     * @return The Amazon Web Services IAM account ID of the service mesh owner. If the account ID is not your own, then
     *         it's the ID of the account that shared the mesh with your account. For more information about mesh
     *         sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with
     *         shared meshes</a>.
     */
    public final String meshOwner() {
        return meshOwner;
    }

    /**
     * <p>
     * The new gateway route specification to apply. This overwrites the existing data.
     * </p>
     * 
     * @return The new gateway route specification to apply. This overwrites the existing data.
     */
    public final GatewayRouteSpec spec() {
        return spec;
    }

    /**
     * <p>
     * The name of the virtual gateway that the gateway route is associated with.
     * </p>
     * 
     * @return The name of the virtual gateway that the gateway route is associated with.
     */
    public final String virtualGatewayName() {
        return virtualGatewayName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(gatewayRouteName());
        hashCode = 31 * hashCode + Objects.hashCode(meshName());
        hashCode = 31 * hashCode + Objects.hashCode(meshOwner());
        hashCode = 31 * hashCode + Objects.hashCode(spec());
        hashCode = 31 * hashCode + Objects.hashCode(virtualGatewayName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateGatewayRouteRequest)) {
            return false;
        }
        UpdateGatewayRouteRequest other = (UpdateGatewayRouteRequest) obj;
        return Objects.equals(clientToken(), other.clientToken()) && Objects.equals(gatewayRouteName(), other.gatewayRouteName())
                && Objects.equals(meshName(), other.meshName()) && Objects.equals(meshOwner(), other.meshOwner())
                && Objects.equals(spec(), other.spec()) && Objects.equals(virtualGatewayName(), other.virtualGatewayName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateGatewayRouteRequest").add("ClientToken", clientToken())
                .add("GatewayRouteName", gatewayRouteName()).add("MeshName", meshName()).add("MeshOwner", meshOwner())
                .add("Spec", spec()).add("VirtualGatewayName", virtualGatewayName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "gatewayRouteName":
            return Optional.ofNullable(clazz.cast(gatewayRouteName()));
        case "meshName":
            return Optional.ofNullable(clazz.cast(meshName()));
        case "meshOwner":
            return Optional.ofNullable(clazz.cast(meshOwner()));
        case "spec":
            return Optional.ofNullable(clazz.cast(spec()));
        case "virtualGatewayName":
            return Optional.ofNullable(clazz.cast(virtualGatewayName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateGatewayRouteRequest, T> g) {
        return obj -> g.apply((UpdateGatewayRouteRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppMeshRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateGatewayRouteRequest> {
        /**
         * <p>
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 36
         * letters, numbers, hyphens, and underscores are allowed.
         * </p>
         * 
         * @param clientToken
         *        Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 36
         *        letters, numbers, hyphens, and underscores are allowed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The name of the gateway route to update.
         * </p>
         * 
         * @param gatewayRouteName
         *        The name of the gateway route to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayRouteName(String gatewayRouteName);

        /**
         * <p>
         * The name of the service mesh that the gateway route resides in.
         * </p>
         * 
         * @param meshName
         *        The name of the service mesh that the gateway route resides in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder meshName(String meshName);

        /**
         * <p>
         * The Amazon Web Services IAM account ID of the service mesh owner. If the account ID is not your own, then
         * it's the ID of the account that shared the mesh with your account. For more information about mesh sharing,
         * see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared
         * meshes</a>.
         * </p>
         * 
         * @param meshOwner
         *        The Amazon Web Services IAM account ID of the service mesh owner. If the account ID is not your own,
         *        then it's the ID of the account that shared the mesh with your account. For more information about
         *        mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working
         *        with shared meshes</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder meshOwner(String meshOwner);

        /**
         * <p>
         * The new gateway route specification to apply. This overwrites the existing data.
         * </p>
         * 
         * @param spec
         *        The new gateway route specification to apply. This overwrites the existing data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spec(GatewayRouteSpec spec);

        /**
         * <p>
         * The new gateway route specification to apply. This overwrites the existing data.
         * </p>
         * This is a convenience method that creates an instance of the {@link GatewayRouteSpec.Builder} avoiding the
         * need to create one manually via {@link GatewayRouteSpec#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GatewayRouteSpec.Builder#build()} is called immediately and its
         * result is passed to {@link #spec(GatewayRouteSpec)}.
         * 
         * @param spec
         *        a consumer that will call methods on {@link GatewayRouteSpec.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #spec(GatewayRouteSpec)
         */
        default Builder spec(Consumer<GatewayRouteSpec.Builder> spec) {
            return spec(GatewayRouteSpec.builder().applyMutation(spec).build());
        }

        /**
         * <p>
         * The name of the virtual gateway that the gateway route is associated with.
         * </p>
         * 
         * @param virtualGatewayName
         *        The name of the virtual gateway that the gateway route is associated with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder virtualGatewayName(String virtualGatewayName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AppMeshRequest.BuilderImpl implements Builder {
        private String clientToken;

        private String gatewayRouteName;

        private String meshName;

        private String meshOwner;

        private GatewayRouteSpec spec;

        private String virtualGatewayName;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateGatewayRouteRequest model) {
            super(model);
            clientToken(model.clientToken);
            gatewayRouteName(model.gatewayRouteName);
            meshName(model.meshName);
            meshOwner(model.meshOwner);
            spec(model.spec);
            virtualGatewayName(model.virtualGatewayName);
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getGatewayRouteName() {
            return gatewayRouteName;
        }

        public final void setGatewayRouteName(String gatewayRouteName) {
            this.gatewayRouteName = gatewayRouteName;
        }

        @Override
        public final Builder gatewayRouteName(String gatewayRouteName) {
            this.gatewayRouteName = gatewayRouteName;
            return this;
        }

        public final String getMeshName() {
            return meshName;
        }

        public final void setMeshName(String meshName) {
            this.meshName = meshName;
        }

        @Override
        public final Builder meshName(String meshName) {
            this.meshName = meshName;
            return this;
        }

        public final String getMeshOwner() {
            return meshOwner;
        }

        public final void setMeshOwner(String meshOwner) {
            this.meshOwner = meshOwner;
        }

        @Override
        public final Builder meshOwner(String meshOwner) {
            this.meshOwner = meshOwner;
            return this;
        }

        public final GatewayRouteSpec.Builder getSpec() {
            return spec != null ? spec.toBuilder() : null;
        }

        public final void setSpec(GatewayRouteSpec.BuilderImpl spec) {
            this.spec = spec != null ? spec.build() : null;
        }

        @Override
        public final Builder spec(GatewayRouteSpec spec) {
            this.spec = spec;
            return this;
        }

        public final String getVirtualGatewayName() {
            return virtualGatewayName;
        }

        public final void setVirtualGatewayName(String virtualGatewayName) {
            this.virtualGatewayName = virtualGatewayName;
        }

        @Override
        public final Builder virtualGatewayName(String virtualGatewayName) {
            this.virtualGatewayName = virtualGatewayName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateGatewayRouteRequest build() {
            return new UpdateGatewayRouteRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
