/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appmesh.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object representing a target and its relative weight. Traffic is distributed across targets according to their
 * relative weight. For example, a weighted target with a relative weight of 50 receives five times as much traffic as
 * one with a relative weight of 10.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WeightedTarget implements SdkPojo, Serializable, ToCopyableBuilder<WeightedTarget.Builder, WeightedTarget> {
    private static final SdkField<String> VIRTUAL_NODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(WeightedTarget::virtualNode)).setter(setter(Builder::virtualNode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("virtualNode").build()).build();

    private static final SdkField<Integer> WEIGHT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(WeightedTarget::weight)).setter(setter(Builder::weight))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("weight").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VIRTUAL_NODE_FIELD,
            WEIGHT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String virtualNode;

    private final Integer weight;

    private WeightedTarget(BuilderImpl builder) {
        this.virtualNode = builder.virtualNode;
        this.weight = builder.weight;
    }

    /**
     * <p>
     * The virtual node to associate with the weighted target.
     * </p>
     * 
     * @return The virtual node to associate with the weighted target.
     */
    public String virtualNode() {
        return virtualNode;
    }

    /**
     * <p>
     * The relative weight of the weighted target.
     * </p>
     * 
     * @return The relative weight of the weighted target.
     */
    public Integer weight() {
        return weight;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(virtualNode());
        hashCode = 31 * hashCode + Objects.hashCode(weight());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WeightedTarget)) {
            return false;
        }
        WeightedTarget other = (WeightedTarget) obj;
        return Objects.equals(virtualNode(), other.virtualNode()) && Objects.equals(weight(), other.weight());
    }

    @Override
    public String toString() {
        return ToString.builder("WeightedTarget").add("VirtualNode", virtualNode()).add("Weight", weight()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "virtualNode":
            return Optional.ofNullable(clazz.cast(virtualNode()));
        case "weight":
            return Optional.ofNullable(clazz.cast(weight()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WeightedTarget, T> g) {
        return obj -> g.apply((WeightedTarget) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WeightedTarget> {
        /**
         * <p>
         * The virtual node to associate with the weighted target.
         * </p>
         * 
         * @param virtualNode
         *        The virtual node to associate with the weighted target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder virtualNode(String virtualNode);

        /**
         * <p>
         * The relative weight of the weighted target.
         * </p>
         * 
         * @param weight
         *        The relative weight of the weighted target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder weight(Integer weight);
    }

    static final class BuilderImpl implements Builder {
        private String virtualNode;

        private Integer weight;

        private BuilderImpl() {
        }

        private BuilderImpl(WeightedTarget model) {
            virtualNode(model.virtualNode);
            weight(model.weight);
        }

        public final String getVirtualNode() {
            return virtualNode;
        }

        @Override
        public final Builder virtualNode(String virtualNode) {
            this.virtualNode = virtualNode;
            return this;
        }

        public final void setVirtualNode(String virtualNode) {
            this.virtualNode = virtualNode;
        }

        public final Integer getWeight() {
            return weight;
        }

        @Override
        public final Builder weight(Integer weight) {
            this.weight = weight;
            return this;
        }

        public final void setWeight(Integer weight) {
            this.weight = weight;
        }

        @Override
        public WeightedTarget build() {
            return new WeightedTarget(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
