/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appmesh.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListVirtualNodesResponse extends AppMeshResponse implements
        ToCopyableBuilder<ListVirtualNodesResponse.Builder, ListVirtualNodesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListVirtualNodesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<VirtualNodeRef>> VIRTUAL_NODES_FIELD = SdkField
            .<List<VirtualNodeRef>> builder(MarshallingType.LIST)
            .getter(getter(ListVirtualNodesResponse::virtualNodes))
            .setter(setter(Builder::virtualNodes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("virtualNodes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<VirtualNodeRef> builder(MarshallingType.SDK_POJO)
                                            .constructor(VirtualNodeRef::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            VIRTUAL_NODES_FIELD));

    private final String nextToken;

    private final List<VirtualNodeRef> virtualNodes;

    private ListVirtualNodesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.virtualNodes = builder.virtualNodes;
    }

    /**
     * <p>
     * The <code>nextToken</code> value to include in a future <code>ListVirtualNodes</code> request. When the results
     * of a <code>ListVirtualNodes</code> request exceed <code>limit</code>, this value can be used to retrieve the next
     * page of results. This value is <code>null</code> when there are no more results to return.
     * </p>
     * 
     * @return The <code>nextToken</code> value to include in a future <code>ListVirtualNodes</code> request. When the
     *         results of a <code>ListVirtualNodes</code> request exceed <code>limit</code>, this value can be used to
     *         retrieve the next page of results. This value is <code>null</code> when there are no more results to
     *         return.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The list of existing virtual nodes for the specified service mesh.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The list of existing virtual nodes for the specified service mesh.
     */
    public List<VirtualNodeRef> virtualNodes() {
        return virtualNodes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(virtualNodes());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListVirtualNodesResponse)) {
            return false;
        }
        ListVirtualNodesResponse other = (ListVirtualNodesResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && Objects.equals(virtualNodes(), other.virtualNodes());
    }

    @Override
    public String toString() {
        return ToString.builder("ListVirtualNodesResponse").add("NextToken", nextToken()).add("VirtualNodes", virtualNodes())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "virtualNodes":
            return Optional.ofNullable(clazz.cast(virtualNodes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListVirtualNodesResponse, T> g) {
        return obj -> g.apply((ListVirtualNodesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppMeshResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListVirtualNodesResponse> {
        /**
         * <p>
         * The <code>nextToken</code> value to include in a future <code>ListVirtualNodes</code> request. When the
         * results of a <code>ListVirtualNodes</code> request exceed <code>limit</code>, this value can be used to
         * retrieve the next page of results. This value is <code>null</code> when there are no more results to return.
         * </p>
         * 
         * @param nextToken
         *        The <code>nextToken</code> value to include in a future <code>ListVirtualNodes</code> request. When
         *        the results of a <code>ListVirtualNodes</code> request exceed <code>limit</code>, this value can be
         *        used to retrieve the next page of results. This value is <code>null</code> when there are no more
         *        results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The list of existing virtual nodes for the specified service mesh.
         * </p>
         * 
         * @param virtualNodes
         *        The list of existing virtual nodes for the specified service mesh.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder virtualNodes(Collection<VirtualNodeRef> virtualNodes);

        /**
         * <p>
         * The list of existing virtual nodes for the specified service mesh.
         * </p>
         * 
         * @param virtualNodes
         *        The list of existing virtual nodes for the specified service mesh.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder virtualNodes(VirtualNodeRef... virtualNodes);

        /**
         * <p>
         * The list of existing virtual nodes for the specified service mesh.
         * </p>
         * This is a convenience that creates an instance of the {@link List<VirtualNodeRef>.Builder} avoiding the need
         * to create one manually via {@link List<VirtualNodeRef>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<VirtualNodeRef>.Builder#build()} is called immediately and
         * its result is passed to {@link #virtualNodes(List<VirtualNodeRef>)}.
         * 
         * @param virtualNodes
         *        a consumer that will call methods on {@link List<VirtualNodeRef>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #virtualNodes(List<VirtualNodeRef>)
         */
        Builder virtualNodes(Consumer<VirtualNodeRef.Builder>... virtualNodes);
    }

    static final class BuilderImpl extends AppMeshResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<VirtualNodeRef> virtualNodes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListVirtualNodesResponse model) {
            super(model);
            nextToken(model.nextToken);
            virtualNodes(model.virtualNodes);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<VirtualNodeRef.Builder> getVirtualNodes() {
            return virtualNodes != null ? virtualNodes.stream().map(VirtualNodeRef::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder virtualNodes(Collection<VirtualNodeRef> virtualNodes) {
            this.virtualNodes = VirtualNodeListCopier.copy(virtualNodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder virtualNodes(VirtualNodeRef... virtualNodes) {
            virtualNodes(Arrays.asList(virtualNodes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder virtualNodes(Consumer<VirtualNodeRef.Builder>... virtualNodes) {
            virtualNodes(Stream.of(virtualNodes).map(c -> VirtualNodeRef.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setVirtualNodes(Collection<VirtualNodeRef.BuilderImpl> virtualNodes) {
            this.virtualNodes = VirtualNodeListCopier.copyFromBuilder(virtualNodes);
        }

        @Override
        public ListVirtualNodesResponse build() {
            return new ListVirtualNodesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
