/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appmesh.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object representing a virtual router returned by a list operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VirtualRouterRef implements SdkPojo, Serializable,
        ToCopyableBuilder<VirtualRouterRef.Builder, VirtualRouterRef> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(VirtualRouterRef::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> MESH_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(VirtualRouterRef::meshName)).setter(setter(Builder::meshName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("meshName").build()).build();

    private static final SdkField<String> VIRTUAL_ROUTER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(VirtualRouterRef::virtualRouterName)).setter(setter(Builder::virtualRouterName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("virtualRouterName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, MESH_NAME_FIELD,
            VIRTUAL_ROUTER_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String meshName;

    private final String virtualRouterName;

    private VirtualRouterRef(BuilderImpl builder) {
        this.arn = builder.arn;
        this.meshName = builder.meshName;
        this.virtualRouterName = builder.virtualRouterName;
    }

    /**
     * <p>
     * The full Amazon Resource Name (ARN) for the virtual router.
     * </p>
     * 
     * @return The full Amazon Resource Name (ARN) for the virtual router.
     */
    public String arn() {
        return arn;
    }

    /**
     * <p>
     * The name of the service mesh in which the virtual router resides.
     * </p>
     * 
     * @return The name of the service mesh in which the virtual router resides.
     */
    public String meshName() {
        return meshName;
    }

    /**
     * <p>
     * The name of the virtual router.
     * </p>
     * 
     * @return The name of the virtual router.
     */
    public String virtualRouterName() {
        return virtualRouterName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(meshName());
        hashCode = 31 * hashCode + Objects.hashCode(virtualRouterName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VirtualRouterRef)) {
            return false;
        }
        VirtualRouterRef other = (VirtualRouterRef) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(meshName(), other.meshName())
                && Objects.equals(virtualRouterName(), other.virtualRouterName());
    }

    @Override
    public String toString() {
        return ToString.builder("VirtualRouterRef").add("Arn", arn()).add("MeshName", meshName())
                .add("VirtualRouterName", virtualRouterName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "meshName":
            return Optional.ofNullable(clazz.cast(meshName()));
        case "virtualRouterName":
            return Optional.ofNullable(clazz.cast(virtualRouterName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VirtualRouterRef, T> g) {
        return obj -> g.apply((VirtualRouterRef) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VirtualRouterRef> {
        /**
         * <p>
         * The full Amazon Resource Name (ARN) for the virtual router.
         * </p>
         * 
         * @param arn
         *        The full Amazon Resource Name (ARN) for the virtual router.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The name of the service mesh in which the virtual router resides.
         * </p>
         * 
         * @param meshName
         *        The name of the service mesh in which the virtual router resides.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder meshName(String meshName);

        /**
         * <p>
         * The name of the virtual router.
         * </p>
         * 
         * @param virtualRouterName
         *        The name of the virtual router.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder virtualRouterName(String virtualRouterName);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String meshName;

        private String virtualRouterName;

        private BuilderImpl() {
        }

        private BuilderImpl(VirtualRouterRef model) {
            arn(model.arn);
            meshName(model.meshName);
            virtualRouterName(model.virtualRouterName);
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getMeshName() {
            return meshName;
        }

        @Override
        public final Builder meshName(String meshName) {
            this.meshName = meshName;
            return this;
        }

        public final void setMeshName(String meshName) {
            this.meshName = meshName;
        }

        public final String getVirtualRouterName() {
            return virtualRouterName;
        }

        @Override
        public final Builder virtualRouterName(String virtualRouterName) {
            this.virtualRouterName = virtualRouterName;
            return this;
        }

        public final void setVirtualRouterName(String virtualRouterName) {
            this.virtualRouterName = virtualRouterName;
        }

        @Override
        public VirtualRouterRef build() {
            return new VirtualRouterRef(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
