/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appmesh.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeVirtualRouterResponse extends AppMeshResponse implements
        ToCopyableBuilder<DescribeVirtualRouterResponse.Builder, DescribeVirtualRouterResponse> {
    private static final SdkField<VirtualRouterData> VIRTUAL_ROUTER_FIELD = SdkField
            .<VirtualRouterData> builder(MarshallingType.SDK_POJO)
            .getter(getter(DescribeVirtualRouterResponse::virtualRouter))
            .setter(setter(Builder::virtualRouter))
            .constructor(VirtualRouterData::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("virtualRouter").build(),
                    PayloadTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VIRTUAL_ROUTER_FIELD));

    private final VirtualRouterData virtualRouter;

    private DescribeVirtualRouterResponse(BuilderImpl builder) {
        super(builder);
        this.virtualRouter = builder.virtualRouter;
    }

    /**
     * <p>
     * The full description of your virtual router.
     * </p>
     * 
     * @return The full description of your virtual router.
     */
    public VirtualRouterData virtualRouter() {
        return virtualRouter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(virtualRouter());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVirtualRouterResponse)) {
            return false;
        }
        DescribeVirtualRouterResponse other = (DescribeVirtualRouterResponse) obj;
        return Objects.equals(virtualRouter(), other.virtualRouter());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeVirtualRouterResponse").add("VirtualRouter", virtualRouter()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "virtualRouter":
            return Optional.ofNullable(clazz.cast(virtualRouter()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeVirtualRouterResponse, T> g) {
        return obj -> g.apply((DescribeVirtualRouterResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppMeshResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeVirtualRouterResponse> {
        /**
         * <p>
         * The full description of your virtual router.
         * </p>
         * 
         * @param virtualRouter
         *        The full description of your virtual router.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder virtualRouter(VirtualRouterData virtualRouter);

        /**
         * <p>
         * The full description of your virtual router.
         * </p>
         * This is a convenience that creates an instance of the {@link VirtualRouterData.Builder} avoiding the need to
         * create one manually via {@link VirtualRouterData#builder()}.
         *
         * When the {@link Consumer} completes, {@link VirtualRouterData.Builder#build()} is called immediately and its
         * result is passed to {@link #virtualRouter(VirtualRouterData)}.
         * 
         * @param virtualRouter
         *        a consumer that will call methods on {@link VirtualRouterData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #virtualRouter(VirtualRouterData)
         */
        default Builder virtualRouter(Consumer<VirtualRouterData.Builder> virtualRouter) {
            return virtualRouter(VirtualRouterData.builder().applyMutation(virtualRouter).build());
        }
    }

    static final class BuilderImpl extends AppMeshResponse.BuilderImpl implements Builder {
        private VirtualRouterData virtualRouter;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeVirtualRouterResponse model) {
            super(model);
            virtualRouter(model.virtualRouter);
        }

        public final VirtualRouterData.Builder getVirtualRouter() {
            return virtualRouter != null ? virtualRouter.toBuilder() : null;
        }

        @Override
        public final Builder virtualRouter(VirtualRouterData virtualRouter) {
            this.virtualRouter = virtualRouter;
            return this;
        }

        public final void setVirtualRouter(VirtualRouterData.BuilderImpl virtualRouter) {
            this.virtualRouter = virtualRouter != null ? virtualRouter.build() : null;
        }

        @Override
        public DescribeVirtualRouterResponse build() {
            return new DescribeVirtualRouterResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
