/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appmesh.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object representing the specification of a virtual router.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VirtualRouterSpec implements SdkPojo, Serializable,
        ToCopyableBuilder<VirtualRouterSpec.Builder, VirtualRouterSpec> {
    private static final SdkField<List<String>> SERVICE_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(VirtualRouterSpec::serviceNames))
            .setter(setter(Builder::serviceNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_NAMES_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> serviceNames;

    private VirtualRouterSpec(BuilderImpl builder) {
        this.serviceNames = builder.serviceNames;
    }

    /**
     * <p>
     * The service mesh service names to associate with the virtual router.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The service mesh service names to associate with the virtual router.
     */
    public List<String> serviceNames() {
        return serviceNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(serviceNames());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VirtualRouterSpec)) {
            return false;
        }
        VirtualRouterSpec other = (VirtualRouterSpec) obj;
        return Objects.equals(serviceNames(), other.serviceNames());
    }

    @Override
    public String toString() {
        return ToString.builder("VirtualRouterSpec").add("ServiceNames", serviceNames()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "serviceNames":
            return Optional.ofNullable(clazz.cast(serviceNames()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VirtualRouterSpec, T> g) {
        return obj -> g.apply((VirtualRouterSpec) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VirtualRouterSpec> {
        /**
         * <p>
         * The service mesh service names to associate with the virtual router.
         * </p>
         * 
         * @param serviceNames
         *        The service mesh service names to associate with the virtual router.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceNames(Collection<String> serviceNames);

        /**
         * <p>
         * The service mesh service names to associate with the virtual router.
         * </p>
         * 
         * @param serviceNames
         *        The service mesh service names to associate with the virtual router.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceNames(String... serviceNames);
    }

    static final class BuilderImpl implements Builder {
        private List<String> serviceNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(VirtualRouterSpec model) {
            serviceNames(model.serviceNames);
        }

        public final Collection<String> getServiceNames() {
            return serviceNames;
        }

        @Override
        public final Builder serviceNames(Collection<String> serviceNames) {
            this.serviceNames = ServiceNamesCopier.copy(serviceNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceNames(String... serviceNames) {
            serviceNames(Arrays.asList(serviceNames));
            return this;
        }

        public final void setServiceNames(Collection<String> serviceNames) {
            this.serviceNames = ServiceNamesCopier.copy(serviceNames);
        }

        @Override
        public VirtualRouterSpec build() {
            return new VirtualRouterSpec(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
