/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appmesh.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <zonbook></zonbook><xhtml></xhtml>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteVirtualRouterResponse extends AppMeshResponse implements
        ToCopyableBuilder<DeleteVirtualRouterResponse.Builder, DeleteVirtualRouterResponse> {
    private static final SdkField<VirtualRouterData> VIRTUAL_ROUTER_FIELD = SdkField
            .<VirtualRouterData> builder(MarshallingType.SDK_POJO)
            .memberName("virtualRouter")
            .getter(getter(DeleteVirtualRouterResponse::virtualRouter))
            .setter(setter(Builder::virtualRouter))
            .constructor(VirtualRouterData::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("virtualRouter").build(),
                    PayloadTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VIRTUAL_ROUTER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final VirtualRouterData virtualRouter;

    private DeleteVirtualRouterResponse(BuilderImpl builder) {
        super(builder);
        this.virtualRouter = builder.virtualRouter;
    }

    /**
     * <p>
     * The virtual router that was deleted.
     * </p>
     * 
     * @return The virtual router that was deleted.
     */
    public final VirtualRouterData virtualRouter() {
        return virtualRouter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(virtualRouter());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteVirtualRouterResponse)) {
            return false;
        }
        DeleteVirtualRouterResponse other = (DeleteVirtualRouterResponse) obj;
        return Objects.equals(virtualRouter(), other.virtualRouter());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteVirtualRouterResponse").add("VirtualRouter", virtualRouter()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "virtualRouter":
            return Optional.ofNullable(clazz.cast(virtualRouter()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("virtualRouter", VIRTUAL_ROUTER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteVirtualRouterResponse, T> g) {
        return obj -> g.apply((DeleteVirtualRouterResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppMeshResponse.Builder, SdkPojo, CopyableBuilder<Builder, DeleteVirtualRouterResponse> {
        /**
         * <p>
         * The virtual router that was deleted.
         * </p>
         * 
         * @param virtualRouter
         *        The virtual router that was deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder virtualRouter(VirtualRouterData virtualRouter);

        /**
         * <p>
         * The virtual router that was deleted.
         * </p>
         * This is a convenience method that creates an instance of the {@link VirtualRouterData.Builder} avoiding the
         * need to create one manually via {@link VirtualRouterData#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VirtualRouterData.Builder#build()} is called immediately and its
         * result is passed to {@link #virtualRouter(VirtualRouterData)}.
         * 
         * @param virtualRouter
         *        a consumer that will call methods on {@link VirtualRouterData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #virtualRouter(VirtualRouterData)
         */
        default Builder virtualRouter(Consumer<VirtualRouterData.Builder> virtualRouter) {
            return virtualRouter(VirtualRouterData.builder().applyMutation(virtualRouter).build());
        }
    }

    static final class BuilderImpl extends AppMeshResponse.BuilderImpl implements Builder {
        private VirtualRouterData virtualRouter;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteVirtualRouterResponse model) {
            super(model);
            virtualRouter(model.virtualRouter);
        }

        public final VirtualRouterData.Builder getVirtualRouter() {
            return virtualRouter != null ? virtualRouter.toBuilder() : null;
        }

        public final void setVirtualRouter(VirtualRouterData.BuilderImpl virtualRouter) {
            this.virtualRouter = virtualRouter != null ? virtualRouter.build() : null;
        }

        @Override
        public final Builder virtualRouter(VirtualRouterData virtualRouter) {
            this.virtualRouter = virtualRouter;
            return this;
        }

        @Override
        public DeleteVirtualRouterResponse build() {
            return new DeleteVirtualRouterResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
