/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appmesh.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that represents the query parameter in the request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HttpQueryParameter implements SdkPojo, Serializable,
        ToCopyableBuilder<HttpQueryParameter.Builder, HttpQueryParameter> {
    private static final SdkField<QueryParameterMatch> MATCH_FIELD = SdkField
            .<QueryParameterMatch> builder(MarshallingType.SDK_POJO).memberName("match")
            .getter(getter(HttpQueryParameter::match)).setter(setter(Builder::match)).constructor(QueryParameterMatch::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("match").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(HttpQueryParameter::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MATCH_FIELD, NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final QueryParameterMatch match;

    private final String name;

    private HttpQueryParameter(BuilderImpl builder) {
        this.match = builder.match;
        this.name = builder.name;
    }

    /**
     * <p>
     * The query parameter to match on.
     * </p>
     * 
     * @return The query parameter to match on.
     */
    public final QueryParameterMatch match() {
        return match;
    }

    /**
     * <p>
     * A name for the query parameter that will be matched on.
     * </p>
     * 
     * @return A name for the query parameter that will be matched on.
     */
    public final String name() {
        return name;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(match());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HttpQueryParameter)) {
            return false;
        }
        HttpQueryParameter other = (HttpQueryParameter) obj;
        return Objects.equals(match(), other.match()) && Objects.equals(name(), other.name());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("HttpQueryParameter").add("Match", match()).add("Name", name()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "match":
            return Optional.ofNullable(clazz.cast(match()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("match", MATCH_FIELD);
        map.put("name", NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<HttpQueryParameter, T> g) {
        return obj -> g.apply((HttpQueryParameter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HttpQueryParameter> {
        /**
         * <p>
         * The query parameter to match on.
         * </p>
         * 
         * @param match
         *        The query parameter to match on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder match(QueryParameterMatch match);

        /**
         * <p>
         * The query parameter to match on.
         * </p>
         * This is a convenience method that creates an instance of the {@link QueryParameterMatch.Builder} avoiding the
         * need to create one manually via {@link QueryParameterMatch#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link QueryParameterMatch.Builder#build()} is called immediately and
         * its result is passed to {@link #match(QueryParameterMatch)}.
         * 
         * @param match
         *        a consumer that will call methods on {@link QueryParameterMatch.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #match(QueryParameterMatch)
         */
        default Builder match(Consumer<QueryParameterMatch.Builder> match) {
            return match(QueryParameterMatch.builder().applyMutation(match).build());
        }

        /**
         * <p>
         * A name for the query parameter that will be matched on.
         * </p>
         * 
         * @param name
         *        A name for the query parameter that will be matched on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);
    }

    static final class BuilderImpl implements Builder {
        private QueryParameterMatch match;

        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(HttpQueryParameter model) {
            match(model.match);
            name(model.name);
        }

        public final QueryParameterMatch.Builder getMatch() {
            return match != null ? match.toBuilder() : null;
        }

        public final void setMatch(QueryParameterMatch.BuilderImpl match) {
            this.match = match != null ? match.build() : null;
        }

        @Override
        public final Builder match(QueryParameterMatch match) {
            this.match = match;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public HttpQueryParameter build() {
            return new HttpQueryParameter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
