/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appmesh.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that represents the match metadata for the route.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GrpcRouteMetadata implements SdkPojo, Serializable,
        ToCopyableBuilder<GrpcRouteMetadata.Builder, GrpcRouteMetadata> {
    private static final SdkField<Boolean> INVERT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("invert").getter(getter(GrpcRouteMetadata::invert)).setter(setter(Builder::invert))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("invert").build()).build();

    private static final SdkField<GrpcRouteMetadataMatchMethod> MATCH_FIELD = SdkField
            .<GrpcRouteMetadataMatchMethod> builder(MarshallingType.SDK_POJO).memberName("match")
            .getter(getter(GrpcRouteMetadata::match)).setter(setter(Builder::match))
            .constructor(GrpcRouteMetadataMatchMethod::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("match").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(GrpcRouteMetadata::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INVERT_FIELD, MATCH_FIELD,
            NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean invert;

    private final GrpcRouteMetadataMatchMethod match;

    private final String name;

    private GrpcRouteMetadata(BuilderImpl builder) {
        this.invert = builder.invert;
        this.match = builder.match;
        this.name = builder.name;
    }

    /**
     * <p>
     * Specify <code>True</code> to match anything except the match criteria. The default value is <code>False</code>.
     * </p>
     * 
     * @return Specify <code>True</code> to match anything except the match criteria. The default value is
     *         <code>False</code>.
     */
    public final Boolean invert() {
        return invert;
    }

    /**
     * <p>
     * An object that represents the data to match from the request.
     * </p>
     * 
     * @return An object that represents the data to match from the request.
     */
    public final GrpcRouteMetadataMatchMethod match() {
        return match;
    }

    /**
     * <p>
     * The name of the route.
     * </p>
     * 
     * @return The name of the route.
     */
    public final String name() {
        return name;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(invert());
        hashCode = 31 * hashCode + Objects.hashCode(match());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GrpcRouteMetadata)) {
            return false;
        }
        GrpcRouteMetadata other = (GrpcRouteMetadata) obj;
        return Objects.equals(invert(), other.invert()) && Objects.equals(match(), other.match())
                && Objects.equals(name(), other.name());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GrpcRouteMetadata").add("Invert", invert()).add("Match", match()).add("Name", name()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "invert":
            return Optional.ofNullable(clazz.cast(invert()));
        case "match":
            return Optional.ofNullable(clazz.cast(match()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("invert", INVERT_FIELD);
        map.put("match", MATCH_FIELD);
        map.put("name", NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GrpcRouteMetadata, T> g) {
        return obj -> g.apply((GrpcRouteMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GrpcRouteMetadata> {
        /**
         * <p>
         * Specify <code>True</code> to match anything except the match criteria. The default value is
         * <code>False</code>.
         * </p>
         * 
         * @param invert
         *        Specify <code>True</code> to match anything except the match criteria. The default value is
         *        <code>False</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invert(Boolean invert);

        /**
         * <p>
         * An object that represents the data to match from the request.
         * </p>
         * 
         * @param match
         *        An object that represents the data to match from the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder match(GrpcRouteMetadataMatchMethod match);

        /**
         * <p>
         * An object that represents the data to match from the request.
         * </p>
         * This is a convenience method that creates an instance of the {@link GrpcRouteMetadataMatchMethod.Builder}
         * avoiding the need to create one manually via {@link GrpcRouteMetadataMatchMethod#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GrpcRouteMetadataMatchMethod.Builder#build()} is called
         * immediately and its result is passed to {@link #match(GrpcRouteMetadataMatchMethod)}.
         * 
         * @param match
         *        a consumer that will call methods on {@link GrpcRouteMetadataMatchMethod.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #match(GrpcRouteMetadataMatchMethod)
         */
        default Builder match(Consumer<GrpcRouteMetadataMatchMethod.Builder> match) {
            return match(GrpcRouteMetadataMatchMethod.builder().applyMutation(match).build());
        }

        /**
         * <p>
         * The name of the route.
         * </p>
         * 
         * @param name
         *        The name of the route.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);
    }

    static final class BuilderImpl implements Builder {
        private Boolean invert;

        private GrpcRouteMetadataMatchMethod match;

        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(GrpcRouteMetadata model) {
            invert(model.invert);
            match(model.match);
            name(model.name);
        }

        public final Boolean getInvert() {
            return invert;
        }

        public final void setInvert(Boolean invert) {
            this.invert = invert;
        }

        @Override
        public final Builder invert(Boolean invert) {
            this.invert = invert;
            return this;
        }

        public final GrpcRouteMetadataMatchMethod.Builder getMatch() {
            return match != null ? match.toBuilder() : null;
        }

        public final void setMatch(GrpcRouteMetadataMatchMethod.BuilderImpl match) {
            this.match = match != null ? match.build() : null;
        }

        @Override
        public final Builder match(GrpcRouteMetadataMatchMethod match) {
            this.match = match;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public GrpcRouteMetadata build() {
            return new GrpcRouteMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
