/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appmesh.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateVirtualNodeRequest extends AppMeshRequest implements
        ToCopyableBuilder<UpdateVirtualNodeRequest.Builder, UpdateVirtualNodeRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateVirtualNodeRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> MESH_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateVirtualNodeRequest::meshName)).setter(setter(Builder::meshName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("meshName").build()).build();

    private static final SdkField<VirtualNodeSpec> SPEC_FIELD = SdkField.<VirtualNodeSpec> builder(MarshallingType.SDK_POJO)
            .getter(getter(UpdateVirtualNodeRequest::spec)).setter(setter(Builder::spec)).constructor(VirtualNodeSpec::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("spec").build()).build();

    private static final SdkField<String> VIRTUAL_NODE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateVirtualNodeRequest::virtualNodeName)).setter(setter(Builder::virtualNodeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("virtualNodeName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            MESH_NAME_FIELD, SPEC_FIELD, VIRTUAL_NODE_NAME_FIELD));

    private final String clientToken;

    private final String meshName;

    private final VirtualNodeSpec spec;

    private final String virtualNodeName;

    private UpdateVirtualNodeRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.meshName = builder.meshName;
        this.spec = builder.spec;
        this.virtualNodeName = builder.virtualNodeName;
    }

    /**
     * <p>
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 36 letters,
     * numbers, hyphens, and underscores are allowed.
     * </p>
     * 
     * @return Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 36
     *         letters, numbers, hyphens, and underscores are allowed.
     */
    public String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The name of the service mesh in which the virtual node resides.
     * </p>
     * 
     * @return The name of the service mesh in which the virtual node resides.
     */
    public String meshName() {
        return meshName;
    }

    /**
     * <p>
     * The new virtual node specification to apply. This overwrites the existing data.
     * </p>
     * 
     * @return The new virtual node specification to apply. This overwrites the existing data.
     */
    public VirtualNodeSpec spec() {
        return spec;
    }

    /**
     * <p>
     * The name of the virtual node to update.
     * </p>
     * 
     * @return The name of the virtual node to update.
     */
    public String virtualNodeName() {
        return virtualNodeName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(meshName());
        hashCode = 31 * hashCode + Objects.hashCode(spec());
        hashCode = 31 * hashCode + Objects.hashCode(virtualNodeName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateVirtualNodeRequest)) {
            return false;
        }
        UpdateVirtualNodeRequest other = (UpdateVirtualNodeRequest) obj;
        return Objects.equals(clientToken(), other.clientToken()) && Objects.equals(meshName(), other.meshName())
                && Objects.equals(spec(), other.spec()) && Objects.equals(virtualNodeName(), other.virtualNodeName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateVirtualNodeRequest").add("ClientToken", clientToken()).add("MeshName", meshName())
                .add("Spec", spec()).add("VirtualNodeName", virtualNodeName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "meshName":
            return Optional.ofNullable(clazz.cast(meshName()));
        case "spec":
            return Optional.ofNullable(clazz.cast(spec()));
        case "virtualNodeName":
            return Optional.ofNullable(clazz.cast(virtualNodeName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateVirtualNodeRequest, T> g) {
        return obj -> g.apply((UpdateVirtualNodeRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppMeshRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateVirtualNodeRequest> {
        /**
         * <p>
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 36
         * letters, numbers, hyphens, and underscores are allowed.
         * </p>
         * 
         * @param clientToken
         *        Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 36
         *        letters, numbers, hyphens, and underscores are allowed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The name of the service mesh in which the virtual node resides.
         * </p>
         * 
         * @param meshName
         *        The name of the service mesh in which the virtual node resides.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder meshName(String meshName);

        /**
         * <p>
         * The new virtual node specification to apply. This overwrites the existing data.
         * </p>
         * 
         * @param spec
         *        The new virtual node specification to apply. This overwrites the existing data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spec(VirtualNodeSpec spec);

        /**
         * <p>
         * The new virtual node specification to apply. This overwrites the existing data.
         * </p>
         * This is a convenience that creates an instance of the {@link VirtualNodeSpec.Builder} avoiding the need to
         * create one manually via {@link VirtualNodeSpec#builder()}.
         *
         * When the {@link Consumer} completes, {@link VirtualNodeSpec.Builder#build()} is called immediately and its
         * result is passed to {@link #spec(VirtualNodeSpec)}.
         * 
         * @param spec
         *        a consumer that will call methods on {@link VirtualNodeSpec.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #spec(VirtualNodeSpec)
         */
        default Builder spec(Consumer<VirtualNodeSpec.Builder> spec) {
            return spec(VirtualNodeSpec.builder().applyMutation(spec).build());
        }

        /**
         * <p>
         * The name of the virtual node to update.
         * </p>
         * 
         * @param virtualNodeName
         *        The name of the virtual node to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder virtualNodeName(String virtualNodeName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AppMeshRequest.BuilderImpl implements Builder {
        private String clientToken;

        private String meshName;

        private VirtualNodeSpec spec;

        private String virtualNodeName;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateVirtualNodeRequest model) {
            super(model);
            clientToken(model.clientToken);
            meshName(model.meshName);
            spec(model.spec);
            virtualNodeName(model.virtualNodeName);
        }

        public final String getClientToken() {
            return clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final String getMeshName() {
            return meshName;
        }

        @Override
        public final Builder meshName(String meshName) {
            this.meshName = meshName;
            return this;
        }

        public final void setMeshName(String meshName) {
            this.meshName = meshName;
        }

        public final VirtualNodeSpec.Builder getSpec() {
            return spec != null ? spec.toBuilder() : null;
        }

        @Override
        public final Builder spec(VirtualNodeSpec spec) {
            this.spec = spec;
            return this;
        }

        public final void setSpec(VirtualNodeSpec.BuilderImpl spec) {
            this.spec = spec != null ? spec.build() : null;
        }

        public final String getVirtualNodeName() {
            return virtualNodeName;
        }

        @Override
        public final Builder virtualNodeName(String virtualNodeName) {
            this.virtualNodeName = virtualNodeName;
            return this;
        }

        public final void setVirtualNodeName(String virtualNodeName) {
            this.virtualNodeName = virtualNodeName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateVirtualNodeRequest build() {
            return new UpdateVirtualNodeRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
