/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appmesh.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListRoutesRequest extends AppMeshRequest implements
        ToCopyableBuilder<ListRoutesRequest.Builder, ListRoutesRequest> {
    private static final SdkField<Integer> LIMIT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ListRoutesRequest::limit)).setter(setter(Builder::limit))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("limit").build()).build();

    private static final SdkField<String> MESH_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListRoutesRequest::meshName)).setter(setter(Builder::meshName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("meshName").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListRoutesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final SdkField<String> VIRTUAL_ROUTER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListRoutesRequest::virtualRouterName)).setter(setter(Builder::virtualRouterName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("virtualRouterName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LIMIT_FIELD, MESH_NAME_FIELD,
            NEXT_TOKEN_FIELD, VIRTUAL_ROUTER_NAME_FIELD));

    private final Integer limit;

    private final String meshName;

    private final String nextToken;

    private final String virtualRouterName;

    private ListRoutesRequest(BuilderImpl builder) {
        super(builder);
        this.limit = builder.limit;
        this.meshName = builder.meshName;
        this.nextToken = builder.nextToken;
        this.virtualRouterName = builder.virtualRouterName;
    }

    /**
     * <p>
     * The maximum number of results returned by <code>ListRoutes</code> in paginated output. When you use this
     * parameter, <code>ListRoutes</code> returns only <code>limit</code> results in a single page along with a
     * <code>nextToken</code> response element. You can see the remaining results of the initial request by sending
     * another <code>ListRoutes</code> request with the returned <code>nextToken</code> value. This value can be between
     * 1 and 100. If you don't use this parameter, <code>ListRoutes</code> returns up to 100 results and a
     * <code>nextToken</code> value if applicable.
     * </p>
     * 
     * @return The maximum number of results returned by <code>ListRoutes</code> in paginated output. When you use this
     *         parameter, <code>ListRoutes</code> returns only <code>limit</code> results in a single page along with a
     *         <code>nextToken</code> response element. You can see the remaining results of the initial request by
     *         sending another <code>ListRoutes</code> request with the returned <code>nextToken</code> value. This
     *         value can be between 1 and 100. If you don't use this parameter, <code>ListRoutes</code> returns up to
     *         100 results and a <code>nextToken</code> value if applicable.
     */
    public Integer limit() {
        return limit;
    }

    /**
     * <p>
     * The name of the service mesh in which to list routes.
     * </p>
     * 
     * @return The name of the service mesh in which to list routes.
     */
    public String meshName() {
        return meshName;
    }

    /**
     * <p>
     * The <code>nextToken</code> value returned from a previous paginated <code>ListRoutes</code> request where
     * <code>limit</code> was used and the results exceeded the value of that parameter. Pagination continues from the
     * end of the previous results that returned the <code>nextToken</code> value.
     * </p>
     * 
     * @return The <code>nextToken</code> value returned from a previous paginated <code>ListRoutes</code> request where
     *         <code>limit</code> was used and the results exceeded the value of that parameter. Pagination continues
     *         from the end of the previous results that returned the <code>nextToken</code> value.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The name of the virtual router to list routes in.
     * </p>
     * 
     * @return The name of the virtual router to list routes in.
     */
    public String virtualRouterName() {
        return virtualRouterName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(limit());
        hashCode = 31 * hashCode + Objects.hashCode(meshName());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(virtualRouterName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRoutesRequest)) {
            return false;
        }
        ListRoutesRequest other = (ListRoutesRequest) obj;
        return Objects.equals(limit(), other.limit()) && Objects.equals(meshName(), other.meshName())
                && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(virtualRouterName(), other.virtualRouterName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListRoutesRequest").add("Limit", limit()).add("MeshName", meshName())
                .add("NextToken", nextToken()).add("VirtualRouterName", virtualRouterName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "limit":
            return Optional.ofNullable(clazz.cast(limit()));
        case "meshName":
            return Optional.ofNullable(clazz.cast(meshName()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "virtualRouterName":
            return Optional.ofNullable(clazz.cast(virtualRouterName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListRoutesRequest, T> g) {
        return obj -> g.apply((ListRoutesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppMeshRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListRoutesRequest> {
        /**
         * <p>
         * The maximum number of results returned by <code>ListRoutes</code> in paginated output. When you use this
         * parameter, <code>ListRoutes</code> returns only <code>limit</code> results in a single page along with a
         * <code>nextToken</code> response element. You can see the remaining results of the initial request by sending
         * another <code>ListRoutes</code> request with the returned <code>nextToken</code> value. This value can be
         * between 1 and 100. If you don't use this parameter, <code>ListRoutes</code> returns up to 100 results and a
         * <code>nextToken</code> value if applicable.
         * </p>
         * 
         * @param limit
         *        The maximum number of results returned by <code>ListRoutes</code> in paginated output. When you use
         *        this parameter, <code>ListRoutes</code> returns only <code>limit</code> results in a single page along
         *        with a <code>nextToken</code> response element. You can see the remaining results of the initial
         *        request by sending another <code>ListRoutes</code> request with the returned <code>nextToken</code>
         *        value. This value can be between 1 and 100. If you don't use this parameter, <code>ListRoutes</code>
         *        returns up to 100 results and a <code>nextToken</code> value if applicable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limit(Integer limit);

        /**
         * <p>
         * The name of the service mesh in which to list routes.
         * </p>
         * 
         * @param meshName
         *        The name of the service mesh in which to list routes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder meshName(String meshName);

        /**
         * <p>
         * The <code>nextToken</code> value returned from a previous paginated <code>ListRoutes</code> request where
         * <code>limit</code> was used and the results exceeded the value of that parameter. Pagination continues from
         * the end of the previous results that returned the <code>nextToken</code> value.
         * </p>
         * 
         * @param nextToken
         *        The <code>nextToken</code> value returned from a previous paginated <code>ListRoutes</code> request
         *        where <code>limit</code> was used and the results exceeded the value of that parameter. Pagination
         *        continues from the end of the previous results that returned the <code>nextToken</code> value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The name of the virtual router to list routes in.
         * </p>
         * 
         * @param virtualRouterName
         *        The name of the virtual router to list routes in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder virtualRouterName(String virtualRouterName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AppMeshRequest.BuilderImpl implements Builder {
        private Integer limit;

        private String meshName;

        private String nextToken;

        private String virtualRouterName;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRoutesRequest model) {
            super(model);
            limit(model.limit);
            meshName(model.meshName);
            nextToken(model.nextToken);
            virtualRouterName(model.virtualRouterName);
        }

        public final Integer getLimit() {
            return limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        public final String getMeshName() {
            return meshName;
        }

        @Override
        public final Builder meshName(String meshName) {
            this.meshName = meshName;
            return this;
        }

        public final void setMeshName(String meshName) {
            this.meshName = meshName;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final String getVirtualRouterName() {
            return virtualRouterName;
        }

        @Override
        public final Builder virtualRouterName(String virtualRouterName) {
            this.virtualRouterName = virtualRouterName;
            return this;
        }

        public final void setVirtualRouterName(String virtualRouterName) {
            this.virtualRouterName = virtualRouterName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListRoutesRequest build() {
            return new ListRoutesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
