/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appmesh.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object representing the egress filter rules for a service mesh.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EgressFilter implements SdkPojo, Serializable, ToCopyableBuilder<EgressFilter.Builder, EgressFilter> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(EgressFilter::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String type;

    private EgressFilter(BuilderImpl builder) {
        this.type = builder.type;
    }

    /**
     * <p>
     * The egress filter type. By default, the type is <code>DROP_ALL</code>, which allows egress only from virtual
     * nodes to other defined resources in the service mesh (and any traffic to <code>*.amazonaws.com</code> for AWS API
     * calls). You can set the egress filter type to <code>ALLOW_ALL</code> to allow egress to any endpoint inside or
     * outside of the service mesh.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link EgressFilterType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The egress filter type. By default, the type is <code>DROP_ALL</code>, which allows egress only from
     *         virtual nodes to other defined resources in the service mesh (and any traffic to
     *         <code>*.amazonaws.com</code> for AWS API calls). You can set the egress filter type to
     *         <code>ALLOW_ALL</code> to allow egress to any endpoint inside or outside of the service mesh.
     * @see EgressFilterType
     */
    public EgressFilterType type() {
        return EgressFilterType.fromValue(type);
    }

    /**
     * <p>
     * The egress filter type. By default, the type is <code>DROP_ALL</code>, which allows egress only from virtual
     * nodes to other defined resources in the service mesh (and any traffic to <code>*.amazonaws.com</code> for AWS API
     * calls). You can set the egress filter type to <code>ALLOW_ALL</code> to allow egress to any endpoint inside or
     * outside of the service mesh.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link EgressFilterType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The egress filter type. By default, the type is <code>DROP_ALL</code>, which allows egress only from
     *         virtual nodes to other defined resources in the service mesh (and any traffic to
     *         <code>*.amazonaws.com</code> for AWS API calls). You can set the egress filter type to
     *         <code>ALLOW_ALL</code> to allow egress to any endpoint inside or outside of the service mesh.
     * @see EgressFilterType
     */
    public String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EgressFilter)) {
            return false;
        }
        EgressFilter other = (EgressFilter) obj;
        return Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("EgressFilter").add("Type", typeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EgressFilter, T> g) {
        return obj -> g.apply((EgressFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EgressFilter> {
        /**
         * <p>
         * The egress filter type. By default, the type is <code>DROP_ALL</code>, which allows egress only from virtual
         * nodes to other defined resources in the service mesh (and any traffic to <code>*.amazonaws.com</code> for AWS
         * API calls). You can set the egress filter type to <code>ALLOW_ALL</code> to allow egress to any endpoint
         * inside or outside of the service mesh.
         * </p>
         * 
         * @param type
         *        The egress filter type. By default, the type is <code>DROP_ALL</code>, which allows egress only from
         *        virtual nodes to other defined resources in the service mesh (and any traffic to
         *        <code>*.amazonaws.com</code> for AWS API calls). You can set the egress filter type to
         *        <code>ALLOW_ALL</code> to allow egress to any endpoint inside or outside of the service mesh.
         * @see EgressFilterType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EgressFilterType
         */
        Builder type(String type);

        /**
         * <p>
         * The egress filter type. By default, the type is <code>DROP_ALL</code>, which allows egress only from virtual
         * nodes to other defined resources in the service mesh (and any traffic to <code>*.amazonaws.com</code> for AWS
         * API calls). You can set the egress filter type to <code>ALLOW_ALL</code> to allow egress to any endpoint
         * inside or outside of the service mesh.
         * </p>
         * 
         * @param type
         *        The egress filter type. By default, the type is <code>DROP_ALL</code>, which allows egress only from
         *        virtual nodes to other defined resources in the service mesh (and any traffic to
         *        <code>*.amazonaws.com</code> for AWS API calls). You can set the egress filter type to
         *        <code>ALLOW_ALL</code> to allow egress to any endpoint inside or outside of the service mesh.
         * @see EgressFilterType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EgressFilterType
         */
        Builder type(EgressFilterType type);
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(EgressFilter model) {
            type(model.type);
        }

        public final String getTypeAsString() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(EgressFilterType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public EgressFilter build() {
            return new EgressFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
