/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appmesh.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object representing the specification of a route.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RouteSpec implements SdkPojo, Serializable, ToCopyableBuilder<RouteSpec.Builder, RouteSpec> {
    private static final SdkField<HttpRoute> HTTP_ROUTE_FIELD = SdkField.<HttpRoute> builder(MarshallingType.SDK_POJO)
            .getter(getter(RouteSpec::httpRoute)).setter(setter(Builder::httpRoute)).constructor(HttpRoute::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("httpRoute").build()).build();

    private static final SdkField<TcpRoute> TCP_ROUTE_FIELD = SdkField.<TcpRoute> builder(MarshallingType.SDK_POJO)
            .getter(getter(RouteSpec::tcpRoute)).setter(setter(Builder::tcpRoute)).constructor(TcpRoute::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tcpRoute").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HTTP_ROUTE_FIELD,
            TCP_ROUTE_FIELD));

    private static final long serialVersionUID = 1L;

    private final HttpRoute httpRoute;

    private final TcpRoute tcpRoute;

    private RouteSpec(BuilderImpl builder) {
        this.httpRoute = builder.httpRoute;
        this.tcpRoute = builder.tcpRoute;
    }

    /**
     * <p>
     * The HTTP routing information for the route.
     * </p>
     * 
     * @return The HTTP routing information for the route.
     */
    public HttpRoute httpRoute() {
        return httpRoute;
    }

    /**
     * <p>
     * The TCP routing information for the route.
     * </p>
     * 
     * @return The TCP routing information for the route.
     */
    public TcpRoute tcpRoute() {
        return tcpRoute;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(httpRoute());
        hashCode = 31 * hashCode + Objects.hashCode(tcpRoute());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouteSpec)) {
            return false;
        }
        RouteSpec other = (RouteSpec) obj;
        return Objects.equals(httpRoute(), other.httpRoute()) && Objects.equals(tcpRoute(), other.tcpRoute());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("RouteSpec").add("HttpRoute", httpRoute()).add("TcpRoute", tcpRoute()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "httpRoute":
            return Optional.ofNullable(clazz.cast(httpRoute()));
        case "tcpRoute":
            return Optional.ofNullable(clazz.cast(tcpRoute()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RouteSpec, T> g) {
        return obj -> g.apply((RouteSpec) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RouteSpec> {
        /**
         * <p>
         * The HTTP routing information for the route.
         * </p>
         * 
         * @param httpRoute
         *        The HTTP routing information for the route.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder httpRoute(HttpRoute httpRoute);

        /**
         * <p>
         * The HTTP routing information for the route.
         * </p>
         * This is a convenience that creates an instance of the {@link HttpRoute.Builder} avoiding the need to create
         * one manually via {@link HttpRoute#builder()}.
         *
         * When the {@link Consumer} completes, {@link HttpRoute.Builder#build()} is called immediately and its result
         * is passed to {@link #httpRoute(HttpRoute)}.
         * 
         * @param httpRoute
         *        a consumer that will call methods on {@link HttpRoute.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #httpRoute(HttpRoute)
         */
        default Builder httpRoute(Consumer<HttpRoute.Builder> httpRoute) {
            return httpRoute(HttpRoute.builder().applyMutation(httpRoute).build());
        }

        /**
         * <p>
         * The TCP routing information for the route.
         * </p>
         * 
         * @param tcpRoute
         *        The TCP routing information for the route.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tcpRoute(TcpRoute tcpRoute);

        /**
         * <p>
         * The TCP routing information for the route.
         * </p>
         * This is a convenience that creates an instance of the {@link TcpRoute.Builder} avoiding the need to create
         * one manually via {@link TcpRoute#builder()}.
         *
         * When the {@link Consumer} completes, {@link TcpRoute.Builder#build()} is called immediately and its result is
         * passed to {@link #tcpRoute(TcpRoute)}.
         * 
         * @param tcpRoute
         *        a consumer that will call methods on {@link TcpRoute.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tcpRoute(TcpRoute)
         */
        default Builder tcpRoute(Consumer<TcpRoute.Builder> tcpRoute) {
            return tcpRoute(TcpRoute.builder().applyMutation(tcpRoute).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private HttpRoute httpRoute;

        private TcpRoute tcpRoute;

        private BuilderImpl() {
        }

        private BuilderImpl(RouteSpec model) {
            httpRoute(model.httpRoute);
            tcpRoute(model.tcpRoute);
        }

        public final HttpRoute.Builder getHttpRoute() {
            return httpRoute != null ? httpRoute.toBuilder() : null;
        }

        @Override
        public final Builder httpRoute(HttpRoute httpRoute) {
            this.httpRoute = httpRoute;
            return this;
        }

        public final void setHttpRoute(HttpRoute.BuilderImpl httpRoute) {
            this.httpRoute = httpRoute != null ? httpRoute.build() : null;
        }

        public final TcpRoute.Builder getTcpRoute() {
            return tcpRoute != null ? tcpRoute.toBuilder() : null;
        }

        @Override
        public final Builder tcpRoute(TcpRoute tcpRoute) {
            this.tcpRoute = tcpRoute;
            return this;
        }

        public final void setTcpRoute(TcpRoute.BuilderImpl tcpRoute) {
            this.tcpRoute = tcpRoute != null ? tcpRoute.build() : null;
        }

        @Override
        public RouteSpec build() {
            return new RouteSpec(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
