/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appmesh.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateRouteRequest extends AppMeshRequest implements
        ToCopyableBuilder<CreateRouteRequest.Builder, CreateRouteRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(CreateRouteRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> MESH_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateRouteRequest::meshName)).setter(setter(Builder::meshName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("meshName").build()).build();

    private static final SdkField<String> ROUTE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateRouteRequest::routeName)).setter(setter(Builder::routeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("routeName").build()).build();

    private static final SdkField<RouteSpec> SPEC_FIELD = SdkField.<RouteSpec> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreateRouteRequest::spec)).setter(setter(Builder::spec)).constructor(RouteSpec::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("spec").build()).build();

    private static final SdkField<String> VIRTUAL_ROUTER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateRouteRequest::virtualRouterName)).setter(setter(Builder::virtualRouterName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("virtualRouterName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            MESH_NAME_FIELD, ROUTE_NAME_FIELD, SPEC_FIELD, VIRTUAL_ROUTER_NAME_FIELD));

    private final String clientToken;

    private final String meshName;

    private final String routeName;

    private final RouteSpec spec;

    private final String virtualRouterName;

    private CreateRouteRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.meshName = builder.meshName;
        this.routeName = builder.routeName;
        this.spec = builder.spec;
        this.virtualRouterName = builder.virtualRouterName;
    }

    /**
     * <p>
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 36 letters,
     * numbers, hyphens, and underscores are allowed.
     * </p>
     * 
     * @return Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 36
     *         letters, numbers, hyphens, and underscores are allowed.
     */
    public String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The name of the service mesh in which to create the route.
     * </p>
     * 
     * @return The name of the service mesh in which to create the route.
     */
    public String meshName() {
        return meshName;
    }

    /**
     * <p>
     * The name to use for the route.
     * </p>
     * 
     * @return The name to use for the route.
     */
    public String routeName() {
        return routeName;
    }

    /**
     * <p>
     * The route specification to apply.
     * </p>
     * 
     * @return The route specification to apply.
     */
    public RouteSpec spec() {
        return spec;
    }

    /**
     * <p>
     * The name of the virtual router in which to create the route.
     * </p>
     * 
     * @return The name of the virtual router in which to create the route.
     */
    public String virtualRouterName() {
        return virtualRouterName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(meshName());
        hashCode = 31 * hashCode + Objects.hashCode(routeName());
        hashCode = 31 * hashCode + Objects.hashCode(spec());
        hashCode = 31 * hashCode + Objects.hashCode(virtualRouterName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRouteRequest)) {
            return false;
        }
        CreateRouteRequest other = (CreateRouteRequest) obj;
        return Objects.equals(clientToken(), other.clientToken()) && Objects.equals(meshName(), other.meshName())
                && Objects.equals(routeName(), other.routeName()) && Objects.equals(spec(), other.spec())
                && Objects.equals(virtualRouterName(), other.virtualRouterName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateRouteRequest").add("ClientToken", clientToken()).add("MeshName", meshName())
                .add("RouteName", routeName()).add("Spec", spec()).add("VirtualRouterName", virtualRouterName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "meshName":
            return Optional.ofNullable(clazz.cast(meshName()));
        case "routeName":
            return Optional.ofNullable(clazz.cast(routeName()));
        case "spec":
            return Optional.ofNullable(clazz.cast(spec()));
        case "virtualRouterName":
            return Optional.ofNullable(clazz.cast(virtualRouterName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateRouteRequest, T> g) {
        return obj -> g.apply((CreateRouteRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppMeshRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateRouteRequest> {
        /**
         * <p>
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 36
         * letters, numbers, hyphens, and underscores are allowed.
         * </p>
         * 
         * @param clientToken
         *        Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Up to 36
         *        letters, numbers, hyphens, and underscores are allowed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The name of the service mesh in which to create the route.
         * </p>
         * 
         * @param meshName
         *        The name of the service mesh in which to create the route.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder meshName(String meshName);

        /**
         * <p>
         * The name to use for the route.
         * </p>
         * 
         * @param routeName
         *        The name to use for the route.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routeName(String routeName);

        /**
         * <p>
         * The route specification to apply.
         * </p>
         * 
         * @param spec
         *        The route specification to apply.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spec(RouteSpec spec);

        /**
         * <p>
         * The route specification to apply.
         * </p>
         * This is a convenience that creates an instance of the {@link RouteSpec.Builder} avoiding the need to create
         * one manually via {@link RouteSpec#builder()}.
         *
         * When the {@link Consumer} completes, {@link RouteSpec.Builder#build()} is called immediately and its result
         * is passed to {@link #spec(RouteSpec)}.
         * 
         * @param spec
         *        a consumer that will call methods on {@link RouteSpec.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #spec(RouteSpec)
         */
        default Builder spec(Consumer<RouteSpec.Builder> spec) {
            return spec(RouteSpec.builder().applyMutation(spec).build());
        }

        /**
         * <p>
         * The name of the virtual router in which to create the route.
         * </p>
         * 
         * @param virtualRouterName
         *        The name of the virtual router in which to create the route.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder virtualRouterName(String virtualRouterName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AppMeshRequest.BuilderImpl implements Builder {
        private String clientToken;

        private String meshName;

        private String routeName;

        private RouteSpec spec;

        private String virtualRouterName;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRouteRequest model) {
            super(model);
            clientToken(model.clientToken);
            meshName(model.meshName);
            routeName(model.routeName);
            spec(model.spec);
            virtualRouterName(model.virtualRouterName);
        }

        public final String getClientToken() {
            return clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final String getMeshName() {
            return meshName;
        }

        @Override
        public final Builder meshName(String meshName) {
            this.meshName = meshName;
            return this;
        }

        public final void setMeshName(String meshName) {
            this.meshName = meshName;
        }

        public final String getRouteName() {
            return routeName;
        }

        @Override
        public final Builder routeName(String routeName) {
            this.routeName = routeName;
            return this;
        }

        public final void setRouteName(String routeName) {
            this.routeName = routeName;
        }

        public final RouteSpec.Builder getSpec() {
            return spec != null ? spec.toBuilder() : null;
        }

        @Override
        public final Builder spec(RouteSpec spec) {
            this.spec = spec;
            return this;
        }

        public final void setSpec(RouteSpec.BuilderImpl spec) {
            this.spec = spec != null ? spec.build() : null;
        }

        public final String getVirtualRouterName() {
            return virtualRouterName;
        }

        @Override
        public final Builder virtualRouterName(String virtualRouterName) {
            this.virtualRouterName = virtualRouterName;
            return this;
        }

        public final void setVirtualRouterName(String virtualRouterName) {
            this.virtualRouterName = virtualRouterName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateRouteRequest build() {
            return new CreateRouteRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
