/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appmesh.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object representing a virtual router listener.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VirtualRouterListener implements SdkPojo, Serializable,
        ToCopyableBuilder<VirtualRouterListener.Builder, VirtualRouterListener> {
    private static final SdkField<PortMapping> PORT_MAPPING_FIELD = SdkField.<PortMapping> builder(MarshallingType.SDK_POJO)
            .getter(getter(VirtualRouterListener::portMapping)).setter(setter(Builder::portMapping))
            .constructor(PortMapping::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("portMapping").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PORT_MAPPING_FIELD));

    private static final long serialVersionUID = 1L;

    private final PortMapping portMapping;

    private VirtualRouterListener(BuilderImpl builder) {
        this.portMapping = builder.portMapping;
    }

    /**
     * Returns the value of the PortMapping property for this object.
     * 
     * @return The value of the PortMapping property for this object.
     */
    public PortMapping portMapping() {
        return portMapping;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(portMapping());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VirtualRouterListener)) {
            return false;
        }
        VirtualRouterListener other = (VirtualRouterListener) obj;
        return Objects.equals(portMapping(), other.portMapping());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("VirtualRouterListener").add("PortMapping", portMapping()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "portMapping":
            return Optional.ofNullable(clazz.cast(portMapping()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VirtualRouterListener, T> g) {
        return obj -> g.apply((VirtualRouterListener) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VirtualRouterListener> {
        /**
         * Sets the value of the PortMapping property for this object.
         *
         * @param portMapping
         *        The new value for the PortMapping property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder portMapping(PortMapping portMapping);

        /**
         * Sets the value of the PortMapping property for this object.
         *
         * This is a convenience that creates an instance of the {@link PortMapping.Builder} avoiding the need to create
         * one manually via {@link PortMapping#builder()}.
         *
         * When the {@link Consumer} completes, {@link PortMapping.Builder#build()} is called immediately and its result
         * is passed to {@link #portMapping(PortMapping)}.
         * 
         * @param portMapping
         *        a consumer that will call methods on {@link PortMapping.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #portMapping(PortMapping)
         */
        default Builder portMapping(Consumer<PortMapping.Builder> portMapping) {
            return portMapping(PortMapping.builder().applyMutation(portMapping).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private PortMapping portMapping;

        private BuilderImpl() {
        }

        private BuilderImpl(VirtualRouterListener model) {
            portMapping(model.portMapping);
        }

        public final PortMapping.Builder getPortMapping() {
            return portMapping != null ? portMapping.toBuilder() : null;
        }

        @Override
        public final Builder portMapping(PortMapping portMapping) {
            this.portMapping = portMapping;
            return this;
        }

        public final void setPortMapping(PortMapping.BuilderImpl portMapping) {
            this.portMapping = portMapping != null ? portMapping.build() : null;
        }

        @Override
        public VirtualRouterListener build() {
            return new VirtualRouterListener(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
