/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appmesh.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateVirtualServiceResponse extends AppMeshResponse implements
        ToCopyableBuilder<CreateVirtualServiceResponse.Builder, CreateVirtualServiceResponse> {
    private static final SdkField<VirtualServiceData> VIRTUAL_SERVICE_FIELD = SdkField
            .<VirtualServiceData> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreateVirtualServiceResponse::virtualService))
            .setter(setter(Builder::virtualService))
            .constructor(VirtualServiceData::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("virtualService").build(),
                    PayloadTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VIRTUAL_SERVICE_FIELD));

    private final VirtualServiceData virtualService;

    private CreateVirtualServiceResponse(BuilderImpl builder) {
        super(builder);
        this.virtualService = builder.virtualService;
    }

    /**
     * <p>
     * The full description of your virtual service following the create call.
     * </p>
     * 
     * @return The full description of your virtual service following the create call.
     */
    public VirtualServiceData virtualService() {
        return virtualService;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(virtualService());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateVirtualServiceResponse)) {
            return false;
        }
        CreateVirtualServiceResponse other = (CreateVirtualServiceResponse) obj;
        return Objects.equals(virtualService(), other.virtualService());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateVirtualServiceResponse").add("VirtualService", virtualService()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "virtualService":
            return Optional.ofNullable(clazz.cast(virtualService()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateVirtualServiceResponse, T> g) {
        return obj -> g.apply((CreateVirtualServiceResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppMeshResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateVirtualServiceResponse> {
        /**
         * <p>
         * The full description of your virtual service following the create call.
         * </p>
         * 
         * @param virtualService
         *        The full description of your virtual service following the create call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder virtualService(VirtualServiceData virtualService);

        /**
         * <p>
         * The full description of your virtual service following the create call.
         * </p>
         * This is a convenience that creates an instance of the {@link VirtualServiceData.Builder} avoiding the need to
         * create one manually via {@link VirtualServiceData#builder()}.
         *
         * When the {@link Consumer} completes, {@link VirtualServiceData.Builder#build()} is called immediately and its
         * result is passed to {@link #virtualService(VirtualServiceData)}.
         * 
         * @param virtualService
         *        a consumer that will call methods on {@link VirtualServiceData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #virtualService(VirtualServiceData)
         */
        default Builder virtualService(Consumer<VirtualServiceData.Builder> virtualService) {
            return virtualService(VirtualServiceData.builder().applyMutation(virtualService).build());
        }
    }

    static final class BuilderImpl extends AppMeshResponse.BuilderImpl implements Builder {
        private VirtualServiceData virtualService;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateVirtualServiceResponse model) {
            super(model);
            virtualService(model.virtualService);
        }

        public final VirtualServiceData.Builder getVirtualService() {
            return virtualService != null ? virtualService.toBuilder() : null;
        }

        @Override
        public final Builder virtualService(VirtualServiceData virtualService) {
            this.virtualService = virtualService;
            return this;
        }

        public final void setVirtualService(VirtualServiceData.BuilderImpl virtualService) {
            this.virtualService = virtualService != null ? virtualService.build() : null;
        }

        @Override
        public CreateVirtualServiceResponse build() {
            return new CreateVirtualServiceResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
