/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appmesh.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateMeshResponse extends AppMeshResponse implements
        ToCopyableBuilder<CreateMeshResponse.Builder, CreateMeshResponse> {
    private static final SdkField<MeshData> MESH_FIELD = SdkField
            .<MeshData> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreateMeshResponse::mesh))
            .setter(setter(Builder::mesh))
            .constructor(MeshData::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mesh").build(),
                    PayloadTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MESH_FIELD));

    private final MeshData mesh;

    private CreateMeshResponse(BuilderImpl builder) {
        super(builder);
        this.mesh = builder.mesh;
    }

    /**
     * <p>
     * The full description of your service mesh following the create call.
     * </p>
     * 
     * @return The full description of your service mesh following the create call.
     */
    public MeshData mesh() {
        return mesh;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(mesh());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateMeshResponse)) {
            return false;
        }
        CreateMeshResponse other = (CreateMeshResponse) obj;
        return Objects.equals(mesh(), other.mesh());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateMeshResponse").add("Mesh", mesh()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "mesh":
            return Optional.ofNullable(clazz.cast(mesh()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateMeshResponse, T> g) {
        return obj -> g.apply((CreateMeshResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppMeshResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateMeshResponse> {
        /**
         * <p>
         * The full description of your service mesh following the create call.
         * </p>
         * 
         * @param mesh
         *        The full description of your service mesh following the create call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mesh(MeshData mesh);

        /**
         * <p>
         * The full description of your service mesh following the create call.
         * </p>
         * This is a convenience that creates an instance of the {@link MeshData.Builder} avoiding the need to create
         * one manually via {@link MeshData#builder()}.
         *
         * When the {@link Consumer} completes, {@link MeshData.Builder#build()} is called immediately and its result is
         * passed to {@link #mesh(MeshData)}.
         * 
         * @param mesh
         *        a consumer that will call methods on {@link MeshData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mesh(MeshData)
         */
        default Builder mesh(Consumer<MeshData.Builder> mesh) {
            return mesh(MeshData.builder().applyMutation(mesh).build());
        }
    }

    static final class BuilderImpl extends AppMeshResponse.BuilderImpl implements Builder {
        private MeshData mesh;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateMeshResponse model) {
            super(model);
            mesh(model.mesh);
        }

        public final MeshData.Builder getMesh() {
            return mesh != null ? mesh.toBuilder() : null;
        }

        @Override
        public final Builder mesh(MeshData mesh) {
            this.mesh = mesh;
            return this;
        }

        public final void setMesh(MeshData.BuilderImpl mesh) {
            this.mesh = mesh != null ? mesh.build() : null;
        }

        @Override
        public CreateMeshResponse build() {
            return new CreateMeshResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
