/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appmesh.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object representing the AWS Cloud Map service discovery information for your virtual node.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsCloudMapServiceDiscovery implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsCloudMapServiceDiscovery.Builder, AwsCloudMapServiceDiscovery> {
    private static final SdkField<List<AwsCloudMapInstanceAttribute>> ATTRIBUTES_FIELD = SdkField
            .<List<AwsCloudMapInstanceAttribute>> builder(MarshallingType.LIST)
            .getter(getter(AwsCloudMapServiceDiscovery::attributes))
            .setter(setter(Builder::attributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsCloudMapInstanceAttribute> builder(MarshallingType.SDK_POJO)
                                            .constructor(AwsCloudMapInstanceAttribute::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NAMESPACE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AwsCloudMapServiceDiscovery::namespaceName)).setter(setter(Builder::namespaceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespaceName").build()).build();

    private static final SdkField<String> SERVICE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AwsCloudMapServiceDiscovery::serviceName)).setter(setter(Builder::serviceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTES_FIELD,
            NAMESPACE_NAME_FIELD, SERVICE_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<AwsCloudMapInstanceAttribute> attributes;

    private final String namespaceName;

    private final String serviceName;

    private AwsCloudMapServiceDiscovery(BuilderImpl builder) {
        this.attributes = builder.attributes;
        this.namespaceName = builder.namespaceName;
        this.serviceName = builder.serviceName;
    }

    /**
     * <p>
     * A string map that contains attributes with values that you can use to filter instances by any custom attribute
     * that you specified when you registered the instance. Only instances that match all of the specified key/value
     * pairs will be returned.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A string map that contains attributes with values that you can use to filter instances by any custom
     *         attribute that you specified when you registered the instance. Only instances that match all of the
     *         specified key/value pairs will be returned.
     */
    public List<AwsCloudMapInstanceAttribute> attributes() {
        return attributes;
    }

    /**
     * <p>
     * The name of the AWS Cloud Map namespace to use.
     * </p>
     * 
     * @return The name of the AWS Cloud Map namespace to use.
     */
    public String namespaceName() {
        return namespaceName;
    }

    /**
     * <p>
     * The name of the AWS Cloud Map service to use.
     * </p>
     * 
     * @return The name of the AWS Cloud Map service to use.
     */
    public String serviceName() {
        return serviceName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(attributes());
        hashCode = 31 * hashCode + Objects.hashCode(namespaceName());
        hashCode = 31 * hashCode + Objects.hashCode(serviceName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsCloudMapServiceDiscovery)) {
            return false;
        }
        AwsCloudMapServiceDiscovery other = (AwsCloudMapServiceDiscovery) obj;
        return Objects.equals(attributes(), other.attributes()) && Objects.equals(namespaceName(), other.namespaceName())
                && Objects.equals(serviceName(), other.serviceName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AwsCloudMapServiceDiscovery").add("Attributes", attributes())
                .add("NamespaceName", namespaceName()).add("ServiceName", serviceName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "attributes":
            return Optional.ofNullable(clazz.cast(attributes()));
        case "namespaceName":
            return Optional.ofNullable(clazz.cast(namespaceName()));
        case "serviceName":
            return Optional.ofNullable(clazz.cast(serviceName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsCloudMapServiceDiscovery, T> g) {
        return obj -> g.apply((AwsCloudMapServiceDiscovery) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsCloudMapServiceDiscovery> {
        /**
         * <p>
         * A string map that contains attributes with values that you can use to filter instances by any custom
         * attribute that you specified when you registered the instance. Only instances that match all of the specified
         * key/value pairs will be returned.
         * </p>
         * 
         * @param attributes
         *        A string map that contains attributes with values that you can use to filter instances by any custom
         *        attribute that you specified when you registered the instance. Only instances that match all of the
         *        specified key/value pairs will be returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(Collection<AwsCloudMapInstanceAttribute> attributes);

        /**
         * <p>
         * A string map that contains attributes with values that you can use to filter instances by any custom
         * attribute that you specified when you registered the instance. Only instances that match all of the specified
         * key/value pairs will be returned.
         * </p>
         * 
         * @param attributes
         *        A string map that contains attributes with values that you can use to filter instances by any custom
         *        attribute that you specified when you registered the instance. Only instances that match all of the
         *        specified key/value pairs will be returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(AwsCloudMapInstanceAttribute... attributes);

        /**
         * <p>
         * A string map that contains attributes with values that you can use to filter instances by any custom
         * attribute that you specified when you registered the instance. Only instances that match all of the specified
         * key/value pairs will be returned.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AwsCloudMapInstanceAttribute>.Builder}
         * avoiding the need to create one manually via {@link List<AwsCloudMapInstanceAttribute>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AwsCloudMapInstanceAttribute>.Builder#build()} is called
         * immediately and its result is passed to {@link #attributes(List<AwsCloudMapInstanceAttribute>)}.
         * 
         * @param attributes
         *        a consumer that will call methods on {@link List<AwsCloudMapInstanceAttribute>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attributes(List<AwsCloudMapInstanceAttribute>)
         */
        Builder attributes(Consumer<AwsCloudMapInstanceAttribute.Builder>... attributes);

        /**
         * <p>
         * The name of the AWS Cloud Map namespace to use.
         * </p>
         * 
         * @param namespaceName
         *        The name of the AWS Cloud Map namespace to use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespaceName(String namespaceName);

        /**
         * <p>
         * The name of the AWS Cloud Map service to use.
         * </p>
         * 
         * @param serviceName
         *        The name of the AWS Cloud Map service to use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceName(String serviceName);
    }

    static final class BuilderImpl implements Builder {
        private List<AwsCloudMapInstanceAttribute> attributes = DefaultSdkAutoConstructList.getInstance();

        private String namespaceName;

        private String serviceName;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsCloudMapServiceDiscovery model) {
            attributes(model.attributes);
            namespaceName(model.namespaceName);
            serviceName(model.serviceName);
        }

        public final Collection<AwsCloudMapInstanceAttribute.Builder> getAttributes() {
            return attributes != null ? attributes.stream().map(AwsCloudMapInstanceAttribute::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder attributes(Collection<AwsCloudMapInstanceAttribute> attributes) {
            this.attributes = AwsCloudMapInstanceAttributesCopier.copy(attributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(AwsCloudMapInstanceAttribute... attributes) {
            attributes(Arrays.asList(attributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(Consumer<AwsCloudMapInstanceAttribute.Builder>... attributes) {
            attributes(Stream.of(attributes).map(c -> AwsCloudMapInstanceAttribute.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setAttributes(Collection<AwsCloudMapInstanceAttribute.BuilderImpl> attributes) {
            this.attributes = AwsCloudMapInstanceAttributesCopier.copyFromBuilder(attributes);
        }

        public final String getNamespaceName() {
            return namespaceName;
        }

        @Override
        public final Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public final void setNamespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
        }

        public final String getServiceName() {
            return serviceName;
        }

        @Override
        public final Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public final void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        @Override
        public AwsCloudMapServiceDiscovery build() {
            return new AwsCloudMapServiceDiscovery(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
