/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appmesh.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object representing the method and value to match the header value sent with a request. Specify one match method.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HeaderMatchMethod implements SdkPojo, Serializable,
        ToCopyableBuilder<HeaderMatchMethod.Builder, HeaderMatchMethod> {
    private static final SdkField<String> EXACT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(HeaderMatchMethod::exact)).setter(setter(Builder::exact))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exact").build()).build();

    private static final SdkField<String> PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(HeaderMatchMethod::prefix)).setter(setter(Builder::prefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("prefix").build()).build();

    private static final SdkField<MatchRange> RANGE_FIELD = SdkField.<MatchRange> builder(MarshallingType.SDK_POJO)
            .getter(getter(HeaderMatchMethod::range)).setter(setter(Builder::range)).constructor(MatchRange::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("range").build()).build();

    private static final SdkField<String> REGEX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(HeaderMatchMethod::regex)).setter(setter(Builder::regex))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("regex").build()).build();

    private static final SdkField<String> SUFFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(HeaderMatchMethod::suffix)).setter(setter(Builder::suffix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("suffix").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXACT_FIELD, PREFIX_FIELD,
            RANGE_FIELD, REGEX_FIELD, SUFFIX_FIELD));

    private static final long serialVersionUID = 1L;

    private final String exact;

    private final String prefix;

    private final MatchRange range;

    private final String regex;

    private final String suffix;

    private HeaderMatchMethod(BuilderImpl builder) {
        this.exact = builder.exact;
        this.prefix = builder.prefix;
        this.range = builder.range;
        this.regex = builder.regex;
        this.suffix = builder.suffix;
    }

    /**
     * <p>
     * The header value sent by the client must match the specified value exactly.
     * </p>
     * 
     * @return The header value sent by the client must match the specified value exactly.
     */
    public String exact() {
        return exact;
    }

    /**
     * <p>
     * The header value sent by the client must begin with the specified characters.
     * </p>
     * 
     * @return The header value sent by the client must begin with the specified characters.
     */
    public String prefix() {
        return prefix;
    }

    /**
     * <p>
     * The object that specifies the range of numbers that the header value sent by the client must be included in.
     * </p>
     * 
     * @return The object that specifies the range of numbers that the header value sent by the client must be included
     *         in.
     */
    public MatchRange range() {
        return range;
    }

    /**
     * <p>
     * The header value sent by the client must include the specified characters.
     * </p>
     * 
     * @return The header value sent by the client must include the specified characters.
     */
    public String regex() {
        return regex;
    }

    /**
     * <p>
     * The header value sent by the client must end with the specified characters.
     * </p>
     * 
     * @return The header value sent by the client must end with the specified characters.
     */
    public String suffix() {
        return suffix;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(exact());
        hashCode = 31 * hashCode + Objects.hashCode(prefix());
        hashCode = 31 * hashCode + Objects.hashCode(range());
        hashCode = 31 * hashCode + Objects.hashCode(regex());
        hashCode = 31 * hashCode + Objects.hashCode(suffix());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HeaderMatchMethod)) {
            return false;
        }
        HeaderMatchMethod other = (HeaderMatchMethod) obj;
        return Objects.equals(exact(), other.exact()) && Objects.equals(prefix(), other.prefix())
                && Objects.equals(range(), other.range()) && Objects.equals(regex(), other.regex())
                && Objects.equals(suffix(), other.suffix());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("HeaderMatchMethod").add("Exact", exact()).add("Prefix", prefix()).add("Range", range())
                .add("Regex", regex()).add("Suffix", suffix()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "exact":
            return Optional.ofNullable(clazz.cast(exact()));
        case "prefix":
            return Optional.ofNullable(clazz.cast(prefix()));
        case "range":
            return Optional.ofNullable(clazz.cast(range()));
        case "regex":
            return Optional.ofNullable(clazz.cast(regex()));
        case "suffix":
            return Optional.ofNullable(clazz.cast(suffix()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HeaderMatchMethod, T> g) {
        return obj -> g.apply((HeaderMatchMethod) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HeaderMatchMethod> {
        /**
         * <p>
         * The header value sent by the client must match the specified value exactly.
         * </p>
         * 
         * @param exact
         *        The header value sent by the client must match the specified value exactly.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exact(String exact);

        /**
         * <p>
         * The header value sent by the client must begin with the specified characters.
         * </p>
         * 
         * @param prefix
         *        The header value sent by the client must begin with the specified characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prefix(String prefix);

        /**
         * <p>
         * The object that specifies the range of numbers that the header value sent by the client must be included in.
         * </p>
         * 
         * @param range
         *        The object that specifies the range of numbers that the header value sent by the client must be
         *        included in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder range(MatchRange range);

        /**
         * <p>
         * The object that specifies the range of numbers that the header value sent by the client must be included in.
         * </p>
         * This is a convenience that creates an instance of the {@link MatchRange.Builder} avoiding the need to create
         * one manually via {@link MatchRange#builder()}.
         *
         * When the {@link Consumer} completes, {@link MatchRange.Builder#build()} is called immediately and its result
         * is passed to {@link #range(MatchRange)}.
         * 
         * @param range
         *        a consumer that will call methods on {@link MatchRange.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #range(MatchRange)
         */
        default Builder range(Consumer<MatchRange.Builder> range) {
            return range(MatchRange.builder().applyMutation(range).build());
        }

        /**
         * <p>
         * The header value sent by the client must include the specified characters.
         * </p>
         * 
         * @param regex
         *        The header value sent by the client must include the specified characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regex(String regex);

        /**
         * <p>
         * The header value sent by the client must end with the specified characters.
         * </p>
         * 
         * @param suffix
         *        The header value sent by the client must end with the specified characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder suffix(String suffix);
    }

    static final class BuilderImpl implements Builder {
        private String exact;

        private String prefix;

        private MatchRange range;

        private String regex;

        private String suffix;

        private BuilderImpl() {
        }

        private BuilderImpl(HeaderMatchMethod model) {
            exact(model.exact);
            prefix(model.prefix);
            range(model.range);
            regex(model.regex);
            suffix(model.suffix);
        }

        public final String getExact() {
            return exact;
        }

        @Override
        public final Builder exact(String exact) {
            this.exact = exact;
            return this;
        }

        public final void setExact(String exact) {
            this.exact = exact;
        }

        public final String getPrefix() {
            return prefix;
        }

        @Override
        public final Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public final void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public final MatchRange.Builder getRange() {
            return range != null ? range.toBuilder() : null;
        }

        @Override
        public final Builder range(MatchRange range) {
            this.range = range;
            return this;
        }

        public final void setRange(MatchRange.BuilderImpl range) {
            this.range = range != null ? range.build() : null;
        }

        public final String getRegex() {
            return regex;
        }

        @Override
        public final Builder regex(String regex) {
            this.regex = regex;
            return this;
        }

        public final void setRegex(String regex) {
            this.regex = regex;
        }

        public final String getSuffix() {
            return suffix;
        }

        @Override
        public final Builder suffix(String suffix) {
            this.suffix = suffix;
            return this;
        }

        public final void setSuffix(String suffix) {
            this.suffix = suffix;
        }

        @Override
        public HeaderMatchMethod build() {
            return new HeaderMatchMethod(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
