/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appmesh.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object representing a virtual service returned by a list operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VirtualServiceRef implements SdkPojo, Serializable,
        ToCopyableBuilder<VirtualServiceRef.Builder, VirtualServiceRef> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(VirtualServiceRef::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> MESH_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(VirtualServiceRef::meshName)).setter(setter(Builder::meshName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("meshName").build()).build();

    private static final SdkField<String> VIRTUAL_SERVICE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(VirtualServiceRef::virtualServiceName)).setter(setter(Builder::virtualServiceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("virtualServiceName").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, MESH_NAME_FIELD,
            VIRTUAL_SERVICE_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String meshName;

    private final String virtualServiceName;

    private VirtualServiceRef(BuilderImpl builder) {
        this.arn = builder.arn;
        this.meshName = builder.meshName;
        this.virtualServiceName = builder.virtualServiceName;
    }

    /**
     * <p>
     * The full Amazon Resource Name (ARN) for the virtual service.
     * </p>
     * 
     * @return The full Amazon Resource Name (ARN) for the virtual service.
     */
    public String arn() {
        return arn;
    }

    /**
     * <p>
     * The name of the service mesh that the virtual service resides in.
     * </p>
     * 
     * @return The name of the service mesh that the virtual service resides in.
     */
    public String meshName() {
        return meshName;
    }

    /**
     * <p>
     * The name of the virtual service.
     * </p>
     * 
     * @return The name of the virtual service.
     */
    public String virtualServiceName() {
        return virtualServiceName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(meshName());
        hashCode = 31 * hashCode + Objects.hashCode(virtualServiceName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VirtualServiceRef)) {
            return false;
        }
        VirtualServiceRef other = (VirtualServiceRef) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(meshName(), other.meshName())
                && Objects.equals(virtualServiceName(), other.virtualServiceName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("VirtualServiceRef").add("Arn", arn()).add("MeshName", meshName())
                .add("VirtualServiceName", virtualServiceName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "meshName":
            return Optional.ofNullable(clazz.cast(meshName()));
        case "virtualServiceName":
            return Optional.ofNullable(clazz.cast(virtualServiceName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VirtualServiceRef, T> g) {
        return obj -> g.apply((VirtualServiceRef) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VirtualServiceRef> {
        /**
         * <p>
         * The full Amazon Resource Name (ARN) for the virtual service.
         * </p>
         * 
         * @param arn
         *        The full Amazon Resource Name (ARN) for the virtual service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The name of the service mesh that the virtual service resides in.
         * </p>
         * 
         * @param meshName
         *        The name of the service mesh that the virtual service resides in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder meshName(String meshName);

        /**
         * <p>
         * The name of the virtual service.
         * </p>
         * 
         * @param virtualServiceName
         *        The name of the virtual service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder virtualServiceName(String virtualServiceName);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String meshName;

        private String virtualServiceName;

        private BuilderImpl() {
        }

        private BuilderImpl(VirtualServiceRef model) {
            arn(model.arn);
            meshName(model.meshName);
            virtualServiceName(model.virtualServiceName);
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getMeshName() {
            return meshName;
        }

        @Override
        public final Builder meshName(String meshName) {
            this.meshName = meshName;
            return this;
        }

        public final void setMeshName(String meshName) {
            this.meshName = meshName;
        }

        public final String getVirtualServiceName() {
            return virtualServiceName;
        }

        @Override
        public final Builder virtualServiceName(String virtualServiceName) {
            this.virtualServiceName = virtualServiceName;
            return this;
        }

        public final void setVirtualServiceName(String virtualServiceName) {
            this.virtualServiceName = virtualServiceName;
        }

        @Override
        public VirtualServiceRef build() {
            return new VirtualServiceRef(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
