/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appmesh.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object representing the TCP routing specification for a route.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TcpRoute implements SdkPojo, Serializable, ToCopyableBuilder<TcpRoute.Builder, TcpRoute> {
    private static final SdkField<TcpRouteAction> ACTION_FIELD = SdkField.<TcpRouteAction> builder(MarshallingType.SDK_POJO)
            .getter(getter(TcpRoute::action)).setter(setter(Builder::action)).constructor(TcpRouteAction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("action").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final TcpRouteAction action;

    private TcpRoute(BuilderImpl builder) {
        this.action = builder.action;
    }

    /**
     * <p>
     * The action to take if a match is determined.
     * </p>
     * 
     * @return The action to take if a match is determined.
     */
    public TcpRouteAction action() {
        return action;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(action());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TcpRoute)) {
            return false;
        }
        TcpRoute other = (TcpRoute) obj;
        return Objects.equals(action(), other.action());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("TcpRoute").add("Action", action()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "action":
            return Optional.ofNullable(clazz.cast(action()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TcpRoute, T> g) {
        return obj -> g.apply((TcpRoute) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TcpRoute> {
        /**
         * <p>
         * The action to take if a match is determined.
         * </p>
         * 
         * @param action
         *        The action to take if a match is determined.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder action(TcpRouteAction action);

        /**
         * <p>
         * The action to take if a match is determined.
         * </p>
         * This is a convenience that creates an instance of the {@link TcpRouteAction.Builder} avoiding the need to
         * create one manually via {@link TcpRouteAction#builder()}.
         *
         * When the {@link Consumer} completes, {@link TcpRouteAction.Builder#build()} is called immediately and its
         * result is passed to {@link #action(TcpRouteAction)}.
         * 
         * @param action
         *        a consumer that will call methods on {@link TcpRouteAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #action(TcpRouteAction)
         */
        default Builder action(Consumer<TcpRouteAction.Builder> action) {
            return action(TcpRouteAction.builder().applyMutation(action).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private TcpRouteAction action;

        private BuilderImpl() {
        }

        private BuilderImpl(TcpRoute model) {
            action(model.action);
        }

        public final TcpRouteAction.Builder getAction() {
            return action != null ? action.toBuilder() : null;
        }

        @Override
        public final Builder action(TcpRouteAction action) {
            this.action = action;
            return this;
        }

        public final void setAction(TcpRouteAction.BuilderImpl action) {
            this.action = action != null ? action.build() : null;
        }

        @Override
        public TcpRoute build() {
            return new TcpRoute(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
