/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appmesh.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object representing the traffic distribution requirements for matched HTTP requests.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HttpRouteAction implements SdkPojo, Serializable, ToCopyableBuilder<HttpRouteAction.Builder, HttpRouteAction> {
    private static final SdkField<List<WeightedTarget>> WEIGHTED_TARGETS_FIELD = SdkField
            .<List<WeightedTarget>> builder(MarshallingType.LIST)
            .getter(getter(HttpRouteAction::weightedTargets))
            .setter(setter(Builder::weightedTargets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("weightedTargets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<WeightedTarget> builder(MarshallingType.SDK_POJO)
                                            .constructor(WeightedTarget::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WEIGHTED_TARGETS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<WeightedTarget> weightedTargets;

    private HttpRouteAction(BuilderImpl builder) {
        this.weightedTargets = builder.weightedTargets;
    }

    /**
     * <p>
     * The targets that traffic is routed to when a request matches the route. You can specify one or more targets and
     * their relative weights to distribute traffic with.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The targets that traffic is routed to when a request matches the route. You can specify one or more
     *         targets and their relative weights to distribute traffic with.
     */
    public List<WeightedTarget> weightedTargets() {
        return weightedTargets;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(weightedTargets());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HttpRouteAction)) {
            return false;
        }
        HttpRouteAction other = (HttpRouteAction) obj;
        return Objects.equals(weightedTargets(), other.weightedTargets());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("HttpRouteAction").add("WeightedTargets", weightedTargets()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "weightedTargets":
            return Optional.ofNullable(clazz.cast(weightedTargets()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HttpRouteAction, T> g) {
        return obj -> g.apply((HttpRouteAction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HttpRouteAction> {
        /**
         * <p>
         * The targets that traffic is routed to when a request matches the route. You can specify one or more targets
         * and their relative weights to distribute traffic with.
         * </p>
         * 
         * @param weightedTargets
         *        The targets that traffic is routed to when a request matches the route. You can specify one or more
         *        targets and their relative weights to distribute traffic with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder weightedTargets(Collection<WeightedTarget> weightedTargets);

        /**
         * <p>
         * The targets that traffic is routed to when a request matches the route. You can specify one or more targets
         * and their relative weights to distribute traffic with.
         * </p>
         * 
         * @param weightedTargets
         *        The targets that traffic is routed to when a request matches the route. You can specify one or more
         *        targets and their relative weights to distribute traffic with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder weightedTargets(WeightedTarget... weightedTargets);

        /**
         * <p>
         * The targets that traffic is routed to when a request matches the route. You can specify one or more targets
         * and their relative weights to distribute traffic with.
         * </p>
         * This is a convenience that creates an instance of the {@link List<WeightedTarget>.Builder} avoiding the need
         * to create one manually via {@link List<WeightedTarget>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<WeightedTarget>.Builder#build()} is called immediately and
         * its result is passed to {@link #weightedTargets(List<WeightedTarget>)}.
         * 
         * @param weightedTargets
         *        a consumer that will call methods on {@link List<WeightedTarget>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #weightedTargets(List<WeightedTarget>)
         */
        Builder weightedTargets(Consumer<WeightedTarget.Builder>... weightedTargets);
    }

    static final class BuilderImpl implements Builder {
        private List<WeightedTarget> weightedTargets = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(HttpRouteAction model) {
            weightedTargets(model.weightedTargets);
        }

        public final Collection<WeightedTarget.Builder> getWeightedTargets() {
            return weightedTargets != null ? weightedTargets.stream().map(WeightedTarget::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder weightedTargets(Collection<WeightedTarget> weightedTargets) {
            this.weightedTargets = WeightedTargetsCopier.copy(weightedTargets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder weightedTargets(WeightedTarget... weightedTargets) {
            weightedTargets(Arrays.asList(weightedTargets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder weightedTargets(Consumer<WeightedTarget.Builder>... weightedTargets) {
            weightedTargets(Stream.of(weightedTargets).map(c -> WeightedTarget.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setWeightedTargets(Collection<WeightedTarget.BuilderImpl> weightedTargets) {
            this.weightedTargets = WeightedTargetsCopier.copyFromBuilder(weightedTargets);
        }

        @Override
        public HttpRouteAction build() {
            return new HttpRouteAction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
