/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appmesh.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object representing the duration between retry attempts.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Duration implements SdkPojo, Serializable, ToCopyableBuilder<Duration.Builder, Duration> {
    private static final SdkField<String> UNIT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Duration::unitAsString)).setter(setter(Builder::unit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unit").build()).build();

    private static final SdkField<Long> VALUE_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(Duration::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UNIT_FIELD, VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String unit;

    private final Long value;

    private Duration(BuilderImpl builder) {
        this.unit = builder.unit;
        this.value = builder.value;
    }

    /**
     * <p>
     * The unit of time between retry attempts.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #unit} will return
     * {@link DurationUnit#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #unitAsString}.
     * </p>
     * 
     * @return The unit of time between retry attempts.
     * @see DurationUnit
     */
    public DurationUnit unit() {
        return DurationUnit.fromValue(unit);
    }

    /**
     * <p>
     * The unit of time between retry attempts.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #unit} will return
     * {@link DurationUnit#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #unitAsString}.
     * </p>
     * 
     * @return The unit of time between retry attempts.
     * @see DurationUnit
     */
    public String unitAsString() {
        return unit;
    }

    /**
     * <p>
     * The duration of time between retry attempts.
     * </p>
     * 
     * @return The duration of time between retry attempts.
     */
    public Long value() {
        return value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(unitAsString());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Duration)) {
            return false;
        }
        Duration other = (Duration) obj;
        return Objects.equals(unitAsString(), other.unitAsString()) && Objects.equals(value(), other.value());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Duration").add("Unit", unitAsString()).add("Value", value()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "unit":
            return Optional.ofNullable(clazz.cast(unitAsString()));
        case "value":
            return Optional.ofNullable(clazz.cast(value()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Duration, T> g) {
        return obj -> g.apply((Duration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Duration> {
        /**
         * <p>
         * The unit of time between retry attempts.
         * </p>
         * 
         * @param unit
         *        The unit of time between retry attempts.
         * @see DurationUnit
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DurationUnit
         */
        Builder unit(String unit);

        /**
         * <p>
         * The unit of time between retry attempts.
         * </p>
         * 
         * @param unit
         *        The unit of time between retry attempts.
         * @see DurationUnit
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DurationUnit
         */
        Builder unit(DurationUnit unit);

        /**
         * <p>
         * The duration of time between retry attempts.
         * </p>
         * 
         * @param value
         *        The duration of time between retry attempts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(Long value);
    }

    static final class BuilderImpl implements Builder {
        private String unit;

        private Long value;

        private BuilderImpl() {
        }

        private BuilderImpl(Duration model) {
            unit(model.unit);
            value(model.value);
        }

        public final String getUnitAsString() {
            return unit;
        }

        @Override
        public final Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        @Override
        public final Builder unit(DurationUnit unit) {
            this.unit(unit == null ? null : unit.toString());
            return this;
        }

        public final void setUnit(String unit) {
            this.unit = unit;
        }

        public final Long getValue() {
            return value;
        }

        @Override
        public final Builder value(Long value) {
            this.value = value;
            return this;
        }

        public final void setValue(Long value) {
            this.value = value;
        }

        @Override
        public Duration build() {
            return new Duration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
