/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appmesh.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object representing the DNS service discovery information for your virtual node.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DnsServiceDiscovery implements SdkPojo, Serializable,
        ToCopyableBuilder<DnsServiceDiscovery.Builder, DnsServiceDiscovery> {
    private static final SdkField<String> HOSTNAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DnsServiceDiscovery::hostname)).setter(setter(Builder::hostname))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hostname").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HOSTNAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String hostname;

    private DnsServiceDiscovery(BuilderImpl builder) {
        this.hostname = builder.hostname;
    }

    /**
     * <p>
     * Specifies the DNS service discovery hostname for the virtual node.
     * </p>
     * 
     * @return Specifies the DNS service discovery hostname for the virtual node.
     */
    public String hostname() {
        return hostname;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hostname());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DnsServiceDiscovery)) {
            return false;
        }
        DnsServiceDiscovery other = (DnsServiceDiscovery) obj;
        return Objects.equals(hostname(), other.hostname());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DnsServiceDiscovery").add("Hostname", hostname()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "hostname":
            return Optional.ofNullable(clazz.cast(hostname()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DnsServiceDiscovery, T> g) {
        return obj -> g.apply((DnsServiceDiscovery) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DnsServiceDiscovery> {
        /**
         * <p>
         * Specifies the DNS service discovery hostname for the virtual node.
         * </p>
         * 
         * @param hostname
         *        Specifies the DNS service discovery hostname for the virtual node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostname(String hostname);
    }

    static final class BuilderImpl implements Builder {
        private String hostname;

        private BuilderImpl() {
        }

        private BuilderImpl(DnsServiceDiscovery model) {
            hostname(model.hostname);
        }

        public final String getHostname() {
            return hostname;
        }

        @Override
        public final Builder hostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        public final void setHostname(String hostname) {
            this.hostname = hostname;
        }

        @Override
        public DnsServiceDiscovery build() {
            return new DnsServiceDiscovery(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
