/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apprunner.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a certificate CNAME record to add to your DNS. For more information, see <a
 * href="https://docs.aws.amazon.com/apprunner/latest/api/API_AssociateCustomDomain.html">AssociateCustomDomain</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CertificateValidationRecord implements SdkPojo, Serializable,
        ToCopyableBuilder<CertificateValidationRecord.Builder, CertificateValidationRecord> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CertificateValidationRecord::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(CertificateValidationRecord::type)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Value")
            .getter(getter(CertificateValidationRecord::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(CertificateValidationRecord::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, TYPE_FIELD,
            VALUE_FIELD, STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String type;

    private final String value;

    private final String status;

    private CertificateValidationRecord(BuilderImpl builder) {
        this.name = builder.name;
        this.type = builder.type;
        this.value = builder.value;
        this.status = builder.status;
    }

    /**
     * <p>
     * The certificate CNAME record name.
     * </p>
     * 
     * @return The certificate CNAME record name.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The record type, always <code>CNAME</code>.
     * </p>
     * 
     * @return The record type, always <code>CNAME</code>.
     */
    public final String type() {
        return type;
    }

    /**
     * <p>
     * The certificate CNAME record value.
     * </p>
     * 
     * @return The certificate CNAME record value.
     */
    public final String value() {
        return value;
    }

    /**
     * <p>
     * The current state of the certificate CNAME record validation. It should change to <code>SUCCESS</code> after App
     * Runner completes validation with your DNS.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link CertificateValidationRecordStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The current state of the certificate CNAME record validation. It should change to <code>SUCCESS</code>
     *         after App Runner completes validation with your DNS.
     * @see CertificateValidationRecordStatus
     */
    public final CertificateValidationRecordStatus status() {
        return CertificateValidationRecordStatus.fromValue(status);
    }

    /**
     * <p>
     * The current state of the certificate CNAME record validation. It should change to <code>SUCCESS</code> after App
     * Runner completes validation with your DNS.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link CertificateValidationRecordStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The current state of the certificate CNAME record validation. It should change to <code>SUCCESS</code>
     *         after App Runner completes validation with your DNS.
     * @see CertificateValidationRecordStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(type());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CertificateValidationRecord)) {
            return false;
        }
        CertificateValidationRecord other = (CertificateValidationRecord) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(type(), other.type())
                && Objects.equals(value(), other.value()) && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CertificateValidationRecord").add("Name", name()).add("Type", type()).add("Value", value())
                .add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Type":
            return Optional.ofNullable(clazz.cast(type()));
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CertificateValidationRecord, T> g) {
        return obj -> g.apply((CertificateValidationRecord) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CertificateValidationRecord> {
        /**
         * <p>
         * The certificate CNAME record name.
         * </p>
         * 
         * @param name
         *        The certificate CNAME record name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The record type, always <code>CNAME</code>.
         * </p>
         * 
         * @param type
         *        The record type, always <code>CNAME</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);

        /**
         * <p>
         * The certificate CNAME record value.
         * </p>
         * 
         * @param value
         *        The certificate CNAME record value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String value);

        /**
         * <p>
         * The current state of the certificate CNAME record validation. It should change to <code>SUCCESS</code> after
         * App Runner completes validation with your DNS.
         * </p>
         * 
         * @param status
         *        The current state of the certificate CNAME record validation. It should change to <code>SUCCESS</code>
         *        after App Runner completes validation with your DNS.
         * @see CertificateValidationRecordStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CertificateValidationRecordStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current state of the certificate CNAME record validation. It should change to <code>SUCCESS</code> after
         * App Runner completes validation with your DNS.
         * </p>
         * 
         * @param status
         *        The current state of the certificate CNAME record validation. It should change to <code>SUCCESS</code>
         *        after App Runner completes validation with your DNS.
         * @see CertificateValidationRecordStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CertificateValidationRecordStatus
         */
        Builder status(CertificateValidationRecordStatus status);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String type;

        private String value;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(CertificateValidationRecord model) {
            name(model.name);
            type(model.type);
            value(model.value);
            status(model.status);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getValue() {
            return value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(CertificateValidationRecordStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public CertificateValidationRecord build() {
            return new CertificateValidationRecord(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
