/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apprunner.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the settings for the health check that AWS App Runner performs to monitor the health of a service.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HealthCheckConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<HealthCheckConfiguration.Builder, HealthCheckConfiguration> {
    private static final SdkField<String> PROTOCOL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Protocol").getter(getter(HealthCheckConfiguration::protocolAsString)).setter(setter(Builder::protocol))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Protocol").build()).build();

    private static final SdkField<String> PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Path")
            .getter(getter(HealthCheckConfiguration::path)).setter(setter(Builder::path))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Path").build()).build();

    private static final SdkField<Integer> INTERVAL_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Interval").getter(getter(HealthCheckConfiguration::interval)).setter(setter(Builder::interval))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Interval").build()).build();

    private static final SdkField<Integer> TIMEOUT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Timeout").getter(getter(HealthCheckConfiguration::timeout)).setter(setter(Builder::timeout))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timeout").build()).build();

    private static final SdkField<Integer> HEALTHY_THRESHOLD_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("HealthyThreshold").getter(getter(HealthCheckConfiguration::healthyThreshold))
            .setter(setter(Builder::healthyThreshold))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthyThreshold").build()).build();

    private static final SdkField<Integer> UNHEALTHY_THRESHOLD_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("UnhealthyThreshold").getter(getter(HealthCheckConfiguration::unhealthyThreshold))
            .setter(setter(Builder::unhealthyThreshold))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnhealthyThreshold").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROTOCOL_FIELD, PATH_FIELD,
            INTERVAL_FIELD, TIMEOUT_FIELD, HEALTHY_THRESHOLD_FIELD, UNHEALTHY_THRESHOLD_FIELD));

    private static final long serialVersionUID = 1L;

    private final String protocol;

    private final String path;

    private final Integer interval;

    private final Integer timeout;

    private final Integer healthyThreshold;

    private final Integer unhealthyThreshold;

    private HealthCheckConfiguration(BuilderImpl builder) {
        this.protocol = builder.protocol;
        this.path = builder.path;
        this.interval = builder.interval;
        this.timeout = builder.timeout;
        this.healthyThreshold = builder.healthyThreshold;
        this.unhealthyThreshold = builder.unhealthyThreshold;
    }

    /**
     * <p>
     * The IP protocol that App Runner uses to perform health checks for your service.
     * </p>
     * <p>
     * If you set <code>Protocol</code> to <code>HTTP</code>, App Runner sends health check requests to the HTTP path
     * specified by <code>Path</code>.
     * </p>
     * <p>
     * Default: <code>TCP</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protocol} will
     * return {@link HealthCheckProtocol#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #protocolAsString}.
     * </p>
     * 
     * @return The IP protocol that App Runner uses to perform health checks for your service.</p>
     *         <p>
     *         If you set <code>Protocol</code> to <code>HTTP</code>, App Runner sends health check requests to the HTTP
     *         path specified by <code>Path</code>.
     *         </p>
     *         <p>
     *         Default: <code>TCP</code>
     * @see HealthCheckProtocol
     */
    public final HealthCheckProtocol protocol() {
        return HealthCheckProtocol.fromValue(protocol);
    }

    /**
     * <p>
     * The IP protocol that App Runner uses to perform health checks for your service.
     * </p>
     * <p>
     * If you set <code>Protocol</code> to <code>HTTP</code>, App Runner sends health check requests to the HTTP path
     * specified by <code>Path</code>.
     * </p>
     * <p>
     * Default: <code>TCP</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protocol} will
     * return {@link HealthCheckProtocol#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #protocolAsString}.
     * </p>
     * 
     * @return The IP protocol that App Runner uses to perform health checks for your service.</p>
     *         <p>
     *         If you set <code>Protocol</code> to <code>HTTP</code>, App Runner sends health check requests to the HTTP
     *         path specified by <code>Path</code>.
     *         </p>
     *         <p>
     *         Default: <code>TCP</code>
     * @see HealthCheckProtocol
     */
    public final String protocolAsString() {
        return protocol;
    }

    /**
     * <p>
     * The URL that health check requests are sent to.
     * </p>
     * <p>
     * <code>Path</code> is only applicable when you set <code>Protocol</code> to <code>HTTP</code>.
     * </p>
     * <p>
     * Default: <code>"/"</code>
     * </p>
     * 
     * @return The URL that health check requests are sent to.</p>
     *         <p>
     *         <code>Path</code> is only applicable when you set <code>Protocol</code> to <code>HTTP</code>.
     *         </p>
     *         <p>
     *         Default: <code>"/"</code>
     */
    public final String path() {
        return path;
    }

    /**
     * <p>
     * The time interval, in seconds, between health checks.
     * </p>
     * <p>
     * Default: <code>5</code>
     * </p>
     * 
     * @return The time interval, in seconds, between health checks.</p>
     *         <p>
     *         Default: <code>5</code>
     */
    public final Integer interval() {
        return interval;
    }

    /**
     * <p>
     * The time, in seconds, to wait for a health check response before deciding it failed.
     * </p>
     * <p>
     * Default: <code>2</code>
     * </p>
     * 
     * @return The time, in seconds, to wait for a health check response before deciding it failed.</p>
     *         <p>
     *         Default: <code>2</code>
     */
    public final Integer timeout() {
        return timeout;
    }

    /**
     * <p>
     * The number of consecutive checks that must succeed before App Runner decides that the service is healthy.
     * </p>
     * <p>
     * Default: <code>3</code>
     * </p>
     * 
     * @return The number of consecutive checks that must succeed before App Runner decides that the service is
     *         healthy.</p>
     *         <p>
     *         Default: <code>3</code>
     */
    public final Integer healthyThreshold() {
        return healthyThreshold;
    }

    /**
     * <p>
     * The number of consecutive checks that must fail before App Runner decides that the service is unhealthy.
     * </p>
     * <p>
     * Default: <code>3</code>
     * </p>
     * 
     * @return The number of consecutive checks that must fail before App Runner decides that the service is
     *         unhealthy.</p>
     *         <p>
     *         Default: <code>3</code>
     */
    public final Integer unhealthyThreshold() {
        return unhealthyThreshold;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(protocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(path());
        hashCode = 31 * hashCode + Objects.hashCode(interval());
        hashCode = 31 * hashCode + Objects.hashCode(timeout());
        hashCode = 31 * hashCode + Objects.hashCode(healthyThreshold());
        hashCode = 31 * hashCode + Objects.hashCode(unhealthyThreshold());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HealthCheckConfiguration)) {
            return false;
        }
        HealthCheckConfiguration other = (HealthCheckConfiguration) obj;
        return Objects.equals(protocolAsString(), other.protocolAsString()) && Objects.equals(path(), other.path())
                && Objects.equals(interval(), other.interval()) && Objects.equals(timeout(), other.timeout())
                && Objects.equals(healthyThreshold(), other.healthyThreshold())
                && Objects.equals(unhealthyThreshold(), other.unhealthyThreshold());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("HealthCheckConfiguration").add("Protocol", protocolAsString()).add("Path", path())
                .add("Interval", interval()).add("Timeout", timeout()).add("HealthyThreshold", healthyThreshold())
                .add("UnhealthyThreshold", unhealthyThreshold()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Protocol":
            return Optional.ofNullable(clazz.cast(protocolAsString()));
        case "Path":
            return Optional.ofNullable(clazz.cast(path()));
        case "Interval":
            return Optional.ofNullable(clazz.cast(interval()));
        case "Timeout":
            return Optional.ofNullable(clazz.cast(timeout()));
        case "HealthyThreshold":
            return Optional.ofNullable(clazz.cast(healthyThreshold()));
        case "UnhealthyThreshold":
            return Optional.ofNullable(clazz.cast(unhealthyThreshold()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HealthCheckConfiguration, T> g) {
        return obj -> g.apply((HealthCheckConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HealthCheckConfiguration> {
        /**
         * <p>
         * The IP protocol that App Runner uses to perform health checks for your service.
         * </p>
         * <p>
         * If you set <code>Protocol</code> to <code>HTTP</code>, App Runner sends health check requests to the HTTP
         * path specified by <code>Path</code>.
         * </p>
         * <p>
         * Default: <code>TCP</code>
         * </p>
         * 
         * @param protocol
         *        The IP protocol that App Runner uses to perform health checks for your service.</p>
         *        <p>
         *        If you set <code>Protocol</code> to <code>HTTP</code>, App Runner sends health check requests to the
         *        HTTP path specified by <code>Path</code>.
         *        </p>
         *        <p>
         *        Default: <code>TCP</code>
         * @see HealthCheckProtocol
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HealthCheckProtocol
         */
        Builder protocol(String protocol);

        /**
         * <p>
         * The IP protocol that App Runner uses to perform health checks for your service.
         * </p>
         * <p>
         * If you set <code>Protocol</code> to <code>HTTP</code>, App Runner sends health check requests to the HTTP
         * path specified by <code>Path</code>.
         * </p>
         * <p>
         * Default: <code>TCP</code>
         * </p>
         * 
         * @param protocol
         *        The IP protocol that App Runner uses to perform health checks for your service.</p>
         *        <p>
         *        If you set <code>Protocol</code> to <code>HTTP</code>, App Runner sends health check requests to the
         *        HTTP path specified by <code>Path</code>.
         *        </p>
         *        <p>
         *        Default: <code>TCP</code>
         * @see HealthCheckProtocol
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HealthCheckProtocol
         */
        Builder protocol(HealthCheckProtocol protocol);

        /**
         * <p>
         * The URL that health check requests are sent to.
         * </p>
         * <p>
         * <code>Path</code> is only applicable when you set <code>Protocol</code> to <code>HTTP</code>.
         * </p>
         * <p>
         * Default: <code>"/"</code>
         * </p>
         * 
         * @param path
         *        The URL that health check requests are sent to.</p>
         *        <p>
         *        <code>Path</code> is only applicable when you set <code>Protocol</code> to <code>HTTP</code>.
         *        </p>
         *        <p>
         *        Default: <code>"/"</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder path(String path);

        /**
         * <p>
         * The time interval, in seconds, between health checks.
         * </p>
         * <p>
         * Default: <code>5</code>
         * </p>
         * 
         * @param interval
         *        The time interval, in seconds, between health checks.</p>
         *        <p>
         *        Default: <code>5</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder interval(Integer interval);

        /**
         * <p>
         * The time, in seconds, to wait for a health check response before deciding it failed.
         * </p>
         * <p>
         * Default: <code>2</code>
         * </p>
         * 
         * @param timeout
         *        The time, in seconds, to wait for a health check response before deciding it failed.</p>
         *        <p>
         *        Default: <code>2</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeout(Integer timeout);

        /**
         * <p>
         * The number of consecutive checks that must succeed before App Runner decides that the service is healthy.
         * </p>
         * <p>
         * Default: <code>3</code>
         * </p>
         * 
         * @param healthyThreshold
         *        The number of consecutive checks that must succeed before App Runner decides that the service is
         *        healthy.</p>
         *        <p>
         *        Default: <code>3</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder healthyThreshold(Integer healthyThreshold);

        /**
         * <p>
         * The number of consecutive checks that must fail before App Runner decides that the service is unhealthy.
         * </p>
         * <p>
         * Default: <code>3</code>
         * </p>
         * 
         * @param unhealthyThreshold
         *        The number of consecutive checks that must fail before App Runner decides that the service is
         *        unhealthy.</p>
         *        <p>
         *        Default: <code>3</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unhealthyThreshold(Integer unhealthyThreshold);
    }

    static final class BuilderImpl implements Builder {
        private String protocol;

        private String path;

        private Integer interval;

        private Integer timeout;

        private Integer healthyThreshold;

        private Integer unhealthyThreshold;

        private BuilderImpl() {
        }

        private BuilderImpl(HealthCheckConfiguration model) {
            protocol(model.protocol);
            path(model.path);
            interval(model.interval);
            timeout(model.timeout);
            healthyThreshold(model.healthyThreshold);
            unhealthyThreshold(model.unhealthyThreshold);
        }

        public final String getProtocol() {
            return protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder protocol(HealthCheckProtocol protocol) {
            this.protocol(protocol == null ? null : protocol.toString());
            return this;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        public final String getPath() {
            return path;
        }

        @Override
        public final Builder path(String path) {
            this.path = path;
            return this;
        }

        public final void setPath(String path) {
            this.path = path;
        }

        public final Integer getInterval() {
            return interval;
        }

        @Override
        public final Builder interval(Integer interval) {
            this.interval = interval;
            return this;
        }

        public final void setInterval(Integer interval) {
            this.interval = interval;
        }

        public final Integer getTimeout() {
            return timeout;
        }

        @Override
        public final Builder timeout(Integer timeout) {
            this.timeout = timeout;
            return this;
        }

        public final void setTimeout(Integer timeout) {
            this.timeout = timeout;
        }

        public final Integer getHealthyThreshold() {
            return healthyThreshold;
        }

        @Override
        public final Builder healthyThreshold(Integer healthyThreshold) {
            this.healthyThreshold = healthyThreshold;
            return this;
        }

        public final void setHealthyThreshold(Integer healthyThreshold) {
            this.healthyThreshold = healthyThreshold;
        }

        public final Integer getUnhealthyThreshold() {
            return unhealthyThreshold;
        }

        @Override
        public final Builder unhealthyThreshold(Integer unhealthyThreshold) {
            this.unhealthyThreshold = unhealthyThreshold;
            return this;
        }

        public final void setUnhealthyThreshold(Integer unhealthyThreshold) {
            this.unhealthyThreshold = unhealthyThreshold;
        }

        @Override
        public HealthCheckConfiguration build() {
            return new HealthCheckConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
