/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apprunner.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes configuration settings related to outbound network traffic of an App Runner service.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EgressConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<EgressConfiguration.Builder, EgressConfiguration> {
    private static final SdkField<String> EGRESS_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EgressType").getter(getter(EgressConfiguration::egressTypeAsString)).setter(setter(Builder::egressType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EgressType").build()).build();

    private static final SdkField<String> VPC_CONNECTOR_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VpcConnectorArn").getter(getter(EgressConfiguration::vpcConnectorArn))
            .setter(setter(Builder::vpcConnectorArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcConnectorArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EGRESS_TYPE_FIELD,
            VPC_CONNECTOR_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String egressType;

    private final String vpcConnectorArn;

    private EgressConfiguration(BuilderImpl builder) {
        this.egressType = builder.egressType;
        this.vpcConnectorArn = builder.vpcConnectorArn;
    }

    /**
     * <p>
     * The type of egress configuration.
     * </p>
     * <p>
     * Set to <code>DEFAULT</code> for access to resources hosted on public networks.
     * </p>
     * <p>
     * Set to <code>VPC</code> to associate your service to a custom VPC specified by <code>VpcConnectorArn</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #egressType} will
     * return {@link EgressType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #egressTypeAsString}.
     * </p>
     * 
     * @return The type of egress configuration.</p>
     *         <p>
     *         Set to <code>DEFAULT</code> for access to resources hosted on public networks.
     *         </p>
     *         <p>
     *         Set to <code>VPC</code> to associate your service to a custom VPC specified by
     *         <code>VpcConnectorArn</code>.
     * @see EgressType
     */
    public final EgressType egressType() {
        return EgressType.fromValue(egressType);
    }

    /**
     * <p>
     * The type of egress configuration.
     * </p>
     * <p>
     * Set to <code>DEFAULT</code> for access to resources hosted on public networks.
     * </p>
     * <p>
     * Set to <code>VPC</code> to associate your service to a custom VPC specified by <code>VpcConnectorArn</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #egressType} will
     * return {@link EgressType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #egressTypeAsString}.
     * </p>
     * 
     * @return The type of egress configuration.</p>
     *         <p>
     *         Set to <code>DEFAULT</code> for access to resources hosted on public networks.
     *         </p>
     *         <p>
     *         Set to <code>VPC</code> to associate your service to a custom VPC specified by
     *         <code>VpcConnectorArn</code>.
     * @see EgressType
     */
    public final String egressTypeAsString() {
        return egressType;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the App Runner VPC connector that you want to associate with your App Runner
     * service. Only valid when <code>EgressType = VPC</code>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the App Runner VPC connector that you want to associate with your App
     *         Runner service. Only valid when <code>EgressType = VPC</code>.
     */
    public final String vpcConnectorArn() {
        return vpcConnectorArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(egressTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(vpcConnectorArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EgressConfiguration)) {
            return false;
        }
        EgressConfiguration other = (EgressConfiguration) obj;
        return Objects.equals(egressTypeAsString(), other.egressTypeAsString())
                && Objects.equals(vpcConnectorArn(), other.vpcConnectorArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EgressConfiguration").add("EgressType", egressTypeAsString())
                .add("VpcConnectorArn", vpcConnectorArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EgressType":
            return Optional.ofNullable(clazz.cast(egressTypeAsString()));
        case "VpcConnectorArn":
            return Optional.ofNullable(clazz.cast(vpcConnectorArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EgressConfiguration, T> g) {
        return obj -> g.apply((EgressConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EgressConfiguration> {
        /**
         * <p>
         * The type of egress configuration.
         * </p>
         * <p>
         * Set to <code>DEFAULT</code> for access to resources hosted on public networks.
         * </p>
         * <p>
         * Set to <code>VPC</code> to associate your service to a custom VPC specified by <code>VpcConnectorArn</code>.
         * </p>
         * 
         * @param egressType
         *        The type of egress configuration.</p>
         *        <p>
         *        Set to <code>DEFAULT</code> for access to resources hosted on public networks.
         *        </p>
         *        <p>
         *        Set to <code>VPC</code> to associate your service to a custom VPC specified by
         *        <code>VpcConnectorArn</code>.
         * @see EgressType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EgressType
         */
        Builder egressType(String egressType);

        /**
         * <p>
         * The type of egress configuration.
         * </p>
         * <p>
         * Set to <code>DEFAULT</code> for access to resources hosted on public networks.
         * </p>
         * <p>
         * Set to <code>VPC</code> to associate your service to a custom VPC specified by <code>VpcConnectorArn</code>.
         * </p>
         * 
         * @param egressType
         *        The type of egress configuration.</p>
         *        <p>
         *        Set to <code>DEFAULT</code> for access to resources hosted on public networks.
         *        </p>
         *        <p>
         *        Set to <code>VPC</code> to associate your service to a custom VPC specified by
         *        <code>VpcConnectorArn</code>.
         * @see EgressType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EgressType
         */
        Builder egressType(EgressType egressType);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the App Runner VPC connector that you want to associate with your App
         * Runner service. Only valid when <code>EgressType = VPC</code>.
         * </p>
         * 
         * @param vpcConnectorArn
         *        The Amazon Resource Name (ARN) of the App Runner VPC connector that you want to associate with your
         *        App Runner service. Only valid when <code>EgressType = VPC</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcConnectorArn(String vpcConnectorArn);
    }

    static final class BuilderImpl implements Builder {
        private String egressType;

        private String vpcConnectorArn;

        private BuilderImpl() {
        }

        private BuilderImpl(EgressConfiguration model) {
            egressType(model.egressType);
            vpcConnectorArn(model.vpcConnectorArn);
        }

        public final String getEgressType() {
            return egressType;
        }

        public final void setEgressType(String egressType) {
            this.egressType = egressType;
        }

        @Override
        @Transient
        public final Builder egressType(String egressType) {
            this.egressType = egressType;
            return this;
        }

        @Override
        @Transient
        public final Builder egressType(EgressType egressType) {
            this.egressType(egressType == null ? null : egressType.toString());
            return this;
        }

        public final String getVpcConnectorArn() {
            return vpcConnectorArn;
        }

        public final void setVpcConnectorArn(String vpcConnectorArn) {
            this.vpcConnectorArn = vpcConnectorArn;
        }

        @Override
        @Transient
        public final Builder vpcConnectorArn(String vpcConnectorArn) {
            this.vpcConnectorArn = vpcConnectorArn;
            return this;
        }

        @Override
        public EgressConfiguration build() {
            return new EgressConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
