/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apprunner.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides summary information for an App Runner service.
 * </p>
 * <p>
 * This type contains limited information about a service. It doesn't include configuration details. It's returned by
 * the <a href="https://docs.aws.amazon.com/apprunner/latest/api/API_ListServices.html">ListServices</a> action.
 * Complete service information is returned by the <a
 * href="https://docs.aws.amazon.com/apprunner/latest/api/API_CreateService.html">CreateService</a>, <a
 * href="https://docs.aws.amazon.com/apprunner/latest/api/API_DescribeService.html">DescribeService</a>, and <a
 * href="https://docs.aws.amazon.com/apprunner/latest/api/API_DeleteService.html">DeleteService</a> actions using the <a
 * href="https://docs.aws.amazon.com/apprunner/latest/api/API_Service.html">Service</a> type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ServiceSummary implements SdkPojo, Serializable, ToCopyableBuilder<ServiceSummary.Builder, ServiceSummary> {
    private static final SdkField<String> SERVICE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServiceName").getter(getter(ServiceSummary::serviceName)).setter(setter(Builder::serviceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceName").build()).build();

    private static final SdkField<String> SERVICE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServiceId").getter(getter(ServiceSummary::serviceId)).setter(setter(Builder::serviceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceId").build()).build();

    private static final SdkField<String> SERVICE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServiceArn").getter(getter(ServiceSummary::serviceArn)).setter(setter(Builder::serviceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceArn").build()).build();

    private static final SdkField<String> SERVICE_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServiceUrl").getter(getter(ServiceSummary::serviceUrl)).setter(setter(Builder::serviceUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceUrl").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedAt").getter(getter(ServiceSummary::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("UpdatedAt").getter(getter(ServiceSummary::updatedAt)).setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedAt").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(ServiceSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_NAME_FIELD,
            SERVICE_ID_FIELD, SERVICE_ARN_FIELD, SERVICE_URL_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD, STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String serviceName;

    private final String serviceId;

    private final String serviceArn;

    private final String serviceUrl;

    private final Instant createdAt;

    private final Instant updatedAt;

    private final String status;

    private ServiceSummary(BuilderImpl builder) {
        this.serviceName = builder.serviceName;
        this.serviceId = builder.serviceId;
        this.serviceArn = builder.serviceArn;
        this.serviceUrl = builder.serviceUrl;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
        this.status = builder.status;
    }

    /**
     * <p>
     * The customer-provided service name.
     * </p>
     * 
     * @return The customer-provided service name.
     */
    public final String serviceName() {
        return serviceName;
    }

    /**
     * <p>
     * An ID that App Runner generated for this service. It's unique within the Amazon Web Services Region.
     * </p>
     * 
     * @return An ID that App Runner generated for this service. It's unique within the Amazon Web Services Region.
     */
    public final String serviceId() {
        return serviceId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of this service.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of this service.
     */
    public final String serviceArn() {
        return serviceArn;
    }

    /**
     * <p>
     * A subdomain URL that App Runner generated for this service. You can use this URL to access your service web
     * application.
     * </p>
     * 
     * @return A subdomain URL that App Runner generated for this service. You can use this URL to access your service
     *         web application.
     */
    public final String serviceUrl() {
        return serviceUrl;
    }

    /**
     * <p>
     * The time when the App Runner service was created. It's in the Unix time stamp format.
     * </p>
     * 
     * @return The time when the App Runner service was created. It's in the Unix time stamp format.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The time when the App Runner service was last updated. It's in theUnix time stamp format.
     * </p>
     * 
     * @return The time when the App Runner service was last updated. It's in theUnix time stamp format.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    /**
     * <p>
     * The current state of the App Runner service. These particular values mean the following.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CREATE_FAILED</code> – The service failed to create. Read the failure events and logs, change any
     * parameters that need to be fixed, and retry the call to create the service.
     * </p>
     * <p>
     * The failed service isn't usable, and still counts towards your service quota. When you're done analyzing the
     * failure, delete the service.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETE_FAILED</code> – The service failed to delete and can't be successfully recovered. Retry the service
     * deletion call to ensure that all related resources are removed.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ServiceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current state of the App Runner service. These particular values mean the following.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CREATE_FAILED</code> – The service failed to create. Read the failure events and logs, change any
     *         parameters that need to be fixed, and retry the call to create the service.
     *         </p>
     *         <p>
     *         The failed service isn't usable, and still counts towards your service quota. When you're done analyzing
     *         the failure, delete the service.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETE_FAILED</code> – The service failed to delete and can't be successfully recovered. Retry the
     *         service deletion call to ensure that all related resources are removed.
     *         </p>
     *         </li>
     * @see ServiceStatus
     */
    public final ServiceStatus status() {
        return ServiceStatus.fromValue(status);
    }

    /**
     * <p>
     * The current state of the App Runner service. These particular values mean the following.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CREATE_FAILED</code> – The service failed to create. Read the failure events and logs, change any
     * parameters that need to be fixed, and retry the call to create the service.
     * </p>
     * <p>
     * The failed service isn't usable, and still counts towards your service quota. When you're done analyzing the
     * failure, delete the service.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETE_FAILED</code> – The service failed to delete and can't be successfully recovered. Retry the service
     * deletion call to ensure that all related resources are removed.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ServiceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current state of the App Runner service. These particular values mean the following.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CREATE_FAILED</code> – The service failed to create. Read the failure events and logs, change any
     *         parameters that need to be fixed, and retry the call to create the service.
     *         </p>
     *         <p>
     *         The failed service isn't usable, and still counts towards your service quota. When you're done analyzing
     *         the failure, delete the service.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETE_FAILED</code> – The service failed to delete and can't be successfully recovered. Retry the
     *         service deletion call to ensure that all related resources are removed.
     *         </p>
     *         </li>
     * @see ServiceStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(serviceName());
        hashCode = 31 * hashCode + Objects.hashCode(serviceId());
        hashCode = 31 * hashCode + Objects.hashCode(serviceArn());
        hashCode = 31 * hashCode + Objects.hashCode(serviceUrl());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceSummary)) {
            return false;
        }
        ServiceSummary other = (ServiceSummary) obj;
        return Objects.equals(serviceName(), other.serviceName()) && Objects.equals(serviceId(), other.serviceId())
                && Objects.equals(serviceArn(), other.serviceArn()) && Objects.equals(serviceUrl(), other.serviceUrl())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(updatedAt(), other.updatedAt())
                && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ServiceSummary").add("ServiceName", serviceName()).add("ServiceId", serviceId())
                .add("ServiceArn", serviceArn()).add("ServiceUrl", serviceUrl()).add("CreatedAt", createdAt())
                .add("UpdatedAt", updatedAt()).add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ServiceName":
            return Optional.ofNullable(clazz.cast(serviceName()));
        case "ServiceId":
            return Optional.ofNullable(clazz.cast(serviceId()));
        case "ServiceArn":
            return Optional.ofNullable(clazz.cast(serviceArn()));
        case "ServiceUrl":
            return Optional.ofNullable(clazz.cast(serviceUrl()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "UpdatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ServiceSummary, T> g) {
        return obj -> g.apply((ServiceSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ServiceSummary> {
        /**
         * <p>
         * The customer-provided service name.
         * </p>
         * 
         * @param serviceName
         *        The customer-provided service name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceName(String serviceName);

        /**
         * <p>
         * An ID that App Runner generated for this service. It's unique within the Amazon Web Services Region.
         * </p>
         * 
         * @param serviceId
         *        An ID that App Runner generated for this service. It's unique within the Amazon Web Services Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceId(String serviceId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of this service.
         * </p>
         * 
         * @param serviceArn
         *        The Amazon Resource Name (ARN) of this service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceArn(String serviceArn);

        /**
         * <p>
         * A subdomain URL that App Runner generated for this service. You can use this URL to access your service web
         * application.
         * </p>
         * 
         * @param serviceUrl
         *        A subdomain URL that App Runner generated for this service. You can use this URL to access your
         *        service web application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceUrl(String serviceUrl);

        /**
         * <p>
         * The time when the App Runner service was created. It's in the Unix time stamp format.
         * </p>
         * 
         * @param createdAt
         *        The time when the App Runner service was created. It's in the Unix time stamp format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The time when the App Runner service was last updated. It's in theUnix time stamp format.
         * </p>
         * 
         * @param updatedAt
         *        The time when the App Runner service was last updated. It's in theUnix time stamp format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);

        /**
         * <p>
         * The current state of the App Runner service. These particular values mean the following.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CREATE_FAILED</code> – The service failed to create. Read the failure events and logs, change any
         * parameters that need to be fixed, and retry the call to create the service.
         * </p>
         * <p>
         * The failed service isn't usable, and still counts towards your service quota. When you're done analyzing the
         * failure, delete the service.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETE_FAILED</code> – The service failed to delete and can't be successfully recovered. Retry the
         * service deletion call to ensure that all related resources are removed.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The current state of the App Runner service. These particular values mean the following.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CREATE_FAILED</code> – The service failed to create. Read the failure events and logs, change
         *        any parameters that need to be fixed, and retry the call to create the service.
         *        </p>
         *        <p>
         *        The failed service isn't usable, and still counts towards your service quota. When you're done
         *        analyzing the failure, delete the service.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETE_FAILED</code> – The service failed to delete and can't be successfully recovered. Retry
         *        the service deletion call to ensure that all related resources are removed.
         *        </p>
         *        </li>
         * @see ServiceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServiceStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current state of the App Runner service. These particular values mean the following.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CREATE_FAILED</code> – The service failed to create. Read the failure events and logs, change any
         * parameters that need to be fixed, and retry the call to create the service.
         * </p>
         * <p>
         * The failed service isn't usable, and still counts towards your service quota. When you're done analyzing the
         * failure, delete the service.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETE_FAILED</code> – The service failed to delete and can't be successfully recovered. Retry the
         * service deletion call to ensure that all related resources are removed.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The current state of the App Runner service. These particular values mean the following.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CREATE_FAILED</code> – The service failed to create. Read the failure events and logs, change
         *        any parameters that need to be fixed, and retry the call to create the service.
         *        </p>
         *        <p>
         *        The failed service isn't usable, and still counts towards your service quota. When you're done
         *        analyzing the failure, delete the service.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETE_FAILED</code> – The service failed to delete and can't be successfully recovered. Retry
         *        the service deletion call to ensure that all related resources are removed.
         *        </p>
         *        </li>
         * @see ServiceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServiceStatus
         */
        Builder status(ServiceStatus status);
    }

    static final class BuilderImpl implements Builder {
        private String serviceName;

        private String serviceId;

        private String serviceArn;

        private String serviceUrl;

        private Instant createdAt;

        private Instant updatedAt;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceSummary model) {
            serviceName(model.serviceName);
            serviceId(model.serviceId);
            serviceArn(model.serviceArn);
            serviceUrl(model.serviceUrl);
            createdAt(model.createdAt);
            updatedAt(model.updatedAt);
            status(model.status);
        }

        public final String getServiceName() {
            return serviceName;
        }

        public final void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        @Override
        @Transient
        public final Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public final String getServiceId() {
            return serviceId;
        }

        public final void setServiceId(String serviceId) {
            this.serviceId = serviceId;
        }

        @Override
        @Transient
        public final Builder serviceId(String serviceId) {
            this.serviceId = serviceId;
            return this;
        }

        public final String getServiceArn() {
            return serviceArn;
        }

        public final void setServiceArn(String serviceArn) {
            this.serviceArn = serviceArn;
        }

        @Override
        @Transient
        public final Builder serviceArn(String serviceArn) {
            this.serviceArn = serviceArn;
            return this;
        }

        public final String getServiceUrl() {
            return serviceUrl;
        }

        public final void setServiceUrl(String serviceUrl) {
            this.serviceUrl = serviceUrl;
        }

        @Override
        @Transient
        public final Builder serviceUrl(String serviceUrl) {
            this.serviceUrl = serviceUrl;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        @Transient
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        @Transient
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        @Transient
        public final Builder status(ServiceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public ServiceSummary build() {
            return new ServiceSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
