/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apprunner.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateVpcConnectorRequest extends AppRunnerRequest implements
        ToCopyableBuilder<CreateVpcConnectorRequest.Builder, CreateVpcConnectorRequest> {
    private static final SdkField<String> VPC_CONNECTOR_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VpcConnectorName").getter(getter(CreateVpcConnectorRequest::vpcConnectorName))
            .setter(setter(Builder::vpcConnectorName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcConnectorName").build()).build();

    private static final SdkField<List<String>> SUBNETS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Subnets")
            .getter(getter(CreateVpcConnectorRequest::subnets))
            .setter(setter(Builder::subnets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subnets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> SECURITY_GROUPS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SecurityGroups")
            .getter(getter(CreateVpcConnectorRequest::securityGroups))
            .setter(setter(Builder::securityGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateVpcConnectorRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VPC_CONNECTOR_NAME_FIELD,
            SUBNETS_FIELD, SECURITY_GROUPS_FIELD, TAGS_FIELD));

    private final String vpcConnectorName;

    private final List<String> subnets;

    private final List<String> securityGroups;

    private final List<Tag> tags;

    private CreateVpcConnectorRequest(BuilderImpl builder) {
        super(builder);
        this.vpcConnectorName = builder.vpcConnectorName;
        this.subnets = builder.subnets;
        this.securityGroups = builder.securityGroups;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * A name for the VPC connector.
     * </p>
     * 
     * @return A name for the VPC connector.
     */
    public final String vpcConnectorName() {
        return vpcConnectorName;
    }

    /**
     * For responses, this returns true if the service returned a value for the Subnets property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSubnets() {
        return subnets != null && !(subnets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of IDs of subnets that App Runner should use when it associates your service with a custom Amazon VPC.
     * Specify IDs of subnets of a single Amazon VPC. App Runner determines the Amazon VPC from the subnets you specify.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSubnets} method.
     * </p>
     * 
     * @return A list of IDs of subnets that App Runner should use when it associates your service with a custom Amazon
     *         VPC. Specify IDs of subnets of a single Amazon VPC. App Runner determines the Amazon VPC from the subnets
     *         you specify.
     */
    public final List<String> subnets() {
        return subnets;
    }

    /**
     * For responses, this returns true if the service returned a value for the SecurityGroups property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSecurityGroups() {
        return securityGroups != null && !(securityGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of IDs of security groups that App Runner should use for access to Amazon Web Services resources under the
     * specified subnets. If not specified, App Runner uses the default security group of the Amazon VPC. The default
     * security group allows all outbound traffic.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSecurityGroups} method.
     * </p>
     * 
     * @return A list of IDs of security groups that App Runner should use for access to Amazon Web Services resources
     *         under the specified subnets. If not specified, App Runner uses the default security group of the Amazon
     *         VPC. The default security group allows all outbound traffic.
     */
    public final List<String> securityGroups() {
        return securityGroups;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of metadata items that you can associate with your VPC connector resource. A tag is a key-value pair.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A list of metadata items that you can associate with your VPC connector resource. A tag is a key-value
     *         pair.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(vpcConnectorName());
        hashCode = 31 * hashCode + Objects.hashCode(hasSubnets() ? subnets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSecurityGroups() ? securityGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateVpcConnectorRequest)) {
            return false;
        }
        CreateVpcConnectorRequest other = (CreateVpcConnectorRequest) obj;
        return Objects.equals(vpcConnectorName(), other.vpcConnectorName()) && hasSubnets() == other.hasSubnets()
                && Objects.equals(subnets(), other.subnets()) && hasSecurityGroups() == other.hasSecurityGroups()
                && Objects.equals(securityGroups(), other.securityGroups()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateVpcConnectorRequest").add("VpcConnectorName", vpcConnectorName())
                .add("Subnets", hasSubnets() ? subnets() : null)
                .add("SecurityGroups", hasSecurityGroups() ? securityGroups() : null).add("Tags", hasTags() ? tags() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VpcConnectorName":
            return Optional.ofNullable(clazz.cast(vpcConnectorName()));
        case "Subnets":
            return Optional.ofNullable(clazz.cast(subnets()));
        case "SecurityGroups":
            return Optional.ofNullable(clazz.cast(securityGroups()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateVpcConnectorRequest, T> g) {
        return obj -> g.apply((CreateVpcConnectorRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppRunnerRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateVpcConnectorRequest> {
        /**
         * <p>
         * A name for the VPC connector.
         * </p>
         * 
         * @param vpcConnectorName
         *        A name for the VPC connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcConnectorName(String vpcConnectorName);

        /**
         * <p>
         * A list of IDs of subnets that App Runner should use when it associates your service with a custom Amazon VPC.
         * Specify IDs of subnets of a single Amazon VPC. App Runner determines the Amazon VPC from the subnets you
         * specify.
         * </p>
         * 
         * @param subnets
         *        A list of IDs of subnets that App Runner should use when it associates your service with a custom
         *        Amazon VPC. Specify IDs of subnets of a single Amazon VPC. App Runner determines the Amazon VPC from
         *        the subnets you specify.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnets(Collection<String> subnets);

        /**
         * <p>
         * A list of IDs of subnets that App Runner should use when it associates your service with a custom Amazon VPC.
         * Specify IDs of subnets of a single Amazon VPC. App Runner determines the Amazon VPC from the subnets you
         * specify.
         * </p>
         * 
         * @param subnets
         *        A list of IDs of subnets that App Runner should use when it associates your service with a custom
         *        Amazon VPC. Specify IDs of subnets of a single Amazon VPC. App Runner determines the Amazon VPC from
         *        the subnets you specify.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnets(String... subnets);

        /**
         * <p>
         * A list of IDs of security groups that App Runner should use for access to Amazon Web Services resources under
         * the specified subnets. If not specified, App Runner uses the default security group of the Amazon VPC. The
         * default security group allows all outbound traffic.
         * </p>
         * 
         * @param securityGroups
         *        A list of IDs of security groups that App Runner should use for access to Amazon Web Services
         *        resources under the specified subnets. If not specified, App Runner uses the default security group of
         *        the Amazon VPC. The default security group allows all outbound traffic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroups(Collection<String> securityGroups);

        /**
         * <p>
         * A list of IDs of security groups that App Runner should use for access to Amazon Web Services resources under
         * the specified subnets. If not specified, App Runner uses the default security group of the Amazon VPC. The
         * default security group allows all outbound traffic.
         * </p>
         * 
         * @param securityGroups
         *        A list of IDs of security groups that App Runner should use for access to Amazon Web Services
         *        resources under the specified subnets. If not specified, App Runner uses the default security group of
         *        the Amazon VPC. The default security group allows all outbound traffic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroups(String... securityGroups);

        /**
         * <p>
         * A list of metadata items that you can associate with your VPC connector resource. A tag is a key-value pair.
         * </p>
         * 
         * @param tags
         *        A list of metadata items that you can associate with your VPC connector resource. A tag is a key-value
         *        pair.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * A list of metadata items that you can associate with your VPC connector resource. A tag is a key-value pair.
         * </p>
         * 
         * @param tags
         *        A list of metadata items that you can associate with your VPC connector resource. A tag is a key-value
         *        pair.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * A list of metadata items that you can associate with your VPC connector resource. A tag is a key-value pair.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<Tag>.Builder} avoiding the need to
         * create one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AppRunnerRequest.BuilderImpl implements Builder {
        private String vpcConnectorName;

        private List<String> subnets = DefaultSdkAutoConstructList.getInstance();

        private List<String> securityGroups = DefaultSdkAutoConstructList.getInstance();

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateVpcConnectorRequest model) {
            super(model);
            vpcConnectorName(model.vpcConnectorName);
            subnets(model.subnets);
            securityGroups(model.securityGroups);
            tags(model.tags);
        }

        public final String getVpcConnectorName() {
            return vpcConnectorName;
        }

        public final void setVpcConnectorName(String vpcConnectorName) {
            this.vpcConnectorName = vpcConnectorName;
        }

        @Override
        public final Builder vpcConnectorName(String vpcConnectorName) {
            this.vpcConnectorName = vpcConnectorName;
            return this;
        }

        public final Collection<String> getSubnets() {
            if (subnets instanceof SdkAutoConstructList) {
                return null;
            }
            return subnets;
        }

        public final void setSubnets(Collection<String> subnets) {
            this.subnets = StringListCopier.copy(subnets);
        }

        @Override
        public final Builder subnets(Collection<String> subnets) {
            this.subnets = StringListCopier.copy(subnets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnets(String... subnets) {
            subnets(Arrays.asList(subnets));
            return this;
        }

        public final Collection<String> getSecurityGroups() {
            if (securityGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return securityGroups;
        }

        public final void setSecurityGroups(Collection<String> securityGroups) {
            this.securityGroups = StringListCopier.copy(securityGroups);
        }

        @Override
        public final Builder securityGroups(Collection<String> securityGroups) {
            this.securityGroups = StringListCopier.copy(securityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(String... securityGroups) {
            securityGroups(Arrays.asList(securityGroups));
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateVpcConnectorRequest build() {
            return new CreateVpcConnectorRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
