/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apprunner.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes configuration settings related to network traffic of an App Runner service. Consists of embedded objects
 * for each configurable network feature.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NetworkConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<NetworkConfiguration.Builder, NetworkConfiguration> {
    private static final SdkField<EgressConfiguration> EGRESS_CONFIGURATION_FIELD = SdkField
            .<EgressConfiguration> builder(MarshallingType.SDK_POJO).memberName("EgressConfiguration")
            .getter(getter(NetworkConfiguration::egressConfiguration)).setter(setter(Builder::egressConfiguration))
            .constructor(EgressConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EgressConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EGRESS_CONFIGURATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final EgressConfiguration egressConfiguration;

    private NetworkConfiguration(BuilderImpl builder) {
        this.egressConfiguration = builder.egressConfiguration;
    }

    /**
     * <p>
     * Network configuration settings for outbound message traffic.
     * </p>
     * 
     * @return Network configuration settings for outbound message traffic.
     */
    public final EgressConfiguration egressConfiguration() {
        return egressConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(egressConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkConfiguration)) {
            return false;
        }
        NetworkConfiguration other = (NetworkConfiguration) obj;
        return Objects.equals(egressConfiguration(), other.egressConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NetworkConfiguration").add("EgressConfiguration", egressConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EgressConfiguration":
            return Optional.ofNullable(clazz.cast(egressConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NetworkConfiguration, T> g) {
        return obj -> g.apply((NetworkConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NetworkConfiguration> {
        /**
         * <p>
         * Network configuration settings for outbound message traffic.
         * </p>
         * 
         * @param egressConfiguration
         *        Network configuration settings for outbound message traffic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder egressConfiguration(EgressConfiguration egressConfiguration);

        /**
         * <p>
         * Network configuration settings for outbound message traffic.
         * </p>
         * This is a convenience method that creates an instance of the {@link EgressConfiguration.Builder} avoiding the
         * need to create one manually via {@link EgressConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link EgressConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #egressConfiguration(EgressConfiguration)}.
         * 
         * @param egressConfiguration
         *        a consumer that will call methods on {@link EgressConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #egressConfiguration(EgressConfiguration)
         */
        default Builder egressConfiguration(Consumer<EgressConfiguration.Builder> egressConfiguration) {
            return egressConfiguration(EgressConfiguration.builder().applyMutation(egressConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private EgressConfiguration egressConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkConfiguration model) {
            egressConfiguration(model.egressConfiguration);
        }

        public final EgressConfiguration.Builder getEgressConfiguration() {
            return egressConfiguration != null ? egressConfiguration.toBuilder() : null;
        }

        public final void setEgressConfiguration(EgressConfiguration.BuilderImpl egressConfiguration) {
            this.egressConfiguration = egressConfiguration != null ? egressConfiguration.build() : null;
        }

        @Override
        public final Builder egressConfiguration(EgressConfiguration egressConfiguration) {
            this.egressConfiguration = egressConfiguration;
            return this;
        }

        @Override
        public NetworkConfiguration build() {
            return new NetworkConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
