/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apprunner.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an App Runner observability configuration resource. Multiple revisions of a configuration have the same
 * <code>ObservabilityConfigurationName</code> and different <code>ObservabilityConfigurationRevision</code> values.
 * </p>
 * <p>
 * The resource is designed to configure multiple features (currently one feature, tracing). This type contains optional
 * members that describe the configuration of these features (currently one member, <code>TraceConfiguration</code>). If
 * a feature member isn't specified, the feature isn't enabled.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ObservabilityConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ObservabilityConfiguration.Builder, ObservabilityConfiguration> {
    private static final SdkField<String> OBSERVABILITY_CONFIGURATION_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ObservabilityConfigurationArn")
            .getter(getter(ObservabilityConfiguration::observabilityConfigurationArn))
            .setter(setter(Builder::observabilityConfigurationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObservabilityConfigurationArn")
                    .build()).build();

    private static final SdkField<String> OBSERVABILITY_CONFIGURATION_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ObservabilityConfigurationName")
            .getter(getter(ObservabilityConfiguration::observabilityConfigurationName))
            .setter(setter(Builder::observabilityConfigurationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObservabilityConfigurationName")
                    .build()).build();

    private static final SdkField<TraceConfiguration> TRACE_CONFIGURATION_FIELD = SdkField
            .<TraceConfiguration> builder(MarshallingType.SDK_POJO).memberName("TraceConfiguration")
            .getter(getter(ObservabilityConfiguration::traceConfiguration)).setter(setter(Builder::traceConfiguration))
            .constructor(TraceConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TraceConfiguration").build())
            .build();

    private static final SdkField<Integer> OBSERVABILITY_CONFIGURATION_REVISION_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("ObservabilityConfigurationRevision")
            .getter(getter(ObservabilityConfiguration::observabilityConfigurationRevision))
            .setter(setter(Builder::observabilityConfigurationRevision))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObservabilityConfigurationRevision")
                    .build()).build();

    private static final SdkField<Boolean> LATEST_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Latest").getter(getter(ObservabilityConfiguration::latest)).setter(setter(Builder::latest))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Latest").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(ObservabilityConfiguration::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedAt").getter(getter(ObservabilityConfiguration::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()).build();

    private static final SdkField<Instant> DELETED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("DeletedAt").getter(getter(ObservabilityConfiguration::deletedAt)).setter(setter(Builder::deletedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeletedAt").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            OBSERVABILITY_CONFIGURATION_ARN_FIELD, OBSERVABILITY_CONFIGURATION_NAME_FIELD, TRACE_CONFIGURATION_FIELD,
            OBSERVABILITY_CONFIGURATION_REVISION_FIELD, LATEST_FIELD, STATUS_FIELD, CREATED_AT_FIELD, DELETED_AT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String observabilityConfigurationArn;

    private final String observabilityConfigurationName;

    private final TraceConfiguration traceConfiguration;

    private final Integer observabilityConfigurationRevision;

    private final Boolean latest;

    private final String status;

    private final Instant createdAt;

    private final Instant deletedAt;

    private ObservabilityConfiguration(BuilderImpl builder) {
        this.observabilityConfigurationArn = builder.observabilityConfigurationArn;
        this.observabilityConfigurationName = builder.observabilityConfigurationName;
        this.traceConfiguration = builder.traceConfiguration;
        this.observabilityConfigurationRevision = builder.observabilityConfigurationRevision;
        this.latest = builder.latest;
        this.status = builder.status;
        this.createdAt = builder.createdAt;
        this.deletedAt = builder.deletedAt;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of this observability configuration.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of this observability configuration.
     */
    public final String observabilityConfigurationArn() {
        return observabilityConfigurationArn;
    }

    /**
     * <p>
     * The customer-provided observability configuration name. It can be used in multiple revisions of a configuration.
     * </p>
     * 
     * @return The customer-provided observability configuration name. It can be used in multiple revisions of a
     *         configuration.
     */
    public final String observabilityConfigurationName() {
        return observabilityConfigurationName;
    }

    /**
     * <p>
     * The configuration of the tracing feature within this observability configuration. If not specified, tracing isn't
     * enabled.
     * </p>
     * 
     * @return The configuration of the tracing feature within this observability configuration. If not specified,
     *         tracing isn't enabled.
     */
    public final TraceConfiguration traceConfiguration() {
        return traceConfiguration;
    }

    /**
     * <p>
     * The revision of this observability configuration. It's unique among all the active configurations (
     * <code>"Status": "ACTIVE"</code>) that share the same <code>ObservabilityConfigurationName</code>.
     * </p>
     * 
     * @return The revision of this observability configuration. It's unique among all the active configurations (
     *         <code>"Status": "ACTIVE"</code>) that share the same <code>ObservabilityConfigurationName</code>.
     */
    public final Integer observabilityConfigurationRevision() {
        return observabilityConfigurationRevision;
    }

    /**
     * <p>
     * It's set to <code>true</code> for the configuration with the highest <code>Revision</code> among all
     * configurations that share the same <code>ObservabilityConfigurationName</code>. It's set to <code>false</code>
     * otherwise.
     * </p>
     * 
     * @return It's set to <code>true</code> for the configuration with the highest <code>Revision</code> among all
     *         configurations that share the same <code>ObservabilityConfigurationName</code>. It's set to
     *         <code>false</code> otherwise.
     */
    public final Boolean latest() {
        return latest;
    }

    /**
     * <p>
     * The current state of the observability configuration. If the status of a configuration revision is
     * <code>INACTIVE</code>, it was deleted and can't be used. Inactive configuration revisions are permanently removed
     * some time after they are deleted.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ObservabilityConfigurationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The current state of the observability configuration. If the status of a configuration revision is
     *         <code>INACTIVE</code>, it was deleted and can't be used. Inactive configuration revisions are permanently
     *         removed some time after they are deleted.
     * @see ObservabilityConfigurationStatus
     */
    public final ObservabilityConfigurationStatus status() {
        return ObservabilityConfigurationStatus.fromValue(status);
    }

    /**
     * <p>
     * The current state of the observability configuration. If the status of a configuration revision is
     * <code>INACTIVE</code>, it was deleted and can't be used. Inactive configuration revisions are permanently removed
     * some time after they are deleted.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ObservabilityConfigurationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The current state of the observability configuration. If the status of a configuration revision is
     *         <code>INACTIVE</code>, it was deleted and can't be used. Inactive configuration revisions are permanently
     *         removed some time after they are deleted.
     * @see ObservabilityConfigurationStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The time when the observability configuration was created. It's in Unix time stamp format.
     * </p>
     * 
     * @return The time when the observability configuration was created. It's in Unix time stamp format.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The time when the observability configuration was deleted. It's in Unix time stamp format.
     * </p>
     * 
     * @return The time when the observability configuration was deleted. It's in Unix time stamp format.
     */
    public final Instant deletedAt() {
        return deletedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(observabilityConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(observabilityConfigurationName());
        hashCode = 31 * hashCode + Objects.hashCode(traceConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(observabilityConfigurationRevision());
        hashCode = 31 * hashCode + Objects.hashCode(latest());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(deletedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ObservabilityConfiguration)) {
            return false;
        }
        ObservabilityConfiguration other = (ObservabilityConfiguration) obj;
        return Objects.equals(observabilityConfigurationArn(), other.observabilityConfigurationArn())
                && Objects.equals(observabilityConfigurationName(), other.observabilityConfigurationName())
                && Objects.equals(traceConfiguration(), other.traceConfiguration())
                && Objects.equals(observabilityConfigurationRevision(), other.observabilityConfigurationRevision())
                && Objects.equals(latest(), other.latest()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(deletedAt(), other.deletedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ObservabilityConfiguration")
                .add("ObservabilityConfigurationArn", observabilityConfigurationArn())
                .add("ObservabilityConfigurationName", observabilityConfigurationName())
                .add("TraceConfiguration", traceConfiguration())
                .add("ObservabilityConfigurationRevision", observabilityConfigurationRevision()).add("Latest", latest())
                .add("Status", statusAsString()).add("CreatedAt", createdAt()).add("DeletedAt", deletedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ObservabilityConfigurationArn":
            return Optional.ofNullable(clazz.cast(observabilityConfigurationArn()));
        case "ObservabilityConfigurationName":
            return Optional.ofNullable(clazz.cast(observabilityConfigurationName()));
        case "TraceConfiguration":
            return Optional.ofNullable(clazz.cast(traceConfiguration()));
        case "ObservabilityConfigurationRevision":
            return Optional.ofNullable(clazz.cast(observabilityConfigurationRevision()));
        case "Latest":
            return Optional.ofNullable(clazz.cast(latest()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "DeletedAt":
            return Optional.ofNullable(clazz.cast(deletedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ObservabilityConfiguration, T> g) {
        return obj -> g.apply((ObservabilityConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ObservabilityConfiguration> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of this observability configuration.
         * </p>
         * 
         * @param observabilityConfigurationArn
         *        The Amazon Resource Name (ARN) of this observability configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder observabilityConfigurationArn(String observabilityConfigurationArn);

        /**
         * <p>
         * The customer-provided observability configuration name. It can be used in multiple revisions of a
         * configuration.
         * </p>
         * 
         * @param observabilityConfigurationName
         *        The customer-provided observability configuration name. It can be used in multiple revisions of a
         *        configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder observabilityConfigurationName(String observabilityConfigurationName);

        /**
         * <p>
         * The configuration of the tracing feature within this observability configuration. If not specified, tracing
         * isn't enabled.
         * </p>
         * 
         * @param traceConfiguration
         *        The configuration of the tracing feature within this observability configuration. If not specified,
         *        tracing isn't enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder traceConfiguration(TraceConfiguration traceConfiguration);

        /**
         * <p>
         * The configuration of the tracing feature within this observability configuration. If not specified, tracing
         * isn't enabled.
         * </p>
         * This is a convenience method that creates an instance of the {@link TraceConfiguration.Builder} avoiding the
         * need to create one manually via {@link TraceConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link TraceConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #traceConfiguration(TraceConfiguration)}.
         * 
         * @param traceConfiguration
         *        a consumer that will call methods on {@link TraceConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #traceConfiguration(TraceConfiguration)
         */
        default Builder traceConfiguration(Consumer<TraceConfiguration.Builder> traceConfiguration) {
            return traceConfiguration(TraceConfiguration.builder().applyMutation(traceConfiguration).build());
        }

        /**
         * <p>
         * The revision of this observability configuration. It's unique among all the active configurations (
         * <code>"Status": "ACTIVE"</code>) that share the same <code>ObservabilityConfigurationName</code>.
         * </p>
         * 
         * @param observabilityConfigurationRevision
         *        The revision of this observability configuration. It's unique among all the active configurations (
         *        <code>"Status": "ACTIVE"</code>) that share the same <code>ObservabilityConfigurationName</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder observabilityConfigurationRevision(Integer observabilityConfigurationRevision);

        /**
         * <p>
         * It's set to <code>true</code> for the configuration with the highest <code>Revision</code> among all
         * configurations that share the same <code>ObservabilityConfigurationName</code>. It's set to
         * <code>false</code> otherwise.
         * </p>
         * 
         * @param latest
         *        It's set to <code>true</code> for the configuration with the highest <code>Revision</code> among all
         *        configurations that share the same <code>ObservabilityConfigurationName</code>. It's set to
         *        <code>false</code> otherwise.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latest(Boolean latest);

        /**
         * <p>
         * The current state of the observability configuration. If the status of a configuration revision is
         * <code>INACTIVE</code>, it was deleted and can't be used. Inactive configuration revisions are permanently
         * removed some time after they are deleted.
         * </p>
         * 
         * @param status
         *        The current state of the observability configuration. If the status of a configuration revision is
         *        <code>INACTIVE</code>, it was deleted and can't be used. Inactive configuration revisions are
         *        permanently removed some time after they are deleted.
         * @see ObservabilityConfigurationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ObservabilityConfigurationStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current state of the observability configuration. If the status of a configuration revision is
         * <code>INACTIVE</code>, it was deleted and can't be used. Inactive configuration revisions are permanently
         * removed some time after they are deleted.
         * </p>
         * 
         * @param status
         *        The current state of the observability configuration. If the status of a configuration revision is
         *        <code>INACTIVE</code>, it was deleted and can't be used. Inactive configuration revisions are
         *        permanently removed some time after they are deleted.
         * @see ObservabilityConfigurationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ObservabilityConfigurationStatus
         */
        Builder status(ObservabilityConfigurationStatus status);

        /**
         * <p>
         * The time when the observability configuration was created. It's in Unix time stamp format.
         * </p>
         * 
         * @param createdAt
         *        The time when the observability configuration was created. It's in Unix time stamp format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The time when the observability configuration was deleted. It's in Unix time stamp format.
         * </p>
         * 
         * @param deletedAt
         *        The time when the observability configuration was deleted. It's in Unix time stamp format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deletedAt(Instant deletedAt);
    }

    static final class BuilderImpl implements Builder {
        private String observabilityConfigurationArn;

        private String observabilityConfigurationName;

        private TraceConfiguration traceConfiguration;

        private Integer observabilityConfigurationRevision;

        private Boolean latest;

        private String status;

        private Instant createdAt;

        private Instant deletedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(ObservabilityConfiguration model) {
            observabilityConfigurationArn(model.observabilityConfigurationArn);
            observabilityConfigurationName(model.observabilityConfigurationName);
            traceConfiguration(model.traceConfiguration);
            observabilityConfigurationRevision(model.observabilityConfigurationRevision);
            latest(model.latest);
            status(model.status);
            createdAt(model.createdAt);
            deletedAt(model.deletedAt);
        }

        public final String getObservabilityConfigurationArn() {
            return observabilityConfigurationArn;
        }

        public final void setObservabilityConfigurationArn(String observabilityConfigurationArn) {
            this.observabilityConfigurationArn = observabilityConfigurationArn;
        }

        @Override
        public final Builder observabilityConfigurationArn(String observabilityConfigurationArn) {
            this.observabilityConfigurationArn = observabilityConfigurationArn;
            return this;
        }

        public final String getObservabilityConfigurationName() {
            return observabilityConfigurationName;
        }

        public final void setObservabilityConfigurationName(String observabilityConfigurationName) {
            this.observabilityConfigurationName = observabilityConfigurationName;
        }

        @Override
        public final Builder observabilityConfigurationName(String observabilityConfigurationName) {
            this.observabilityConfigurationName = observabilityConfigurationName;
            return this;
        }

        public final TraceConfiguration.Builder getTraceConfiguration() {
            return traceConfiguration != null ? traceConfiguration.toBuilder() : null;
        }

        public final void setTraceConfiguration(TraceConfiguration.BuilderImpl traceConfiguration) {
            this.traceConfiguration = traceConfiguration != null ? traceConfiguration.build() : null;
        }

        @Override
        public final Builder traceConfiguration(TraceConfiguration traceConfiguration) {
            this.traceConfiguration = traceConfiguration;
            return this;
        }

        public final Integer getObservabilityConfigurationRevision() {
            return observabilityConfigurationRevision;
        }

        public final void setObservabilityConfigurationRevision(Integer observabilityConfigurationRevision) {
            this.observabilityConfigurationRevision = observabilityConfigurationRevision;
        }

        @Override
        public final Builder observabilityConfigurationRevision(Integer observabilityConfigurationRevision) {
            this.observabilityConfigurationRevision = observabilityConfigurationRevision;
            return this;
        }

        public final Boolean getLatest() {
            return latest;
        }

        public final void setLatest(Boolean latest) {
            this.latest = latest;
        }

        @Override
        public final Builder latest(Boolean latest) {
            this.latest = latest;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ObservabilityConfigurationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getDeletedAt() {
            return deletedAt;
        }

        public final void setDeletedAt(Instant deletedAt) {
            this.deletedAt = deletedAt;
        }

        @Override
        public final Builder deletedAt(Instant deletedAt) {
            this.deletedAt = deletedAt;
            return this;
        }

        @Override
        public ObservabilityConfiguration build() {
            return new ObservabilityConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
