/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apprunner.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the source deployed to an App Runner service. It can be a code or an image repository.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SourceConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<SourceConfiguration.Builder, SourceConfiguration> {
    private static final SdkField<CodeRepository> CODE_REPOSITORY_FIELD = SdkField
            .<CodeRepository> builder(MarshallingType.SDK_POJO).memberName("CodeRepository")
            .getter(getter(SourceConfiguration::codeRepository)).setter(setter(Builder::codeRepository))
            .constructor(CodeRepository::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CodeRepository").build()).build();

    private static final SdkField<ImageRepository> IMAGE_REPOSITORY_FIELD = SdkField
            .<ImageRepository> builder(MarshallingType.SDK_POJO).memberName("ImageRepository")
            .getter(getter(SourceConfiguration::imageRepository)).setter(setter(Builder::imageRepository))
            .constructor(ImageRepository::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageRepository").build()).build();

    private static final SdkField<Boolean> AUTO_DEPLOYMENTS_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AutoDeploymentsEnabled").getter(getter(SourceConfiguration::autoDeploymentsEnabled))
            .setter(setter(Builder::autoDeploymentsEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoDeploymentsEnabled").build())
            .build();

    private static final SdkField<AuthenticationConfiguration> AUTHENTICATION_CONFIGURATION_FIELD = SdkField
            .<AuthenticationConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("AuthenticationConfiguration")
            .getter(getter(SourceConfiguration::authenticationConfiguration))
            .setter(setter(Builder::authenticationConfiguration))
            .constructor(AuthenticationConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthenticationConfiguration")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CODE_REPOSITORY_FIELD,
            IMAGE_REPOSITORY_FIELD, AUTO_DEPLOYMENTS_ENABLED_FIELD, AUTHENTICATION_CONFIGURATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final CodeRepository codeRepository;

    private final ImageRepository imageRepository;

    private final Boolean autoDeploymentsEnabled;

    private final AuthenticationConfiguration authenticationConfiguration;

    private SourceConfiguration(BuilderImpl builder) {
        this.codeRepository = builder.codeRepository;
        this.imageRepository = builder.imageRepository;
        this.autoDeploymentsEnabled = builder.autoDeploymentsEnabled;
        this.authenticationConfiguration = builder.authenticationConfiguration;
    }

    /**
     * <p>
     * The description of a source code repository.
     * </p>
     * <p>
     * You must provide either this member or <code>ImageRepository</code> (but not both).
     * </p>
     * 
     * @return The description of a source code repository.</p>
     *         <p>
     *         You must provide either this member or <code>ImageRepository</code> (but not both).
     */
    public final CodeRepository codeRepository() {
        return codeRepository;
    }

    /**
     * <p>
     * The description of a source image repository.
     * </p>
     * <p>
     * You must provide either this member or <code>CodeRepository</code> (but not both).
     * </p>
     * 
     * @return The description of a source image repository.</p>
     *         <p>
     *         You must provide either this member or <code>CodeRepository</code> (but not both).
     */
    public final ImageRepository imageRepository() {
        return imageRepository;
    }

    /**
     * <p>
     * If <code>true</code>, continuous integration from the source repository is enabled for the App Runner service.
     * Each repository change (including any source code commit or new image version) starts a deployment.
     * </p>
     * <p>
     * Default: App Runner sets to <code>false</code> for a source image that uses an ECR Public repository or an ECR
     * repository that's in an Amazon Web Services account other than the one that the service is in. App Runner sets to
     * <code>true</code> in all other cases (which currently include a source code repository or a source image using a
     * same-account ECR repository).
     * </p>
     * 
     * @return If <code>true</code>, continuous integration from the source repository is enabled for the App Runner
     *         service. Each repository change (including any source code commit or new image version) starts a
     *         deployment.</p>
     *         <p>
     *         Default: App Runner sets to <code>false</code> for a source image that uses an ECR Public repository or
     *         an ECR repository that's in an Amazon Web Services account other than the one that the service is in. App
     *         Runner sets to <code>true</code> in all other cases (which currently include a source code repository or
     *         a source image using a same-account ECR repository).
     */
    public final Boolean autoDeploymentsEnabled() {
        return autoDeploymentsEnabled;
    }

    /**
     * <p>
     * Describes the resources that are needed to authenticate access to some source repositories.
     * </p>
     * 
     * @return Describes the resources that are needed to authenticate access to some source repositories.
     */
    public final AuthenticationConfiguration authenticationConfiguration() {
        return authenticationConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(codeRepository());
        hashCode = 31 * hashCode + Objects.hashCode(imageRepository());
        hashCode = 31 * hashCode + Objects.hashCode(autoDeploymentsEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(authenticationConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SourceConfiguration)) {
            return false;
        }
        SourceConfiguration other = (SourceConfiguration) obj;
        return Objects.equals(codeRepository(), other.codeRepository())
                && Objects.equals(imageRepository(), other.imageRepository())
                && Objects.equals(autoDeploymentsEnabled(), other.autoDeploymentsEnabled())
                && Objects.equals(authenticationConfiguration(), other.authenticationConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SourceConfiguration").add("CodeRepository", codeRepository())
                .add("ImageRepository", imageRepository()).add("AutoDeploymentsEnabled", autoDeploymentsEnabled())
                .add("AuthenticationConfiguration", authenticationConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CodeRepository":
            return Optional.ofNullable(clazz.cast(codeRepository()));
        case "ImageRepository":
            return Optional.ofNullable(clazz.cast(imageRepository()));
        case "AutoDeploymentsEnabled":
            return Optional.ofNullable(clazz.cast(autoDeploymentsEnabled()));
        case "AuthenticationConfiguration":
            return Optional.ofNullable(clazz.cast(authenticationConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SourceConfiguration, T> g) {
        return obj -> g.apply((SourceConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SourceConfiguration> {
        /**
         * <p>
         * The description of a source code repository.
         * </p>
         * <p>
         * You must provide either this member or <code>ImageRepository</code> (but not both).
         * </p>
         * 
         * @param codeRepository
         *        The description of a source code repository.</p>
         *        <p>
         *        You must provide either this member or <code>ImageRepository</code> (but not both).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder codeRepository(CodeRepository codeRepository);

        /**
         * <p>
         * The description of a source code repository.
         * </p>
         * <p>
         * You must provide either this member or <code>ImageRepository</code> (but not both).
         * </p>
         * This is a convenience method that creates an instance of the {@link CodeRepository.Builder} avoiding the need
         * to create one manually via {@link CodeRepository#builder()}.
         *
         * When the {@link Consumer} completes, {@link CodeRepository.Builder#build()} is called immediately and its
         * result is passed to {@link #codeRepository(CodeRepository)}.
         * 
         * @param codeRepository
         *        a consumer that will call methods on {@link CodeRepository.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #codeRepository(CodeRepository)
         */
        default Builder codeRepository(Consumer<CodeRepository.Builder> codeRepository) {
            return codeRepository(CodeRepository.builder().applyMutation(codeRepository).build());
        }

        /**
         * <p>
         * The description of a source image repository.
         * </p>
         * <p>
         * You must provide either this member or <code>CodeRepository</code> (but not both).
         * </p>
         * 
         * @param imageRepository
         *        The description of a source image repository.</p>
         *        <p>
         *        You must provide either this member or <code>CodeRepository</code> (but not both).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageRepository(ImageRepository imageRepository);

        /**
         * <p>
         * The description of a source image repository.
         * </p>
         * <p>
         * You must provide either this member or <code>CodeRepository</code> (but not both).
         * </p>
         * This is a convenience method that creates an instance of the {@link ImageRepository.Builder} avoiding the
         * need to create one manually via {@link ImageRepository#builder()}.
         *
         * When the {@link Consumer} completes, {@link ImageRepository.Builder#build()} is called immediately and its
         * result is passed to {@link #imageRepository(ImageRepository)}.
         * 
         * @param imageRepository
         *        a consumer that will call methods on {@link ImageRepository.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #imageRepository(ImageRepository)
         */
        default Builder imageRepository(Consumer<ImageRepository.Builder> imageRepository) {
            return imageRepository(ImageRepository.builder().applyMutation(imageRepository).build());
        }

        /**
         * <p>
         * If <code>true</code>, continuous integration from the source repository is enabled for the App Runner
         * service. Each repository change (including any source code commit or new image version) starts a deployment.
         * </p>
         * <p>
         * Default: App Runner sets to <code>false</code> for a source image that uses an ECR Public repository or an
         * ECR repository that's in an Amazon Web Services account other than the one that the service is in. App Runner
         * sets to <code>true</code> in all other cases (which currently include a source code repository or a source
         * image using a same-account ECR repository).
         * </p>
         * 
         * @param autoDeploymentsEnabled
         *        If <code>true</code>, continuous integration from the source repository is enabled for the App Runner
         *        service. Each repository change (including any source code commit or new image version) starts a
         *        deployment.</p>
         *        <p>
         *        Default: App Runner sets to <code>false</code> for a source image that uses an ECR Public repository
         *        or an ECR repository that's in an Amazon Web Services account other than the one that the service is
         *        in. App Runner sets to <code>true</code> in all other cases (which currently include a source code
         *        repository or a source image using a same-account ECR repository).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoDeploymentsEnabled(Boolean autoDeploymentsEnabled);

        /**
         * <p>
         * Describes the resources that are needed to authenticate access to some source repositories.
         * </p>
         * 
         * @param authenticationConfiguration
         *        Describes the resources that are needed to authenticate access to some source repositories.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authenticationConfiguration(AuthenticationConfiguration authenticationConfiguration);

        /**
         * <p>
         * Describes the resources that are needed to authenticate access to some source repositories.
         * </p>
         * This is a convenience method that creates an instance of the {@link AuthenticationConfiguration.Builder}
         * avoiding the need to create one manually via {@link AuthenticationConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link AuthenticationConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #authenticationConfiguration(AuthenticationConfiguration)}.
         * 
         * @param authenticationConfiguration
         *        a consumer that will call methods on {@link AuthenticationConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #authenticationConfiguration(AuthenticationConfiguration)
         */
        default Builder authenticationConfiguration(Consumer<AuthenticationConfiguration.Builder> authenticationConfiguration) {
            return authenticationConfiguration(AuthenticationConfiguration.builder().applyMutation(authenticationConfiguration)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private CodeRepository codeRepository;

        private ImageRepository imageRepository;

        private Boolean autoDeploymentsEnabled;

        private AuthenticationConfiguration authenticationConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(SourceConfiguration model) {
            codeRepository(model.codeRepository);
            imageRepository(model.imageRepository);
            autoDeploymentsEnabled(model.autoDeploymentsEnabled);
            authenticationConfiguration(model.authenticationConfiguration);
        }

        public final CodeRepository.Builder getCodeRepository() {
            return codeRepository != null ? codeRepository.toBuilder() : null;
        }

        public final void setCodeRepository(CodeRepository.BuilderImpl codeRepository) {
            this.codeRepository = codeRepository != null ? codeRepository.build() : null;
        }

        @Override
        public final Builder codeRepository(CodeRepository codeRepository) {
            this.codeRepository = codeRepository;
            return this;
        }

        public final ImageRepository.Builder getImageRepository() {
            return imageRepository != null ? imageRepository.toBuilder() : null;
        }

        public final void setImageRepository(ImageRepository.BuilderImpl imageRepository) {
            this.imageRepository = imageRepository != null ? imageRepository.build() : null;
        }

        @Override
        public final Builder imageRepository(ImageRepository imageRepository) {
            this.imageRepository = imageRepository;
            return this;
        }

        public final Boolean getAutoDeploymentsEnabled() {
            return autoDeploymentsEnabled;
        }

        public final void setAutoDeploymentsEnabled(Boolean autoDeploymentsEnabled) {
            this.autoDeploymentsEnabled = autoDeploymentsEnabled;
        }

        @Override
        public final Builder autoDeploymentsEnabled(Boolean autoDeploymentsEnabled) {
            this.autoDeploymentsEnabled = autoDeploymentsEnabled;
            return this;
        }

        public final AuthenticationConfiguration.Builder getAuthenticationConfiguration() {
            return authenticationConfiguration != null ? authenticationConfiguration.toBuilder() : null;
        }

        public final void setAuthenticationConfiguration(AuthenticationConfiguration.BuilderImpl authenticationConfiguration) {
            this.authenticationConfiguration = authenticationConfiguration != null ? authenticationConfiguration.build() : null;
        }

        @Override
        public final Builder authenticationConfiguration(AuthenticationConfiguration authenticationConfiguration) {
            this.authenticationConfiguration = authenticationConfiguration;
            return this;
        }

        @Override
        public SourceConfiguration build() {
            return new SourceConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
