/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apprunner.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeAutoScalingConfigurationResponse extends AppRunnerResponse implements
        ToCopyableBuilder<DescribeAutoScalingConfigurationResponse.Builder, DescribeAutoScalingConfigurationResponse> {
    private static final SdkField<AutoScalingConfiguration> AUTO_SCALING_CONFIGURATION_FIELD = SdkField
            .<AutoScalingConfiguration> builder(MarshallingType.SDK_POJO).memberName("AutoScalingConfiguration")
            .getter(getter(DescribeAutoScalingConfigurationResponse::autoScalingConfiguration))
            .setter(setter(Builder::autoScalingConfiguration)).constructor(AutoScalingConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoScalingConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(AUTO_SCALING_CONFIGURATION_FIELD));

    private final AutoScalingConfiguration autoScalingConfiguration;

    private DescribeAutoScalingConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.autoScalingConfiguration = builder.autoScalingConfiguration;
    }

    /**
     * <p>
     * A full description of the App Runner auto scaling configuration that you specified in this request.
     * </p>
     * 
     * @return A full description of the App Runner auto scaling configuration that you specified in this request.
     */
    public final AutoScalingConfiguration autoScalingConfiguration() {
        return autoScalingConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(autoScalingConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAutoScalingConfigurationResponse)) {
            return false;
        }
        DescribeAutoScalingConfigurationResponse other = (DescribeAutoScalingConfigurationResponse) obj;
        return Objects.equals(autoScalingConfiguration(), other.autoScalingConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeAutoScalingConfigurationResponse")
                .add("AutoScalingConfiguration", autoScalingConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AutoScalingConfiguration":
            return Optional.ofNullable(clazz.cast(autoScalingConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAutoScalingConfigurationResponse, T> g) {
        return obj -> g.apply((DescribeAutoScalingConfigurationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppRunnerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeAutoScalingConfigurationResponse> {
        /**
         * <p>
         * A full description of the App Runner auto scaling configuration that you specified in this request.
         * </p>
         * 
         * @param autoScalingConfiguration
         *        A full description of the App Runner auto scaling configuration that you specified in this request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoScalingConfiguration(AutoScalingConfiguration autoScalingConfiguration);

        /**
         * <p>
         * A full description of the App Runner auto scaling configuration that you specified in this request.
         * </p>
         * This is a convenience method that creates an instance of the {@link AutoScalingConfiguration.Builder}
         * avoiding the need to create one manually via {@link AutoScalingConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link AutoScalingConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #autoScalingConfiguration(AutoScalingConfiguration)}.
         * 
         * @param autoScalingConfiguration
         *        a consumer that will call methods on {@link AutoScalingConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #autoScalingConfiguration(AutoScalingConfiguration)
         */
        default Builder autoScalingConfiguration(Consumer<AutoScalingConfiguration.Builder> autoScalingConfiguration) {
            return autoScalingConfiguration(AutoScalingConfiguration.builder().applyMutation(autoScalingConfiguration).build());
        }
    }

    static final class BuilderImpl extends AppRunnerResponse.BuilderImpl implements Builder {
        private AutoScalingConfiguration autoScalingConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAutoScalingConfigurationResponse model) {
            super(model);
            autoScalingConfiguration(model.autoScalingConfiguration);
        }

        public final AutoScalingConfiguration.Builder getAutoScalingConfiguration() {
            return autoScalingConfiguration != null ? autoScalingConfiguration.toBuilder() : null;
        }

        public final void setAutoScalingConfiguration(AutoScalingConfiguration.BuilderImpl autoScalingConfiguration) {
            this.autoScalingConfiguration = autoScalingConfiguration != null ? autoScalingConfiguration.build() : null;
        }

        @Override
        public final Builder autoScalingConfiguration(AutoScalingConfiguration autoScalingConfiguration) {
            this.autoScalingConfiguration = autoScalingConfiguration;
            return this;
        }

        @Override
        public DescribeAutoScalingConfigurationResponse build() {
            return new DescribeAutoScalingConfigurationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
