/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apprunner.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DisassociateCustomDomainResponse extends AppRunnerResponse implements
        ToCopyableBuilder<DisassociateCustomDomainResponse.Builder, DisassociateCustomDomainResponse> {
    private static final SdkField<String> DNS_TARGET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DNSTarget").getter(getter(DisassociateCustomDomainResponse::dnsTarget))
            .setter(setter(Builder::dnsTarget))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DNSTarget").build()).build();

    private static final SdkField<String> SERVICE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServiceArn").getter(getter(DisassociateCustomDomainResponse::serviceArn))
            .setter(setter(Builder::serviceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceArn").build()).build();

    private static final SdkField<CustomDomain> CUSTOM_DOMAIN_FIELD = SdkField.<CustomDomain> builder(MarshallingType.SDK_POJO)
            .memberName("CustomDomain").getter(getter(DisassociateCustomDomainResponse::customDomain))
            .setter(setter(Builder::customDomain)).constructor(CustomDomain::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomDomain").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DNS_TARGET_FIELD,
            SERVICE_ARN_FIELD, CUSTOM_DOMAIN_FIELD));

    private final String dnsTarget;

    private final String serviceArn;

    private final CustomDomain customDomain;

    private DisassociateCustomDomainResponse(BuilderImpl builder) {
        super(builder);
        this.dnsTarget = builder.dnsTarget;
        this.serviceArn = builder.serviceArn;
        this.customDomain = builder.customDomain;
    }

    /**
     * <p>
     * The App Runner subdomain of the App Runner service. The disassociated custom domain name was mapped to this
     * target name.
     * </p>
     * 
     * @return The App Runner subdomain of the App Runner service. The disassociated custom domain name was mapped to
     *         this target name.
     */
    public final String dnsTarget() {
        return dnsTarget;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the App Runner service that a custom domain name is disassociated from.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the App Runner service that a custom domain name is disassociated from.
     */
    public final String serviceArn() {
        return serviceArn;
    }

    /**
     * <p>
     * A description of the domain name that's being disassociated.
     * </p>
     * 
     * @return A description of the domain name that's being disassociated.
     */
    public final CustomDomain customDomain() {
        return customDomain;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dnsTarget());
        hashCode = 31 * hashCode + Objects.hashCode(serviceArn());
        hashCode = 31 * hashCode + Objects.hashCode(customDomain());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisassociateCustomDomainResponse)) {
            return false;
        }
        DisassociateCustomDomainResponse other = (DisassociateCustomDomainResponse) obj;
        return Objects.equals(dnsTarget(), other.dnsTarget()) && Objects.equals(serviceArn(), other.serviceArn())
                && Objects.equals(customDomain(), other.customDomain());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DisassociateCustomDomainResponse").add("DNSTarget", dnsTarget()).add("ServiceArn", serviceArn())
                .add("CustomDomain", customDomain()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DNSTarget":
            return Optional.ofNullable(clazz.cast(dnsTarget()));
        case "ServiceArn":
            return Optional.ofNullable(clazz.cast(serviceArn()));
        case "CustomDomain":
            return Optional.ofNullable(clazz.cast(customDomain()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DisassociateCustomDomainResponse, T> g) {
        return obj -> g.apply((DisassociateCustomDomainResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppRunnerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DisassociateCustomDomainResponse> {
        /**
         * <p>
         * The App Runner subdomain of the App Runner service. The disassociated custom domain name was mapped to this
         * target name.
         * </p>
         * 
         * @param dnsTarget
         *        The App Runner subdomain of the App Runner service. The disassociated custom domain name was mapped to
         *        this target name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dnsTarget(String dnsTarget);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the App Runner service that a custom domain name is disassociated from.
         * </p>
         * 
         * @param serviceArn
         *        The Amazon Resource Name (ARN) of the App Runner service that a custom domain name is disassociated
         *        from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceArn(String serviceArn);

        /**
         * <p>
         * A description of the domain name that's being disassociated.
         * </p>
         * 
         * @param customDomain
         *        A description of the domain name that's being disassociated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customDomain(CustomDomain customDomain);

        /**
         * <p>
         * A description of the domain name that's being disassociated.
         * </p>
         * This is a convenience method that creates an instance of the {@link CustomDomain.Builder} avoiding the need
         * to create one manually via {@link CustomDomain#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CustomDomain.Builder#build()} is called immediately and its
         * result is passed to {@link #customDomain(CustomDomain)}.
         * 
         * @param customDomain
         *        a consumer that will call methods on {@link CustomDomain.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customDomain(CustomDomain)
         */
        default Builder customDomain(Consumer<CustomDomain.Builder> customDomain) {
            return customDomain(CustomDomain.builder().applyMutation(customDomain).build());
        }
    }

    static final class BuilderImpl extends AppRunnerResponse.BuilderImpl implements Builder {
        private String dnsTarget;

        private String serviceArn;

        private CustomDomain customDomain;

        private BuilderImpl() {
        }

        private BuilderImpl(DisassociateCustomDomainResponse model) {
            super(model);
            dnsTarget(model.dnsTarget);
            serviceArn(model.serviceArn);
            customDomain(model.customDomain);
        }

        public final String getDnsTarget() {
            return dnsTarget;
        }

        public final void setDnsTarget(String dnsTarget) {
            this.dnsTarget = dnsTarget;
        }

        @Override
        public final Builder dnsTarget(String dnsTarget) {
            this.dnsTarget = dnsTarget;
            return this;
        }

        public final String getServiceArn() {
            return serviceArn;
        }

        public final void setServiceArn(String serviceArn) {
            this.serviceArn = serviceArn;
        }

        @Override
        public final Builder serviceArn(String serviceArn) {
            this.serviceArn = serviceArn;
            return this;
        }

        public final CustomDomain.Builder getCustomDomain() {
            return customDomain != null ? customDomain.toBuilder() : null;
        }

        public final void setCustomDomain(CustomDomain.BuilderImpl customDomain) {
            this.customDomain = customDomain != null ? customDomain.build() : null;
        }

        @Override
        public final Builder customDomain(CustomDomain customDomain) {
            this.customDomain = customDomain;
            return this;
        }

        @Override
        public DisassociateCustomDomainResponse build() {
            return new DisassociateCustomDomainResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
