/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apprunner.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssociateCustomDomainRequest extends AppRunnerRequest implements
        ToCopyableBuilder<AssociateCustomDomainRequest.Builder, AssociateCustomDomainRequest> {
    private static final SdkField<String> SERVICE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServiceArn").getter(getter(AssociateCustomDomainRequest::serviceArn))
            .setter(setter(Builder::serviceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceArn").build()).build();

    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainName").getter(getter(AssociateCustomDomainRequest::domainName))
            .setter(setter(Builder::domainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").build()).build();

    private static final SdkField<Boolean> ENABLE_WWW_SUBDOMAIN_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EnableWWWSubdomain").getter(getter(AssociateCustomDomainRequest::enableWWWSubdomain))
            .setter(setter(Builder::enableWWWSubdomain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableWWWSubdomain").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_ARN_FIELD,
            DOMAIN_NAME_FIELD, ENABLE_WWW_SUBDOMAIN_FIELD));

    private final String serviceArn;

    private final String domainName;

    private final Boolean enableWWWSubdomain;

    private AssociateCustomDomainRequest(BuilderImpl builder) {
        super(builder);
        this.serviceArn = builder.serviceArn;
        this.domainName = builder.domainName;
        this.enableWWWSubdomain = builder.enableWWWSubdomain;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the App Runner service that you want to associate a custom domain name with.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the App Runner service that you want to associate a custom domain name
     *         with.
     */
    public final String serviceArn() {
        return serviceArn;
    }

    /**
     * <p>
     * A custom domain endpoint to associate. Specify a root domain (for example, <code>example.com</code>), a subdomain
     * (for example, <code>login.example.com</code> or <code>admin.login.example.com</code>), or a wildcard (for
     * example, <code>*.example.com</code>).
     * </p>
     * 
     * @return A custom domain endpoint to associate. Specify a root domain (for example, <code>example.com</code>), a
     *         subdomain (for example, <code>login.example.com</code> or <code>admin.login.example.com</code>), or a
     *         wildcard (for example, <code>*.example.com</code>).
     */
    public final String domainName() {
        return domainName;
    }

    /**
     * <p>
     * Set to <code>true</code> to associate the subdomain <code>www.<i>DomainName</i> </code> with the App Runner
     * service in addition to the base domain.
     * </p>
     * <p>
     * Default: <code>true</code>
     * </p>
     * 
     * @return Set to <code>true</code> to associate the subdomain <code>www.<i>DomainName</i> </code> with the App
     *         Runner service in addition to the base domain.</p>
     *         <p>
     *         Default: <code>true</code>
     */
    public final Boolean enableWWWSubdomain() {
        return enableWWWSubdomain;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(serviceArn());
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        hashCode = 31 * hashCode + Objects.hashCode(enableWWWSubdomain());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateCustomDomainRequest)) {
            return false;
        }
        AssociateCustomDomainRequest other = (AssociateCustomDomainRequest) obj;
        return Objects.equals(serviceArn(), other.serviceArn()) && Objects.equals(domainName(), other.domainName())
                && Objects.equals(enableWWWSubdomain(), other.enableWWWSubdomain());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssociateCustomDomainRequest").add("ServiceArn", serviceArn()).add("DomainName", domainName())
                .add("EnableWWWSubdomain", enableWWWSubdomain()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ServiceArn":
            return Optional.ofNullable(clazz.cast(serviceArn()));
        case "DomainName":
            return Optional.ofNullable(clazz.cast(domainName()));
        case "EnableWWWSubdomain":
            return Optional.ofNullable(clazz.cast(enableWWWSubdomain()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssociateCustomDomainRequest, T> g) {
        return obj -> g.apply((AssociateCustomDomainRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppRunnerRequest.Builder, SdkPojo, CopyableBuilder<Builder, AssociateCustomDomainRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the App Runner service that you want to associate a custom domain name
         * with.
         * </p>
         * 
         * @param serviceArn
         *        The Amazon Resource Name (ARN) of the App Runner service that you want to associate a custom domain
         *        name with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceArn(String serviceArn);

        /**
         * <p>
         * A custom domain endpoint to associate. Specify a root domain (for example, <code>example.com</code>), a
         * subdomain (for example, <code>login.example.com</code> or <code>admin.login.example.com</code>), or a
         * wildcard (for example, <code>*.example.com</code>).
         * </p>
         * 
         * @param domainName
         *        A custom domain endpoint to associate. Specify a root domain (for example, <code>example.com</code>),
         *        a subdomain (for example, <code>login.example.com</code> or <code>admin.login.example.com</code>), or
         *        a wildcard (for example, <code>*.example.com</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * Set to <code>true</code> to associate the subdomain <code>www.<i>DomainName</i> </code> with the App Runner
         * service in addition to the base domain.
         * </p>
         * <p>
         * Default: <code>true</code>
         * </p>
         * 
         * @param enableWWWSubdomain
         *        Set to <code>true</code> to associate the subdomain <code>www.<i>DomainName</i> </code> with the App
         *        Runner service in addition to the base domain.</p>
         *        <p>
         *        Default: <code>true</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableWWWSubdomain(Boolean enableWWWSubdomain);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AppRunnerRequest.BuilderImpl implements Builder {
        private String serviceArn;

        private String domainName;

        private Boolean enableWWWSubdomain;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateCustomDomainRequest model) {
            super(model);
            serviceArn(model.serviceArn);
            domainName(model.domainName);
            enableWWWSubdomain(model.enableWWWSubdomain);
        }

        public final String getServiceArn() {
            return serviceArn;
        }

        public final void setServiceArn(String serviceArn) {
            this.serviceArn = serviceArn;
        }

        @Override
        public final Builder serviceArn(String serviceArn) {
            this.serviceArn = serviceArn;
            return this;
        }

        public final String getDomainName() {
            return domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final Boolean getEnableWWWSubdomain() {
            return enableWWWSubdomain;
        }

        public final void setEnableWWWSubdomain(Boolean enableWWWSubdomain) {
            this.enableWWWSubdomain = enableWWWSubdomain;
        }

        @Override
        public final Builder enableWWWSubdomain(Boolean enableWWWSubdomain) {
            this.enableWWWSubdomain = enableWWWSubdomain;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociateCustomDomainRequest build() {
            return new AssociateCustomDomainRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
