/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apprunner.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the observability configuration of an App Runner service. These are additional observability features, like
 * tracing, that you choose to enable. They're configured in a separate resource that you associate with your service.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ServiceObservabilityConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ServiceObservabilityConfiguration.Builder, ServiceObservabilityConfiguration> {
    private static final SdkField<Boolean> OBSERVABILITY_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ObservabilityEnabled").getter(getter(ServiceObservabilityConfiguration::observabilityEnabled))
            .setter(setter(Builder::observabilityEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObservabilityEnabled").build())
            .build();

    private static final SdkField<String> OBSERVABILITY_CONFIGURATION_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ObservabilityConfigurationArn")
            .getter(getter(ServiceObservabilityConfiguration::observabilityConfigurationArn))
            .setter(setter(Builder::observabilityConfigurationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObservabilityConfigurationArn")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OBSERVABILITY_ENABLED_FIELD,
            OBSERVABILITY_CONFIGURATION_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean observabilityEnabled;

    private final String observabilityConfigurationArn;

    private ServiceObservabilityConfiguration(BuilderImpl builder) {
        this.observabilityEnabled = builder.observabilityEnabled;
        this.observabilityConfigurationArn = builder.observabilityConfigurationArn;
    }

    /**
     * <p>
     * When <code>true</code>, an observability configuration resource is associated with the service, and an
     * <code>ObservabilityConfigurationArn</code> is specified.
     * </p>
     * 
     * @return When <code>true</code>, an observability configuration resource is associated with the service, and an
     *         <code>ObservabilityConfigurationArn</code> is specified.
     */
    public final Boolean observabilityEnabled() {
        return observabilityEnabled;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the observability configuration that is associated with the service. Specified
     * only when <code>ObservabilityEnabled</code> is <code>true</code>.
     * </p>
     * <p>
     * Specify an ARN with a name and a revision number to associate that revision. For example:
     * <code>arn:aws:apprunner:us-east-1:123456789012:observabilityconfiguration/xray-tracing/3</code>
     * </p>
     * <p>
     * Specify just the name to associate the latest revision. For example:
     * <code>arn:aws:apprunner:us-east-1:123456789012:observabilityconfiguration/xray-tracing</code>
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the observability configuration that is associated with the service.
     *         Specified only when <code>ObservabilityEnabled</code> is <code>true</code>.</p>
     *         <p>
     *         Specify an ARN with a name and a revision number to associate that revision. For example:
     *         <code>arn:aws:apprunner:us-east-1:123456789012:observabilityconfiguration/xray-tracing/3</code>
     *         </p>
     *         <p>
     *         Specify just the name to associate the latest revision. For example:
     *         <code>arn:aws:apprunner:us-east-1:123456789012:observabilityconfiguration/xray-tracing</code>
     */
    public final String observabilityConfigurationArn() {
        return observabilityConfigurationArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(observabilityEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(observabilityConfigurationArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceObservabilityConfiguration)) {
            return false;
        }
        ServiceObservabilityConfiguration other = (ServiceObservabilityConfiguration) obj;
        return Objects.equals(observabilityEnabled(), other.observabilityEnabled())
                && Objects.equals(observabilityConfigurationArn(), other.observabilityConfigurationArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ServiceObservabilityConfiguration").add("ObservabilityEnabled", observabilityEnabled())
                .add("ObservabilityConfigurationArn", observabilityConfigurationArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ObservabilityEnabled":
            return Optional.ofNullable(clazz.cast(observabilityEnabled()));
        case "ObservabilityConfigurationArn":
            return Optional.ofNullable(clazz.cast(observabilityConfigurationArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ServiceObservabilityConfiguration, T> g) {
        return obj -> g.apply((ServiceObservabilityConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ServiceObservabilityConfiguration> {
        /**
         * <p>
         * When <code>true</code>, an observability configuration resource is associated with the service, and an
         * <code>ObservabilityConfigurationArn</code> is specified.
         * </p>
         * 
         * @param observabilityEnabled
         *        When <code>true</code>, an observability configuration resource is associated with the service, and an
         *        <code>ObservabilityConfigurationArn</code> is specified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder observabilityEnabled(Boolean observabilityEnabled);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the observability configuration that is associated with the service.
         * Specified only when <code>ObservabilityEnabled</code> is <code>true</code>.
         * </p>
         * <p>
         * Specify an ARN with a name and a revision number to associate that revision. For example:
         * <code>arn:aws:apprunner:us-east-1:123456789012:observabilityconfiguration/xray-tracing/3</code>
         * </p>
         * <p>
         * Specify just the name to associate the latest revision. For example:
         * <code>arn:aws:apprunner:us-east-1:123456789012:observabilityconfiguration/xray-tracing</code>
         * </p>
         * 
         * @param observabilityConfigurationArn
         *        The Amazon Resource Name (ARN) of the observability configuration that is associated with the service.
         *        Specified only when <code>ObservabilityEnabled</code> is <code>true</code>.</p>
         *        <p>
         *        Specify an ARN with a name and a revision number to associate that revision. For example:
         *        <code>arn:aws:apprunner:us-east-1:123456789012:observabilityconfiguration/xray-tracing/3</code>
         *        </p>
         *        <p>
         *        Specify just the name to associate the latest revision. For example:
         *        <code>arn:aws:apprunner:us-east-1:123456789012:observabilityconfiguration/xray-tracing</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder observabilityConfigurationArn(String observabilityConfigurationArn);
    }

    static final class BuilderImpl implements Builder {
        private Boolean observabilityEnabled;

        private String observabilityConfigurationArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceObservabilityConfiguration model) {
            observabilityEnabled(model.observabilityEnabled);
            observabilityConfigurationArn(model.observabilityConfigurationArn);
        }

        public final Boolean getObservabilityEnabled() {
            return observabilityEnabled;
        }

        public final void setObservabilityEnabled(Boolean observabilityEnabled) {
            this.observabilityEnabled = observabilityEnabled;
        }

        @Override
        public final Builder observabilityEnabled(Boolean observabilityEnabled) {
            this.observabilityEnabled = observabilityEnabled;
            return this;
        }

        public final String getObservabilityConfigurationArn() {
            return observabilityConfigurationArn;
        }

        public final void setObservabilityConfigurationArn(String observabilityConfigurationArn) {
            this.observabilityConfigurationArn = observabilityConfigurationArn;
        }

        @Override
        public final Builder observabilityConfigurationArn(String observabilityConfigurationArn) {
            this.observabilityConfigurationArn = observabilityConfigurationArn;
            return this;
        }

        @Override
        public ServiceObservabilityConfiguration build() {
            return new ServiceObservabilityConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
