/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apprunner.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Identifies a version of code that AWS App Runner refers to within a source code repository.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SourceCodeVersion implements SdkPojo, Serializable,
        ToCopyableBuilder<SourceCodeVersion.Builder, SourceCodeVersion> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(SourceCodeVersion::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Value")
            .getter(getter(SourceCodeVersion::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String type;

    private final String value;

    private SourceCodeVersion(BuilderImpl builder) {
        this.type = builder.type;
        this.value = builder.value;
    }

    /**
     * <p>
     * The type of version identifier.
     * </p>
     * <p>
     * For a git-based repository, branches represent versions.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link SourceCodeVersionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of version identifier.</p>
     *         <p>
     *         For a git-based repository, branches represent versions.
     * @see SourceCodeVersionType
     */
    public final SourceCodeVersionType type() {
        return SourceCodeVersionType.fromValue(type);
    }

    /**
     * <p>
     * The type of version identifier.
     * </p>
     * <p>
     * For a git-based repository, branches represent versions.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link SourceCodeVersionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of version identifier.</p>
     *         <p>
     *         For a git-based repository, branches represent versions.
     * @see SourceCodeVersionType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * A source code version.
     * </p>
     * <p>
     * For a git-based repository, a branch name maps to a specific version. App Runner uses the most recent commit to
     * the branch.
     * </p>
     * 
     * @return A source code version.</p>
     *         <p>
     *         For a git-based repository, a branch name maps to a specific version. App Runner uses the most recent
     *         commit to the branch.
     */
    public final String value() {
        return value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SourceCodeVersion)) {
            return false;
        }
        SourceCodeVersion other = (SourceCodeVersion) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(value(), other.value());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SourceCodeVersion").add("Type", typeAsString()).add("Value", value()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SourceCodeVersion, T> g) {
        return obj -> g.apply((SourceCodeVersion) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SourceCodeVersion> {
        /**
         * <p>
         * The type of version identifier.
         * </p>
         * <p>
         * For a git-based repository, branches represent versions.
         * </p>
         * 
         * @param type
         *        The type of version identifier.</p>
         *        <p>
         *        For a git-based repository, branches represent versions.
         * @see SourceCodeVersionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SourceCodeVersionType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of version identifier.
         * </p>
         * <p>
         * For a git-based repository, branches represent versions.
         * </p>
         * 
         * @param type
         *        The type of version identifier.</p>
         *        <p>
         *        For a git-based repository, branches represent versions.
         * @see SourceCodeVersionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SourceCodeVersionType
         */
        Builder type(SourceCodeVersionType type);

        /**
         * <p>
         * A source code version.
         * </p>
         * <p>
         * For a git-based repository, a branch name maps to a specific version. App Runner uses the most recent commit
         * to the branch.
         * </p>
         * 
         * @param value
         *        A source code version.</p>
         *        <p>
         *        For a git-based repository, a branch name maps to a specific version. App Runner uses the most recent
         *        commit to the branch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String value);
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private String value;

        private BuilderImpl() {
        }

        private BuilderImpl(SourceCodeVersion model) {
            type(model.type);
            value(model.value);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        @Transient
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        @Transient
        public final Builder type(SourceCodeVersionType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getValue() {
            return value;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        @Transient
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        @Override
        public SourceCodeVersion build() {
            return new SourceCodeVersion(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
