/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apprunner.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateServiceRequest extends AppRunnerRequest implements
        ToCopyableBuilder<UpdateServiceRequest.Builder, UpdateServiceRequest> {
    private static final SdkField<String> SERVICE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServiceArn").getter(getter(UpdateServiceRequest::serviceArn)).setter(setter(Builder::serviceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceArn").build()).build();

    private static final SdkField<SourceConfiguration> SOURCE_CONFIGURATION_FIELD = SdkField
            .<SourceConfiguration> builder(MarshallingType.SDK_POJO).memberName("SourceConfiguration")
            .getter(getter(UpdateServiceRequest::sourceConfiguration)).setter(setter(Builder::sourceConfiguration))
            .constructor(SourceConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceConfiguration").build())
            .build();

    private static final SdkField<InstanceConfiguration> INSTANCE_CONFIGURATION_FIELD = SdkField
            .<InstanceConfiguration> builder(MarshallingType.SDK_POJO).memberName("InstanceConfiguration")
            .getter(getter(UpdateServiceRequest::instanceConfiguration)).setter(setter(Builder::instanceConfiguration))
            .constructor(InstanceConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceConfiguration").build())
            .build();

    private static final SdkField<String> AUTO_SCALING_CONFIGURATION_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AutoScalingConfigurationArn")
            .getter(getter(UpdateServiceRequest::autoScalingConfigurationArn))
            .setter(setter(Builder::autoScalingConfigurationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoScalingConfigurationArn")
                    .build()).build();

    private static final SdkField<HealthCheckConfiguration> HEALTH_CHECK_CONFIGURATION_FIELD = SdkField
            .<HealthCheckConfiguration> builder(MarshallingType.SDK_POJO).memberName("HealthCheckConfiguration")
            .getter(getter(UpdateServiceRequest::healthCheckConfiguration)).setter(setter(Builder::healthCheckConfiguration))
            .constructor(HealthCheckConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthCheckConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_ARN_FIELD,
            SOURCE_CONFIGURATION_FIELD, INSTANCE_CONFIGURATION_FIELD, AUTO_SCALING_CONFIGURATION_ARN_FIELD,
            HEALTH_CHECK_CONFIGURATION_FIELD));

    private final String serviceArn;

    private final SourceConfiguration sourceConfiguration;

    private final InstanceConfiguration instanceConfiguration;

    private final String autoScalingConfigurationArn;

    private final HealthCheckConfiguration healthCheckConfiguration;

    private UpdateServiceRequest(BuilderImpl builder) {
        super(builder);
        this.serviceArn = builder.serviceArn;
        this.sourceConfiguration = builder.sourceConfiguration;
        this.instanceConfiguration = builder.instanceConfiguration;
        this.autoScalingConfigurationArn = builder.autoScalingConfigurationArn;
        this.healthCheckConfiguration = builder.healthCheckConfiguration;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the App Runner service that you want to update.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the App Runner service that you want to update.
     */
    public final String serviceArn() {
        return serviceArn;
    }

    /**
     * <p>
     * The source configuration to apply to the App Runner service.
     * </p>
     * <p>
     * You can change the configuration of the code or image repository that the service uses. However, you can't switch
     * from code to image or the other way around. This means that you must provide the same structure member of
     * <code>SourceConfiguration</code> that you originally included when you created the service. Specifically, you can
     * include either <code>CodeRepository</code> or <code>ImageRepository</code>. To update the source configuration,
     * set the values to members of the structure that you include.
     * </p>
     * 
     * @return The source configuration to apply to the App Runner service.</p>
     *         <p>
     *         You can change the configuration of the code or image repository that the service uses. However, you
     *         can't switch from code to image or the other way around. This means that you must provide the same
     *         structure member of <code>SourceConfiguration</code> that you originally included when you created the
     *         service. Specifically, you can include either <code>CodeRepository</code> or <code>ImageRepository</code>
     *         . To update the source configuration, set the values to members of the structure that you include.
     */
    public final SourceConfiguration sourceConfiguration() {
        return sourceConfiguration;
    }

    /**
     * <p>
     * The runtime configuration to apply to instances (scaling units) of the App Runner service.
     * </p>
     * 
     * @return The runtime configuration to apply to instances (scaling units) of the App Runner service.
     */
    public final InstanceConfiguration instanceConfiguration() {
        return instanceConfiguration;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of an App Runner automatic scaling configuration resource that you want to
     * associate with your service.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of an App Runner automatic scaling configuration resource that you want to
     *         associate with your service.
     */
    public final String autoScalingConfigurationArn() {
        return autoScalingConfigurationArn;
    }

    /**
     * <p>
     * The settings for the health check that AWS App Runner performs to monitor the health of your service.
     * </p>
     * 
     * @return The settings for the health check that AWS App Runner performs to monitor the health of your service.
     */
    public final HealthCheckConfiguration healthCheckConfiguration() {
        return healthCheckConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(serviceArn());
        hashCode = 31 * hashCode + Objects.hashCode(sourceConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(instanceConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(autoScalingConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(healthCheckConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateServiceRequest)) {
            return false;
        }
        UpdateServiceRequest other = (UpdateServiceRequest) obj;
        return Objects.equals(serviceArn(), other.serviceArn())
                && Objects.equals(sourceConfiguration(), other.sourceConfiguration())
                && Objects.equals(instanceConfiguration(), other.instanceConfiguration())
                && Objects.equals(autoScalingConfigurationArn(), other.autoScalingConfigurationArn())
                && Objects.equals(healthCheckConfiguration(), other.healthCheckConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateServiceRequest").add("ServiceArn", serviceArn())
                .add("SourceConfiguration", sourceConfiguration()).add("InstanceConfiguration", instanceConfiguration())
                .add("AutoScalingConfigurationArn", autoScalingConfigurationArn())
                .add("HealthCheckConfiguration", healthCheckConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ServiceArn":
            return Optional.ofNullable(clazz.cast(serviceArn()));
        case "SourceConfiguration":
            return Optional.ofNullable(clazz.cast(sourceConfiguration()));
        case "InstanceConfiguration":
            return Optional.ofNullable(clazz.cast(instanceConfiguration()));
        case "AutoScalingConfigurationArn":
            return Optional.ofNullable(clazz.cast(autoScalingConfigurationArn()));
        case "HealthCheckConfiguration":
            return Optional.ofNullable(clazz.cast(healthCheckConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateServiceRequest, T> g) {
        return obj -> g.apply((UpdateServiceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppRunnerRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateServiceRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the App Runner service that you want to update.
         * </p>
         * 
         * @param serviceArn
         *        The Amazon Resource Name (ARN) of the App Runner service that you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceArn(String serviceArn);

        /**
         * <p>
         * The source configuration to apply to the App Runner service.
         * </p>
         * <p>
         * You can change the configuration of the code or image repository that the service uses. However, you can't
         * switch from code to image or the other way around. This means that you must provide the same structure member
         * of <code>SourceConfiguration</code> that you originally included when you created the service. Specifically,
         * you can include either <code>CodeRepository</code> or <code>ImageRepository</code>. To update the source
         * configuration, set the values to members of the structure that you include.
         * </p>
         * 
         * @param sourceConfiguration
         *        The source configuration to apply to the App Runner service.</p>
         *        <p>
         *        You can change the configuration of the code or image repository that the service uses. However, you
         *        can't switch from code to image or the other way around. This means that you must provide the same
         *        structure member of <code>SourceConfiguration</code> that you originally included when you created the
         *        service. Specifically, you can include either <code>CodeRepository</code> or
         *        <code>ImageRepository</code>. To update the source configuration, set the values to members of the
         *        structure that you include.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceConfiguration(SourceConfiguration sourceConfiguration);

        /**
         * <p>
         * The source configuration to apply to the App Runner service.
         * </p>
         * <p>
         * You can change the configuration of the code or image repository that the service uses. However, you can't
         * switch from code to image or the other way around. This means that you must provide the same structure member
         * of <code>SourceConfiguration</code> that you originally included when you created the service. Specifically,
         * you can include either <code>CodeRepository</code> or <code>ImageRepository</code>. To update the source
         * configuration, set the values to members of the structure that you include.
         * </p>
         * This is a convenience that creates an instance of the {@link SourceConfiguration.Builder} avoiding the need
         * to create one manually via {@link SourceConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link SourceConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #sourceConfiguration(SourceConfiguration)}.
         * 
         * @param sourceConfiguration
         *        a consumer that will call methods on {@link SourceConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceConfiguration(SourceConfiguration)
         */
        default Builder sourceConfiguration(Consumer<SourceConfiguration.Builder> sourceConfiguration) {
            return sourceConfiguration(SourceConfiguration.builder().applyMutation(sourceConfiguration).build());
        }

        /**
         * <p>
         * The runtime configuration to apply to instances (scaling units) of the App Runner service.
         * </p>
         * 
         * @param instanceConfiguration
         *        The runtime configuration to apply to instances (scaling units) of the App Runner service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceConfiguration(InstanceConfiguration instanceConfiguration);

        /**
         * <p>
         * The runtime configuration to apply to instances (scaling units) of the App Runner service.
         * </p>
         * This is a convenience that creates an instance of the {@link InstanceConfiguration.Builder} avoiding the need
         * to create one manually via {@link InstanceConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link InstanceConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #instanceConfiguration(InstanceConfiguration)}.
         * 
         * @param instanceConfiguration
         *        a consumer that will call methods on {@link InstanceConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instanceConfiguration(InstanceConfiguration)
         */
        default Builder instanceConfiguration(Consumer<InstanceConfiguration.Builder> instanceConfiguration) {
            return instanceConfiguration(InstanceConfiguration.builder().applyMutation(instanceConfiguration).build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) of an App Runner automatic scaling configuration resource that you want to
         * associate with your service.
         * </p>
         * 
         * @param autoScalingConfigurationArn
         *        The Amazon Resource Name (ARN) of an App Runner automatic scaling configuration resource that you want
         *        to associate with your service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoScalingConfigurationArn(String autoScalingConfigurationArn);

        /**
         * <p>
         * The settings for the health check that AWS App Runner performs to monitor the health of your service.
         * </p>
         * 
         * @param healthCheckConfiguration
         *        The settings for the health check that AWS App Runner performs to monitor the health of your service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder healthCheckConfiguration(HealthCheckConfiguration healthCheckConfiguration);

        /**
         * <p>
         * The settings for the health check that AWS App Runner performs to monitor the health of your service.
         * </p>
         * This is a convenience that creates an instance of the {@link HealthCheckConfiguration.Builder} avoiding the
         * need to create one manually via {@link HealthCheckConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link HealthCheckConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #healthCheckConfiguration(HealthCheckConfiguration)}.
         * 
         * @param healthCheckConfiguration
         *        a consumer that will call methods on {@link HealthCheckConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #healthCheckConfiguration(HealthCheckConfiguration)
         */
        default Builder healthCheckConfiguration(Consumer<HealthCheckConfiguration.Builder> healthCheckConfiguration) {
            return healthCheckConfiguration(HealthCheckConfiguration.builder().applyMutation(healthCheckConfiguration).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AppRunnerRequest.BuilderImpl implements Builder {
        private String serviceArn;

        private SourceConfiguration sourceConfiguration;

        private InstanceConfiguration instanceConfiguration;

        private String autoScalingConfigurationArn;

        private HealthCheckConfiguration healthCheckConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateServiceRequest model) {
            super(model);
            serviceArn(model.serviceArn);
            sourceConfiguration(model.sourceConfiguration);
            instanceConfiguration(model.instanceConfiguration);
            autoScalingConfigurationArn(model.autoScalingConfigurationArn);
            healthCheckConfiguration(model.healthCheckConfiguration);
        }

        public final String getServiceArn() {
            return serviceArn;
        }

        public final void setServiceArn(String serviceArn) {
            this.serviceArn = serviceArn;
        }

        @Override
        @Transient
        public final Builder serviceArn(String serviceArn) {
            this.serviceArn = serviceArn;
            return this;
        }

        public final SourceConfiguration.Builder getSourceConfiguration() {
            return sourceConfiguration != null ? sourceConfiguration.toBuilder() : null;
        }

        public final void setSourceConfiguration(SourceConfiguration.BuilderImpl sourceConfiguration) {
            this.sourceConfiguration = sourceConfiguration != null ? sourceConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder sourceConfiguration(SourceConfiguration sourceConfiguration) {
            this.sourceConfiguration = sourceConfiguration;
            return this;
        }

        public final InstanceConfiguration.Builder getInstanceConfiguration() {
            return instanceConfiguration != null ? instanceConfiguration.toBuilder() : null;
        }

        public final void setInstanceConfiguration(InstanceConfiguration.BuilderImpl instanceConfiguration) {
            this.instanceConfiguration = instanceConfiguration != null ? instanceConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder instanceConfiguration(InstanceConfiguration instanceConfiguration) {
            this.instanceConfiguration = instanceConfiguration;
            return this;
        }

        public final String getAutoScalingConfigurationArn() {
            return autoScalingConfigurationArn;
        }

        public final void setAutoScalingConfigurationArn(String autoScalingConfigurationArn) {
            this.autoScalingConfigurationArn = autoScalingConfigurationArn;
        }

        @Override
        @Transient
        public final Builder autoScalingConfigurationArn(String autoScalingConfigurationArn) {
            this.autoScalingConfigurationArn = autoScalingConfigurationArn;
            return this;
        }

        public final HealthCheckConfiguration.Builder getHealthCheckConfiguration() {
            return healthCheckConfiguration != null ? healthCheckConfiguration.toBuilder() : null;
        }

        public final void setHealthCheckConfiguration(HealthCheckConfiguration.BuilderImpl healthCheckConfiguration) {
            this.healthCheckConfiguration = healthCheckConfiguration != null ? healthCheckConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder healthCheckConfiguration(HealthCheckConfiguration healthCheckConfiguration) {
            this.healthCheckConfiguration = healthCheckConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateServiceRequest build() {
            return new UpdateServiceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
