/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apprunner.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides summary information about an AWS App Runner automatic scaling configuration resource.
 * </p>
 * <p>
 * This type contains limited information about an auto scaling configuration. It includes only identification
 * information, without configuration details. It's returned by the <a>ListAutoScalingConfigurations</a> action.
 * Complete configuration information is returned by the <a>CreateAutoScalingConfiguration</a>,
 * <a>DescribeAutoScalingConfiguration</a>, and <a>DeleteAutoScalingConfiguration</a> actions using the
 * <a>AutoScalingConfiguration</a> type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AutoScalingConfigurationSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<AutoScalingConfigurationSummary.Builder, AutoScalingConfigurationSummary> {
    private static final SdkField<String> AUTO_SCALING_CONFIGURATION_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AutoScalingConfigurationArn")
            .getter(getter(AutoScalingConfigurationSummary::autoScalingConfigurationArn))
            .setter(setter(Builder::autoScalingConfigurationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoScalingConfigurationArn")
                    .build()).build();

    private static final SdkField<String> AUTO_SCALING_CONFIGURATION_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AutoScalingConfigurationName")
            .getter(getter(AutoScalingConfigurationSummary::autoScalingConfigurationName))
            .setter(setter(Builder::autoScalingConfigurationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoScalingConfigurationName")
                    .build()).build();

    private static final SdkField<Integer> AUTO_SCALING_CONFIGURATION_REVISION_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("AutoScalingConfigurationRevision")
            .getter(getter(AutoScalingConfigurationSummary::autoScalingConfigurationRevision))
            .setter(setter(Builder::autoScalingConfigurationRevision))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoScalingConfigurationRevision")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            AUTO_SCALING_CONFIGURATION_ARN_FIELD, AUTO_SCALING_CONFIGURATION_NAME_FIELD,
            AUTO_SCALING_CONFIGURATION_REVISION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String autoScalingConfigurationArn;

    private final String autoScalingConfigurationName;

    private final Integer autoScalingConfigurationRevision;

    private AutoScalingConfigurationSummary(BuilderImpl builder) {
        this.autoScalingConfigurationArn = builder.autoScalingConfigurationArn;
        this.autoScalingConfigurationName = builder.autoScalingConfigurationName;
        this.autoScalingConfigurationRevision = builder.autoScalingConfigurationRevision;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of this auto scaling configuration.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of this auto scaling configuration.
     */
    public final String autoScalingConfigurationArn() {
        return autoScalingConfigurationArn;
    }

    /**
     * <p>
     * The customer-provided auto scaling configuration name. It can be used in multiple revisions of a configuration.
     * </p>
     * 
     * @return The customer-provided auto scaling configuration name. It can be used in multiple revisions of a
     *         configuration.
     */
    public final String autoScalingConfigurationName() {
        return autoScalingConfigurationName;
    }

    /**
     * <p>
     * The revision of this auto scaling configuration. It's unique among all the active configurations (
     * <code>"Status": "ACTIVE"</code>) with the same <code>AutoScalingConfigurationName</code>.
     * </p>
     * 
     * @return The revision of this auto scaling configuration. It's unique among all the active configurations (
     *         <code>"Status": "ACTIVE"</code>) with the same <code>AutoScalingConfigurationName</code>.
     */
    public final Integer autoScalingConfigurationRevision() {
        return autoScalingConfigurationRevision;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(autoScalingConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(autoScalingConfigurationName());
        hashCode = 31 * hashCode + Objects.hashCode(autoScalingConfigurationRevision());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoScalingConfigurationSummary)) {
            return false;
        }
        AutoScalingConfigurationSummary other = (AutoScalingConfigurationSummary) obj;
        return Objects.equals(autoScalingConfigurationArn(), other.autoScalingConfigurationArn())
                && Objects.equals(autoScalingConfigurationName(), other.autoScalingConfigurationName())
                && Objects.equals(autoScalingConfigurationRevision(), other.autoScalingConfigurationRevision());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AutoScalingConfigurationSummary")
                .add("AutoScalingConfigurationArn", autoScalingConfigurationArn())
                .add("AutoScalingConfigurationName", autoScalingConfigurationName())
                .add("AutoScalingConfigurationRevision", autoScalingConfigurationRevision()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AutoScalingConfigurationArn":
            return Optional.ofNullable(clazz.cast(autoScalingConfigurationArn()));
        case "AutoScalingConfigurationName":
            return Optional.ofNullable(clazz.cast(autoScalingConfigurationName()));
        case "AutoScalingConfigurationRevision":
            return Optional.ofNullable(clazz.cast(autoScalingConfigurationRevision()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AutoScalingConfigurationSummary, T> g) {
        return obj -> g.apply((AutoScalingConfigurationSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AutoScalingConfigurationSummary> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of this auto scaling configuration.
         * </p>
         * 
         * @param autoScalingConfigurationArn
         *        The Amazon Resource Name (ARN) of this auto scaling configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoScalingConfigurationArn(String autoScalingConfigurationArn);

        /**
         * <p>
         * The customer-provided auto scaling configuration name. It can be used in multiple revisions of a
         * configuration.
         * </p>
         * 
         * @param autoScalingConfigurationName
         *        The customer-provided auto scaling configuration name. It can be used in multiple revisions of a
         *        configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoScalingConfigurationName(String autoScalingConfigurationName);

        /**
         * <p>
         * The revision of this auto scaling configuration. It's unique among all the active configurations (
         * <code>"Status": "ACTIVE"</code>) with the same <code>AutoScalingConfigurationName</code>.
         * </p>
         * 
         * @param autoScalingConfigurationRevision
         *        The revision of this auto scaling configuration. It's unique among all the active configurations (
         *        <code>"Status": "ACTIVE"</code>) with the same <code>AutoScalingConfigurationName</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoScalingConfigurationRevision(Integer autoScalingConfigurationRevision);
    }

    static final class BuilderImpl implements Builder {
        private String autoScalingConfigurationArn;

        private String autoScalingConfigurationName;

        private Integer autoScalingConfigurationRevision;

        private BuilderImpl() {
        }

        private BuilderImpl(AutoScalingConfigurationSummary model) {
            autoScalingConfigurationArn(model.autoScalingConfigurationArn);
            autoScalingConfigurationName(model.autoScalingConfigurationName);
            autoScalingConfigurationRevision(model.autoScalingConfigurationRevision);
        }

        public final String getAutoScalingConfigurationArn() {
            return autoScalingConfigurationArn;
        }

        public final void setAutoScalingConfigurationArn(String autoScalingConfigurationArn) {
            this.autoScalingConfigurationArn = autoScalingConfigurationArn;
        }

        @Override
        @Transient
        public final Builder autoScalingConfigurationArn(String autoScalingConfigurationArn) {
            this.autoScalingConfigurationArn = autoScalingConfigurationArn;
            return this;
        }

        public final String getAutoScalingConfigurationName() {
            return autoScalingConfigurationName;
        }

        public final void setAutoScalingConfigurationName(String autoScalingConfigurationName) {
            this.autoScalingConfigurationName = autoScalingConfigurationName;
        }

        @Override
        @Transient
        public final Builder autoScalingConfigurationName(String autoScalingConfigurationName) {
            this.autoScalingConfigurationName = autoScalingConfigurationName;
            return this;
        }

        public final Integer getAutoScalingConfigurationRevision() {
            return autoScalingConfigurationRevision;
        }

        public final void setAutoScalingConfigurationRevision(Integer autoScalingConfigurationRevision) {
            this.autoScalingConfigurationRevision = autoScalingConfigurationRevision;
        }

        @Override
        @Transient
        public final Builder autoScalingConfigurationRevision(Integer autoScalingConfigurationRevision) {
            this.autoScalingConfigurationRevision = autoScalingConfigurationRevision;
            return this;
        }

        @Override
        public AutoScalingConfigurationSummary build() {
            return new AutoScalingConfigurationSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
