/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apprunner.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateAutoScalingConfigurationRequest extends AppRunnerRequest implements
        ToCopyableBuilder<CreateAutoScalingConfigurationRequest.Builder, CreateAutoScalingConfigurationRequest> {
    private static final SdkField<String> AUTO_SCALING_CONFIGURATION_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AutoScalingConfigurationName")
            .getter(getter(CreateAutoScalingConfigurationRequest::autoScalingConfigurationName))
            .setter(setter(Builder::autoScalingConfigurationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoScalingConfigurationName")
                    .build()).build();

    private static final SdkField<Integer> MAX_CONCURRENCY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxConcurrency").getter(getter(CreateAutoScalingConfigurationRequest::maxConcurrency))
            .setter(setter(Builder::maxConcurrency))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxConcurrency").build()).build();

    private static final SdkField<Integer> MIN_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MinSize").getter(getter(CreateAutoScalingConfigurationRequest::minSize))
            .setter(setter(Builder::minSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinSize").build()).build();

    private static final SdkField<Integer> MAX_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxSize").getter(getter(CreateAutoScalingConfigurationRequest::maxSize))
            .setter(setter(Builder::maxSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxSize").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateAutoScalingConfigurationRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            AUTO_SCALING_CONFIGURATION_NAME_FIELD, MAX_CONCURRENCY_FIELD, MIN_SIZE_FIELD, MAX_SIZE_FIELD, TAGS_FIELD));

    private final String autoScalingConfigurationName;

    private final Integer maxConcurrency;

    private final Integer minSize;

    private final Integer maxSize;

    private final List<Tag> tags;

    private CreateAutoScalingConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.autoScalingConfigurationName = builder.autoScalingConfigurationName;
        this.maxConcurrency = builder.maxConcurrency;
        this.minSize = builder.minSize;
        this.maxSize = builder.maxSize;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * A name for the auto scaling configuration. When you use it for the first time in an AWS Region, App Runner
     * creates revision number <code>1</code> of this name. When you use the same name in subsequent calls, App Runner
     * creates incremental revisions of the configuration.
     * </p>
     * 
     * @return A name for the auto scaling configuration. When you use it for the first time in an AWS Region, App
     *         Runner creates revision number <code>1</code> of this name. When you use the same name in subsequent
     *         calls, App Runner creates incremental revisions of the configuration.
     */
    public final String autoScalingConfigurationName() {
        return autoScalingConfigurationName;
    }

    /**
     * <p>
     * The maximum number of concurrent requests that you want an instance to process. If the number of concurrent
     * requests exceeds this limit, App Runner scales up your service.
     * </p>
     * <p>
     * Default: <code>100</code>
     * </p>
     * 
     * @return The maximum number of concurrent requests that you want an instance to process. If the number of
     *         concurrent requests exceeds this limit, App Runner scales up your service.</p>
     *         <p>
     *         Default: <code>100</code>
     */
    public final Integer maxConcurrency() {
        return maxConcurrency;
    }

    /**
     * <p>
     * The minimum number of instances that App Runner provisions for your service. The service always has at least
     * <code>MinSize</code> provisioned instances. Some of them actively serve traffic. The rest of them (provisioned
     * and inactive instances) are a cost-effective compute capacity reserve and are ready to be quickly activated. You
     * pay for memory usage of all the provisioned instances. You pay for CPU usage of only the active subset.
     * </p>
     * <p>
     * App Runner temporarily doubles the number of provisioned instances during deployments, to maintain the same
     * capacity for both old and new code.
     * </p>
     * <p>
     * Default: <code>1</code>
     * </p>
     * 
     * @return The minimum number of instances that App Runner provisions for your service. The service always has at
     *         least <code>MinSize</code> provisioned instances. Some of them actively serve traffic. The rest of them
     *         (provisioned and inactive instances) are a cost-effective compute capacity reserve and are ready to be
     *         quickly activated. You pay for memory usage of all the provisioned instances. You pay for CPU usage of
     *         only the active subset.</p>
     *         <p>
     *         App Runner temporarily doubles the number of provisioned instances during deployments, to maintain the
     *         same capacity for both old and new code.
     *         </p>
     *         <p>
     *         Default: <code>1</code>
     */
    public final Integer minSize() {
        return minSize;
    }

    /**
     * <p>
     * The maximum number of instances that your service scales up to. At most <code>MaxSize</code> instances actively
     * serve traffic for your service.
     * </p>
     * <p>
     * Default: <code>25</code>
     * </p>
     * 
     * @return The maximum number of instances that your service scales up to. At most <code>MaxSize</code> instances
     *         actively serve traffic for your service.</p>
     *         <p>
     *         Default: <code>25</code>
     */
    public final Integer maxSize() {
        return maxSize;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of metadata items that you can associate with your auto scaling configuration resource. A tag is a
     * key-value pair.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A list of metadata items that you can associate with your auto scaling configuration resource. A tag is a
     *         key-value pair.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(autoScalingConfigurationName());
        hashCode = 31 * hashCode + Objects.hashCode(maxConcurrency());
        hashCode = 31 * hashCode + Objects.hashCode(minSize());
        hashCode = 31 * hashCode + Objects.hashCode(maxSize());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAutoScalingConfigurationRequest)) {
            return false;
        }
        CreateAutoScalingConfigurationRequest other = (CreateAutoScalingConfigurationRequest) obj;
        return Objects.equals(autoScalingConfigurationName(), other.autoScalingConfigurationName())
                && Objects.equals(maxConcurrency(), other.maxConcurrency()) && Objects.equals(minSize(), other.minSize())
                && Objects.equals(maxSize(), other.maxSize()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateAutoScalingConfigurationRequest")
                .add("AutoScalingConfigurationName", autoScalingConfigurationName()).add("MaxConcurrency", maxConcurrency())
                .add("MinSize", minSize()).add("MaxSize", maxSize()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AutoScalingConfigurationName":
            return Optional.ofNullable(clazz.cast(autoScalingConfigurationName()));
        case "MaxConcurrency":
            return Optional.ofNullable(clazz.cast(maxConcurrency()));
        case "MinSize":
            return Optional.ofNullable(clazz.cast(minSize()));
        case "MaxSize":
            return Optional.ofNullable(clazz.cast(maxSize()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateAutoScalingConfigurationRequest, T> g) {
        return obj -> g.apply((CreateAutoScalingConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppRunnerRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateAutoScalingConfigurationRequest> {
        /**
         * <p>
         * A name for the auto scaling configuration. When you use it for the first time in an AWS Region, App Runner
         * creates revision number <code>1</code> of this name. When you use the same name in subsequent calls, App
         * Runner creates incremental revisions of the configuration.
         * </p>
         * 
         * @param autoScalingConfigurationName
         *        A name for the auto scaling configuration. When you use it for the first time in an AWS Region, App
         *        Runner creates revision number <code>1</code> of this name. When you use the same name in subsequent
         *        calls, App Runner creates incremental revisions of the configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoScalingConfigurationName(String autoScalingConfigurationName);

        /**
         * <p>
         * The maximum number of concurrent requests that you want an instance to process. If the number of concurrent
         * requests exceeds this limit, App Runner scales up your service.
         * </p>
         * <p>
         * Default: <code>100</code>
         * </p>
         * 
         * @param maxConcurrency
         *        The maximum number of concurrent requests that you want an instance to process. If the number of
         *        concurrent requests exceeds this limit, App Runner scales up your service.</p>
         *        <p>
         *        Default: <code>100</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxConcurrency(Integer maxConcurrency);

        /**
         * <p>
         * The minimum number of instances that App Runner provisions for your service. The service always has at least
         * <code>MinSize</code> provisioned instances. Some of them actively serve traffic. The rest of them
         * (provisioned and inactive instances) are a cost-effective compute capacity reserve and are ready to be
         * quickly activated. You pay for memory usage of all the provisioned instances. You pay for CPU usage of only
         * the active subset.
         * </p>
         * <p>
         * App Runner temporarily doubles the number of provisioned instances during deployments, to maintain the same
         * capacity for both old and new code.
         * </p>
         * <p>
         * Default: <code>1</code>
         * </p>
         * 
         * @param minSize
         *        The minimum number of instances that App Runner provisions for your service. The service always has at
         *        least <code>MinSize</code> provisioned instances. Some of them actively serve traffic. The rest of
         *        them (provisioned and inactive instances) are a cost-effective compute capacity reserve and are ready
         *        to be quickly activated. You pay for memory usage of all the provisioned instances. You pay for CPU
         *        usage of only the active subset.</p>
         *        <p>
         *        App Runner temporarily doubles the number of provisioned instances during deployments, to maintain the
         *        same capacity for both old and new code.
         *        </p>
         *        <p>
         *        Default: <code>1</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minSize(Integer minSize);

        /**
         * <p>
         * The maximum number of instances that your service scales up to. At most <code>MaxSize</code> instances
         * actively serve traffic for your service.
         * </p>
         * <p>
         * Default: <code>25</code>
         * </p>
         * 
         * @param maxSize
         *        The maximum number of instances that your service scales up to. At most <code>MaxSize</code> instances
         *        actively serve traffic for your service.</p>
         *        <p>
         *        Default: <code>25</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxSize(Integer maxSize);

        /**
         * <p>
         * A list of metadata items that you can associate with your auto scaling configuration resource. A tag is a
         * key-value pair.
         * </p>
         * 
         * @param tags
         *        A list of metadata items that you can associate with your auto scaling configuration resource. A tag
         *        is a key-value pair.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * A list of metadata items that you can associate with your auto scaling configuration resource. A tag is a
         * key-value pair.
         * </p>
         * 
         * @param tags
         *        A list of metadata items that you can associate with your auto scaling configuration resource. A tag
         *        is a key-value pair.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * A list of metadata items that you can associate with your auto scaling configuration resource. A tag is a
         * key-value pair.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AppRunnerRequest.BuilderImpl implements Builder {
        private String autoScalingConfigurationName;

        private Integer maxConcurrency;

        private Integer minSize;

        private Integer maxSize;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAutoScalingConfigurationRequest model) {
            super(model);
            autoScalingConfigurationName(model.autoScalingConfigurationName);
            maxConcurrency(model.maxConcurrency);
            minSize(model.minSize);
            maxSize(model.maxSize);
            tags(model.tags);
        }

        public final String getAutoScalingConfigurationName() {
            return autoScalingConfigurationName;
        }

        public final void setAutoScalingConfigurationName(String autoScalingConfigurationName) {
            this.autoScalingConfigurationName = autoScalingConfigurationName;
        }

        @Override
        @Transient
        public final Builder autoScalingConfigurationName(String autoScalingConfigurationName) {
            this.autoScalingConfigurationName = autoScalingConfigurationName;
            return this;
        }

        public final Integer getMaxConcurrency() {
            return maxConcurrency;
        }

        public final void setMaxConcurrency(Integer maxConcurrency) {
            this.maxConcurrency = maxConcurrency;
        }

        @Override
        @Transient
        public final Builder maxConcurrency(Integer maxConcurrency) {
            this.maxConcurrency = maxConcurrency;
            return this;
        }

        public final Integer getMinSize() {
            return minSize;
        }

        public final void setMinSize(Integer minSize) {
            this.minSize = minSize;
        }

        @Override
        @Transient
        public final Builder minSize(Integer minSize) {
            this.minSize = minSize;
            return this;
        }

        public final Integer getMaxSize() {
            return maxSize;
        }

        public final void setMaxSize(Integer maxSize) {
            this.maxSize = maxSize;
        }

        @Override
        @Transient
        public final Builder maxSize(Integer maxSize) {
            this.maxSize = maxSize;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        @Transient
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAutoScalingConfigurationRequest build() {
            return new CreateAutoScalingConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
