/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apprunner.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeCustomDomainsResponse extends AppRunnerResponse implements
        ToCopyableBuilder<DescribeCustomDomainsResponse.Builder, DescribeCustomDomainsResponse> {
    private static final SdkField<String> DNS_TARGET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DNSTarget").getter(getter(DescribeCustomDomainsResponse::dnsTarget)).setter(setter(Builder::dnsTarget))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DNSTarget").build()).build();

    private static final SdkField<String> SERVICE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServiceArn").getter(getter(DescribeCustomDomainsResponse::serviceArn))
            .setter(setter(Builder::serviceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceArn").build()).build();

    private static final SdkField<List<CustomDomain>> CUSTOM_DOMAINS_FIELD = SdkField
            .<List<CustomDomain>> builder(MarshallingType.LIST)
            .memberName("CustomDomains")
            .getter(getter(DescribeCustomDomainsResponse::customDomains))
            .setter(setter(Builder::customDomains))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomDomains").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CustomDomain> builder(MarshallingType.SDK_POJO)
                                            .constructor(CustomDomain::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeCustomDomainsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DNS_TARGET_FIELD,
            SERVICE_ARN_FIELD, CUSTOM_DOMAINS_FIELD, NEXT_TOKEN_FIELD));

    private final String dnsTarget;

    private final String serviceArn;

    private final List<CustomDomain> customDomains;

    private final String nextToken;

    private DescribeCustomDomainsResponse(BuilderImpl builder) {
        super(builder);
        this.dnsTarget = builder.dnsTarget;
        this.serviceArn = builder.serviceArn;
        this.customDomains = builder.customDomains;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The App Runner subdomain of the App Runner service. The associated custom domain names are mapped to this target
     * name.
     * </p>
     * 
     * @return The App Runner subdomain of the App Runner service. The associated custom domain names are mapped to this
     *         target name.
     */
    public final String dnsTarget() {
        return dnsTarget;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the App Runner service whose associated custom domain names you want to
     * describe.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the App Runner service whose associated custom domain names you want to
     *         describe.
     */
    public final String serviceArn() {
        return serviceArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the CustomDomains property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCustomDomains() {
        return customDomains != null && !(customDomains instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of descriptions of custom domain names that are associated with the service. In a paginated request, the
     * request returns up to <code>MaxResults</code> records per call.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCustomDomains} method.
     * </p>
     * 
     * @return A list of descriptions of custom domain names that are associated with the service. In a paginated
     *         request, the request returns up to <code>MaxResults</code> records per call.
     */
    public final List<CustomDomain> customDomains() {
        return customDomains;
    }

    /**
     * <p>
     * The token that you can pass in a subsequent request to get the next result page. It's returned in a paginated
     * request.
     * </p>
     * 
     * @return The token that you can pass in a subsequent request to get the next result page. It's returned in a
     *         paginated request.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dnsTarget());
        hashCode = 31 * hashCode + Objects.hashCode(serviceArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasCustomDomains() ? customDomains() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCustomDomainsResponse)) {
            return false;
        }
        DescribeCustomDomainsResponse other = (DescribeCustomDomainsResponse) obj;
        return Objects.equals(dnsTarget(), other.dnsTarget()) && Objects.equals(serviceArn(), other.serviceArn())
                && hasCustomDomains() == other.hasCustomDomains() && Objects.equals(customDomains(), other.customDomains())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeCustomDomainsResponse").add("DNSTarget", dnsTarget()).add("ServiceArn", serviceArn())
                .add("CustomDomains", hasCustomDomains() ? customDomains() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DNSTarget":
            return Optional.ofNullable(clazz.cast(dnsTarget()));
        case "ServiceArn":
            return Optional.ofNullable(clazz.cast(serviceArn()));
        case "CustomDomains":
            return Optional.ofNullable(clazz.cast(customDomains()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeCustomDomainsResponse, T> g) {
        return obj -> g.apply((DescribeCustomDomainsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppRunnerResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeCustomDomainsResponse> {
        /**
         * <p>
         * The App Runner subdomain of the App Runner service. The associated custom domain names are mapped to this
         * target name.
         * </p>
         * 
         * @param dnsTarget
         *        The App Runner subdomain of the App Runner service. The associated custom domain names are mapped to
         *        this target name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dnsTarget(String dnsTarget);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the App Runner service whose associated custom domain names you want to
         * describe.
         * </p>
         * 
         * @param serviceArn
         *        The Amazon Resource Name (ARN) of the App Runner service whose associated custom domain names you want
         *        to describe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceArn(String serviceArn);

        /**
         * <p>
         * A list of descriptions of custom domain names that are associated with the service. In a paginated request,
         * the request returns up to <code>MaxResults</code> records per call.
         * </p>
         * 
         * @param customDomains
         *        A list of descriptions of custom domain names that are associated with the service. In a paginated
         *        request, the request returns up to <code>MaxResults</code> records per call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customDomains(Collection<CustomDomain> customDomains);

        /**
         * <p>
         * A list of descriptions of custom domain names that are associated with the service. In a paginated request,
         * the request returns up to <code>MaxResults</code> records per call.
         * </p>
         * 
         * @param customDomains
         *        A list of descriptions of custom domain names that are associated with the service. In a paginated
         *        request, the request returns up to <code>MaxResults</code> records per call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customDomains(CustomDomain... customDomains);

        /**
         * <p>
         * A list of descriptions of custom domain names that are associated with the service. In a paginated request,
         * the request returns up to <code>MaxResults</code> records per call.
         * </p>
         * This is a convenience that creates an instance of the {@link List<CustomDomain>.Builder} avoiding the need to
         * create one manually via {@link List<CustomDomain>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<CustomDomain>.Builder#build()} is called immediately and its
         * result is passed to {@link #customDomains(List<CustomDomain>)}.
         * 
         * @param customDomains
         *        a consumer that will call methods on {@link List<CustomDomain>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customDomains(List<CustomDomain>)
         */
        Builder customDomains(Consumer<CustomDomain.Builder>... customDomains);

        /**
         * <p>
         * The token that you can pass in a subsequent request to get the next result page. It's returned in a paginated
         * request.
         * </p>
         * 
         * @param nextToken
         *        The token that you can pass in a subsequent request to get the next result page. It's returned in a
         *        paginated request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends AppRunnerResponse.BuilderImpl implements Builder {
        private String dnsTarget;

        private String serviceArn;

        private List<CustomDomain> customDomains = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCustomDomainsResponse model) {
            super(model);
            dnsTarget(model.dnsTarget);
            serviceArn(model.serviceArn);
            customDomains(model.customDomains);
            nextToken(model.nextToken);
        }

        public final String getDnsTarget() {
            return dnsTarget;
        }

        public final void setDnsTarget(String dnsTarget) {
            this.dnsTarget = dnsTarget;
        }

        @Override
        @Transient
        public final Builder dnsTarget(String dnsTarget) {
            this.dnsTarget = dnsTarget;
            return this;
        }

        public final String getServiceArn() {
            return serviceArn;
        }

        public final void setServiceArn(String serviceArn) {
            this.serviceArn = serviceArn;
        }

        @Override
        @Transient
        public final Builder serviceArn(String serviceArn) {
            this.serviceArn = serviceArn;
            return this;
        }

        public final List<CustomDomain.Builder> getCustomDomains() {
            List<CustomDomain.Builder> result = CustomDomainListCopier.copyToBuilder(this.customDomains);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCustomDomains(Collection<CustomDomain.BuilderImpl> customDomains) {
            this.customDomains = CustomDomainListCopier.copyFromBuilder(customDomains);
        }

        @Override
        @Transient
        public final Builder customDomains(Collection<CustomDomain> customDomains) {
            this.customDomains = CustomDomainListCopier.copy(customDomains);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder customDomains(CustomDomain... customDomains) {
            customDomains(Arrays.asList(customDomains));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder customDomains(Consumer<CustomDomain.Builder>... customDomains) {
            customDomains(Stream.of(customDomains).map(c -> CustomDomain.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeCustomDomainsResponse build() {
            return new DescribeCustomDomainsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
