/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apprunner.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.apprunner.AppRunnerAsyncClient;
import software.amazon.awssdk.services.apprunner.internal.UserAgentUtils;
import software.amazon.awssdk.services.apprunner.model.ListServicesForAutoScalingConfigurationRequest;
import software.amazon.awssdk.services.apprunner.model.ListServicesForAutoScalingConfigurationResponse;

public class ListServicesForAutoScalingConfigurationPublisher
implements SdkPublisher<ListServicesForAutoScalingConfigurationResponse> {
    private final AppRunnerAsyncClient client;
    private final ListServicesForAutoScalingConfigurationRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListServicesForAutoScalingConfigurationPublisher(AppRunnerAsyncClient client, ListServicesForAutoScalingConfigurationRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListServicesForAutoScalingConfigurationPublisher(AppRunnerAsyncClient client, ListServicesForAutoScalingConfigurationRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListServicesForAutoScalingConfigurationResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListServicesForAutoScalingConfigurationResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListServicesForAutoScalingConfigurationResponseFetcher
    implements AsyncPageFetcher<ListServicesForAutoScalingConfigurationResponse> {
        private ListServicesForAutoScalingConfigurationResponseFetcher() {
        }

        public boolean hasNextPage(ListServicesForAutoScalingConfigurationResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListServicesForAutoScalingConfigurationResponse> nextPage(ListServicesForAutoScalingConfigurationResponse previousPage) {
            if (previousPage == null) {
                return ListServicesForAutoScalingConfigurationPublisher.this.client.listServicesForAutoScalingConfiguration(ListServicesForAutoScalingConfigurationPublisher.this.firstRequest);
            }
            return ListServicesForAutoScalingConfigurationPublisher.this.client.listServicesForAutoScalingConfiguration((ListServicesForAutoScalingConfigurationRequest)((Object)ListServicesForAutoScalingConfigurationPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

