/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apprunner.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteObservabilityConfigurationResponse extends AppRunnerResponse implements
        ToCopyableBuilder<DeleteObservabilityConfigurationResponse.Builder, DeleteObservabilityConfigurationResponse> {
    private static final SdkField<ObservabilityConfiguration> OBSERVABILITY_CONFIGURATION_FIELD = SdkField
            .<ObservabilityConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("ObservabilityConfiguration")
            .getter(getter(DeleteObservabilityConfigurationResponse::observabilityConfiguration))
            .setter(setter(Builder::observabilityConfiguration))
            .constructor(ObservabilityConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObservabilityConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(OBSERVABILITY_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final ObservabilityConfiguration observabilityConfiguration;

    private DeleteObservabilityConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.observabilityConfiguration = builder.observabilityConfiguration;
    }

    /**
     * <p>
     * A description of the App Runner observability configuration that this request just deleted.
     * </p>
     * 
     * @return A description of the App Runner observability configuration that this request just deleted.
     */
    public final ObservabilityConfiguration observabilityConfiguration() {
        return observabilityConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(observabilityConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteObservabilityConfigurationResponse)) {
            return false;
        }
        DeleteObservabilityConfigurationResponse other = (DeleteObservabilityConfigurationResponse) obj;
        return Objects.equals(observabilityConfiguration(), other.observabilityConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteObservabilityConfigurationResponse")
                .add("ObservabilityConfiguration", observabilityConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ObservabilityConfiguration":
            return Optional.ofNullable(clazz.cast(observabilityConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ObservabilityConfiguration", OBSERVABILITY_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteObservabilityConfigurationResponse, T> g) {
        return obj -> g.apply((DeleteObservabilityConfigurationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppRunnerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DeleteObservabilityConfigurationResponse> {
        /**
         * <p>
         * A description of the App Runner observability configuration that this request just deleted.
         * </p>
         * 
         * @param observabilityConfiguration
         *        A description of the App Runner observability configuration that this request just deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder observabilityConfiguration(ObservabilityConfiguration observabilityConfiguration);

        /**
         * <p>
         * A description of the App Runner observability configuration that this request just deleted.
         * </p>
         * This is a convenience method that creates an instance of the {@link ObservabilityConfiguration.Builder}
         * avoiding the need to create one manually via {@link ObservabilityConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ObservabilityConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #observabilityConfiguration(ObservabilityConfiguration)}.
         * 
         * @param observabilityConfiguration
         *        a consumer that will call methods on {@link ObservabilityConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #observabilityConfiguration(ObservabilityConfiguration)
         */
        default Builder observabilityConfiguration(Consumer<ObservabilityConfiguration.Builder> observabilityConfiguration) {
            return observabilityConfiguration(ObservabilityConfiguration.builder().applyMutation(observabilityConfiguration)
                    .build());
        }
    }

    static final class BuilderImpl extends AppRunnerResponse.BuilderImpl implements Builder {
        private ObservabilityConfiguration observabilityConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteObservabilityConfigurationResponse model) {
            super(model);
            observabilityConfiguration(model.observabilityConfiguration);
        }

        public final ObservabilityConfiguration.Builder getObservabilityConfiguration() {
            return observabilityConfiguration != null ? observabilityConfiguration.toBuilder() : null;
        }

        public final void setObservabilityConfiguration(ObservabilityConfiguration.BuilderImpl observabilityConfiguration) {
            this.observabilityConfiguration = observabilityConfiguration != null ? observabilityConfiguration.build() : null;
        }

        @Override
        public final Builder observabilityConfiguration(ObservabilityConfiguration observabilityConfiguration) {
            this.observabilityConfiguration = observabilityConfiguration;
            return this;
        }

        @Override
        public DeleteObservabilityConfigurationResponse build() {
            return new DeleteObservabilityConfigurationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
